/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.Junction;
import com.avaje.ebean.Page;
import com.avaje.ebean.annotation.Transactional;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.feth.play.module.mail.Mailer;
import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.user.AuthUserIdentity;
import controllers.Application;
import controllers.ProjectApp;
import controllers.annotation.AnonymousCheck;
import controllers.routes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import jxl.write.WriteException;
import models.AbstractPosting;
import models.Attachment;
import models.AuthInfo;
import models.CandidateUser;
import models.Email;
import models.Issue;
import models.NotificationMail;
import models.Organization;
import models.Project;
import models.PullRequest;
import models.RecentProject;
import models.User;
import models.UserCredential;
import models.UserSetting;
import models.UserVerification;
import models.enumeration.Operation;
import models.enumeration.UserState;
import models.support.LdapUser;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.util.ByteSource;
import org.joda.time.LocalDateTime;
import play.Configuration;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.libs.Json;
import play.mvc.BodyParser;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.CacheStore;
import utils.Config;
import utils.ErrorViews;
import utils.HtmlUtil;
import utils.HttpUtil;
import utils.LdapService;
import utils.PasswordReset;
import utils.ReservedWordsValidator;
import views.html.common.usermenu_tab_content_list;
import views.html.user.edit;
import views.html.user.edit_emails;
import views.html.user.edit_notifications;
import views.html.user.edit_password;
import views.html.user.edit_token;
import views.html.user.login;
import views.html.user.signup;
import views.html.user.userFiles;
import views.html.user.verified;
import views.html.user.view;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class UserApp
extends Controller {
    public static final String SESSION_USERID = "userId";
    public static final String SESSION_LOGINID = "loginId";
    public static final String SESSION_USERNAME = "userName";
    public static final String SESSION_KEY = "key";
    public static final String TOKEN = "yobi.token";
    public static final String TOKEN_SEPARATOR = ":";
    public static final int TOKEN_LENGTH = 2;
    public static final int MAX_AGE = 2592000;
    public static final String DEFAULT_AVATAR_URL = routes.Assets.at("images/default-avatar-128.png").url();
    private static final int AVATAR_FILE_LIMIT_SIZE = 1024000;
    public static final int MAX_FETCH_USERS = 10;
    private static final int HASH_ITERATIONS = 1024;
    public static final int DAYS_AGO = 14;
    public static final int UNDEFINED = 0;
    public static final String DAYS_AGO_COOKIE = "daysAgo";
    public static final String DEFAULT_GROUP = "own";
    public static final String DEFAULT_SELECTED_TAB = "projects";
    public static final String TOKEN_USER = "TOKEN_USER";
    public static final String USER_TOKEN_HEADER = "Yona-Token";
    public static final boolean useSocialLoginOnly = Configuration.root().getBoolean("application.use.social.login.only", Boolean.valueOf(false));
    public static final String FLASH_MESSAGE_KEY = "message";
    public static final String FLASH_ERROR_KEY = "error";
    private static boolean usingEmailVerification = Configuration.root().getBoolean("application.use.email.verification", Boolean.valueOf(false));

    @AnonymousCheck
    public static Result users(String query) {
        String referer = StringUtils.defaultString((String)UserApp.request().getHeader("referer"), (String)"");
        if (!referer.endsWith("members") || !UserApp.request().accepts("application/json")) {
            return UserApp.status((int)406);
        }
        if (StringUtils.isEmpty((CharSequence)query)) {
            return UserApp.ok((JsonNode)Json.toJson(new ArrayList()));
        }
        ArrayList users2 = new ArrayList();
        Junction el = User.find.select("loginId, name").where().ne("state", (Object)UserState.DELETED).disjunction();
        el.icontains(SESSION_LOGINID, query);
        el.icontains("name", query);
        el.endJunction();
        int total = el.findRowCount();
        if (total > 10) {
            el.setMaxRows(10);
            UserApp.response().setHeader("Content-Range", "items 10/" + total);
        }
        for (User user : el.findList()) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("<img class='mention_image' src='%s'>", user.avatarUrl()));
            Object[] objectArray = new Object[1];
            User user2 = user;
            String string = null;
            string = user2.getName();
            objectArray[0] = string;
            sb.append(String.format("<b class='mention_name'>%s</b>", objectArray));
            Object[] objectArray2 = new Object[1];
            user2 = user;
            string = null;
            string = user2.getLoginId();
            objectArray2[0] = string;
            sb.append(String.format("<span class='mention_username'> @%s</span>", objectArray2));
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("info", sb.toString());
            user2 = user;
            string = null;
            string = user2.getLoginId();
            userMap.put(SESSION_LOGINID, string);
            users2.add(userMap);
        }
        return UserApp.ok((JsonNode)Json.toJson(users2));
    }

    public static void noCache(Http.Response response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    public static Result loginForm() {
        UserApp.noCache(UserApp.response());
        if (!UserApp.currentUser().isAnonymous()) {
            return UserApp.redirect((Call)routes.Application.index());
        }
        String redirectUrl = UserApp.request().getQueryString("redirectUrl");
        String loginFormUrl = routes.UserApp.loginForm().url();
        String referer = UserApp.request().getHeader("Referer");
        if (StringUtils.isEmpty((CharSequence)redirectUrl) && !StringUtils.equals((CharSequence)loginFormUrl, (CharSequence)referer)) {
            redirectUrl = UserApp.request().getHeader("Referer");
        }
        if (PlayAuthenticate.isLoggedIn((Http.Session)UserApp.session())) {
            UserApp.linkWithExistedOrCreateLocalUser();
            return UserApp.redirect((String)redirectUrl);
        }
        return UserApp.ok((Content)login.render("title.login", (Form<AuthInfo>)Form.form(AuthInfo.class), redirectUrl));
    }

    public static Result logout() {
        UserApp.processLogout();
        UserApp.flash((String)"success", (String)"user.logout.success");
        String redirectUrl = UserApp.request().getHeader("Referer");
        return UserApp.redirect((String)redirectUrl);
    }

    public static Result login() {
        UserApp.noCache(UserApp.response());
        if (useSocialLoginOnly) {
            UserApp.flash((String)FLASH_ERROR_KEY, (String)Messages.get((String)"app.warn.support.social.login.only", (Object[])new Object[0]));
            return Application.index();
        }
        if (HttpUtil.isJSONPreferred(UserApp.request()).booleanValue()) {
            return UserApp.loginByAjaxRequest();
        }
        return UserApp.loginByFormRequest();
    }

    private static Result loginByFormRequest() {
        Form authInfoForm = Form.form(AuthInfo.class).bindFromRequest(new String[0]);
        if (authInfoForm.hasErrors()) {
            UserApp.flash((String)"warning", (String)"user.login.required");
            return UserApp.badRequest((Content)login.render("title.login", (Form<AuthInfo>)authInfoForm, null));
        }
        Object object = (AuthInfo)authInfoForm.get();
        Object object2 = null;
        object2 = ((AuthInfo)object).getLoginIdOrEmail();
        User sourceUser = User.findByLoginKey(object2);
        if (UserApp.isUsingSignUpConfirm()) {
            object = sourceUser;
            object2 = null;
            object2 = ((User)object).getLoginId();
            object = User.findByLoginId(object2);
            object2 = null;
            object2 = ((User)object).getState();
            if (object2 == UserState.LOCKED) {
                UserApp.flash((String)"warning", (String)"user.locked");
                return UserApp.redirect((String)UserApp.getLoginFormURLWithRedirectURL());
            }
        }
        object = sourceUser;
        object2 = null;
        object2 = ((User)object).getLoginId();
        object = User.findByLoginId(object2);
        object2 = null;
        object2 = ((User)object).getState();
        if (object2 == UserState.DELETED) {
            UserApp.flash((String)"warning", (String)"user.deleted");
            return UserApp.redirect((String)UserApp.getLoginFormURLWithRedirectURL());
        }
        User authenticate = User.anonymous;
        if (LdapService.useLdap) {
            object = (AuthInfo)authInfoForm.get();
            object2 = null;
            Object object3 = object2 = ((AuthInfo)object).getLoginIdOrEmail();
            object = (AuthInfo)authInfoForm.get();
            object2 = null;
            object2 = ((AuthInfo)object).getPassword();
            authenticate = UserApp.authenticateWithLdap(object3, object2);
        } else {
            object = sourceUser;
            object2 = null;
            Object object4 = object2 = ((User)object).getLoginId();
            object = (AuthInfo)authInfoForm.get();
            object2 = null;
            object2 = ((AuthInfo)object).getPassword();
            authenticate = UserApp.authenticateWithPlainPassword(object4, object2);
        }
        if (!authenticate.isAnonymous()) {
            authenticate.refresh();
        }
        if (authenticate.isLocked()) {
            UserApp.flash((String)"warning", (String)"user.locked");
            return UserApp.logout();
        }
        if (!authenticate.isAnonymous()) {
            UserApp.addUserInfoToSession(authenticate);
            object = (AuthInfo)authInfoForm.get();
            boolean bl = false;
            bl = ((AuthInfo)object).getRememberMe();
            if (bl) {
                UserApp.setupRememberMe(authenticate);
            }
            String string = Http.Context.current().lang().code();
            object = authenticate;
            ((User)object).setLang(string);
            authenticate.update();
            String redirectUrl = UserApp.getRedirectURLFromParams();
            if (StringUtils.isEmpty((CharSequence)redirectUrl)) {
                return UserApp.redirect((Call)routes.Application.index());
            }
            return UserApp.redirect((String)UserApp.encodedPath(redirectUrl));
        }
        UserApp.flash((String)"warning", (String)"user.login.invalid");
        return UserApp.redirect((String)UserApp.getLoginFormURLWithRedirectURL());
    }

    private static String encodedPath(String path) {
        String[] paths = path.split("/");
        if (paths.length == 0) {
            return "/";
        }
        CharSequence[] encodedPaths = new String[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            encodedPaths[i] = HttpUtil.encodeUrlString(paths[i]);
        }
        return String.join((CharSequence)"/", encodedPaths);
    }

    private static Result loginByAjaxRequest() {
        Form authInfoForm = Form.form(AuthInfo.class).bindFromRequest(new String[0]);
        if (authInfoForm.hasErrors()) {
            return UserApp.badRequest((JsonNode)UserApp.getObjectNodeWithMessage("user.login.required"));
        }
        Object object = (AuthInfo)authInfoForm.get();
        Object object2 = null;
        object2 = ((AuthInfo)object).getLoginIdOrEmail();
        User sourceUser = User.findByLoginKey(object2);
        if (UserApp.isUsingSignUpConfirm()) {
            object = sourceUser;
            object2 = null;
            object2 = ((User)object).getLoginId();
            object = User.findByLoginId(object2);
            object2 = null;
            object2 = ((User)object).getState();
            if (object2 == UserState.LOCKED) {
                return UserApp.forbidden((JsonNode)UserApp.getObjectNodeWithMessage("user.locked"));
            }
        }
        object = sourceUser;
        object2 = null;
        object2 = ((User)object).getLoginId();
        object = User.findByLoginId(object2);
        object2 = null;
        object2 = ((User)object).getState();
        if (object2 == UserState.DELETED) {
            return UserApp.notFound((JsonNode)UserApp.getObjectNodeWithMessage("user.deleted"));
        }
        User user = User.anonymous;
        if (LdapService.useLdap) {
            object = (AuthInfo)authInfoForm.get();
            object2 = null;
            Object object3 = object2 = ((AuthInfo)object).getLoginIdOrEmail();
            object = (AuthInfo)authInfoForm.get();
            object2 = null;
            object2 = ((AuthInfo)object).getPassword();
            user = UserApp.authenticateWithLdap(object3, object2);
        } else {
            object = sourceUser;
            object2 = null;
            Object object4 = object2 = ((User)object).getLoginId();
            object = (AuthInfo)authInfoForm.get();
            object2 = null;
            object2 = ((AuthInfo)object).getPassword();
            user = UserApp.authenticateWithPlainPassword(object4, object2);
        }
        if (user.isLocked()) {
            return UserApp.forbidden((JsonNode)UserApp.getObjectNodeWithMessage("user.locked"));
        }
        if (!user.isAnonymous()) {
            object = (AuthInfo)authInfoForm.get();
            boolean bl = false;
            bl = ((AuthInfo)object).getRememberMe();
            if (bl) {
                UserApp.setupRememberMe(user);
            }
            user.refresh();
            String string = Http.Context.current().lang().code();
            object = user;
            ((User)object).setLang(string);
            user.update();
            UserApp.addUserInfoToSession(user);
            return UserApp.ok((String)"{}");
        }
        return UserApp.forbidden((JsonNode)UserApp.getObjectNodeWithMessage("user.login.invalid"));
    }

    private static String getRedirectURLFromParams() {
        Map params = UserApp.request().body().asFormUrlEncoded();
        return HttpUtil.getFirstValueFromQuery(params, "redirectUrl");
    }

    private static String getLoginFormURLWithRedirectURL() {
        String redirectUrl = UserApp.getRedirectURLFromParams();
        String loginFormUrl = routes.UserApp.loginForm().url();
        loginFormUrl = loginFormUrl + "?redirectUrl=" + redirectUrl;
        return loginFormUrl;
    }

    private static ObjectNode getObjectNodeWithMessage(String message) {
        ObjectNode result2 = Json.newObject();
        result2.put(FLASH_MESSAGE_KEY, message);
        return result2;
    }

    public static User authenticateWithHashedPassword(String loginId, String password) {
        return UserApp.authenticate(loginId, password, true);
    }

    public static User authenticateWithPlainPassword(String loginId, String password) {
        return UserApp.authenticate(loginId, password, false);
    }

    public static Result signupForm() {
        if (!UserApp.currentUser().isAnonymous()) {
            return UserApp.redirect((Call)routes.Application.index());
        }
        return UserApp.ok((Content)signup.render("title.signup", (Form<User>)Form.form(User.class)));
    }

    @Transactional
    public static Result newUser() {
        Form newUserForm = Form.form(User.class).bindFromRequest(new String[0]);
        UserApp.validate((Form<User>)newUserForm);
        if (newUserForm.hasErrors()) {
            return UserApp.badRequest((Content)signup.render("title.signup", (Form<User>)newUserForm));
        }
        User user = (User)newUserForm.get();
        Object object = null;
        object = user.getEmail();
        if (!NotificationMail.isAllowedEmailDomains(object)) {
            UserApp.flash((String)"info", (String)"user.unacceptable.email.domain");
            user = (User)newUserForm.get();
            object = null;
            object = user.getName();
            StringBuilder stringBuilder = new StringBuilder().append("Signup rejected: ").append((String)object).append(" with ");
            user = (User)newUserForm.get();
            object = null;
            object = user.getEmail();
            Logger.warn((String)stringBuilder.append((String)object).toString());
            return UserApp.badRequest((Content)signup.render("title.signup", (Form<User>)newUserForm));
        }
        User user2 = UserApp.createNewUser((User)newUserForm.get());
        if (UserApp.isUsingEmailVerification()) {
            user = user2;
            object = null;
            object = user.getEmail();
            if (NotificationMail.isAllowedEmailDomains(object)) {
                UserApp.flash((String)"info", (String)"user.verification.mail.sent");
            } else {
                UserApp.flash((String)"info", (String)"user.unacceptable.email.domain");
            }
        }
        user = user2;
        object = null;
        object = user.getState();
        if (object == UserState.LOCKED && UserApp.isUsingSignUpConfirm()) {
            UserApp.flash((String)"info", (String)"user.signup.requested");
        } else {
            UserApp.addUserInfoToSession(user2);
        }
        return UserApp.redirect((Call)routes.Application.index());
    }

    private static String newLoginIdWithoutDup(String candidate, int num) {
        String newLoginIdSuggestion = candidate + "" + num;
        if (User.findByLoginId(newLoginIdSuggestion).isAnonymous()) {
            return newLoginIdSuggestion;
        }
        return UserApp.newLoginIdWithoutDup(newLoginIdSuggestion, ++num);
    }

    public static User createLocalUserWithOAuth(UserCredential userCredential) {
        Object object;
        Model model;
        block5: {
            block4: {
                model = userCredential;
                object = null;
                object = model.getEmail();
                if (object == null) break block4;
                model = userCredential;
                object = null;
                object = model.getEmail();
                if (!"null".equalsIgnoreCase((String)object)) break block5;
            }
            UserApp.flash((String)FLASH_ERROR_KEY, (String)Messages.get((String)"app.warn.cannot.access.email.information", (Object[])new Object[0]));
            model = userCredential;
            object = null;
            object = model.getId();
            StringBuilder stringBuilder = new StringBuilder().append("Cannot confirm email address of ").append(object).append(": ");
            model = userCredential;
            object = null;
            object = model.getName();
            Logger.error((String)stringBuilder.append((String)object).toString());
            userCredential.delete();
            UserApp.forceOAuthLogout();
            return User.anonymous;
        }
        model = userCredential;
        object = null;
        object = model.getEmail();
        if (!NotificationMail.isAllowedEmailDomains((String)object)) {
            UserApp.flash((String)"info", (String)"user.unacceptable.email.domain");
            model = userCredential;
            object = null;
            object = model.getName();
            StringBuilder stringBuilder = new StringBuilder().append("Signup rejected: ").append((String)object).append(" with ");
            model = userCredential;
            object = null;
            object = model.getEmail();
            Logger.warn((String)stringBuilder.append((String)object).toString());
            userCredential.delete();
            UserApp.forceOAuthLogout();
            return User.anonymous;
        }
        model = userCredential;
        object = null;
        Object object2 = object = model.getName();
        model = userCredential;
        object = null;
        object = model.getEmail();
        CandidateUser candidateUser = new CandidateUser((String)object2, (String)object);
        User created = UserApp.createUserDelegate(candidateUser);
        created.refresh();
        object = UserState.ACTIVE;
        model = created;
        model.setState((UserState)((Object)object));
        created.update();
        model = created;
        object = null;
        object = model.getLoginId();
        model = userCredential;
        model.setLoginId((String)object);
        object = created;
        model = userCredential;
        model.setUser((User)object);
        userCredential.update();
        return created;
    }

    private static void forceOAuthLogout() {
        UserApp.session().put("pa.url.orig", routes.Application.oAuthLogout().url());
    }

    private static User createUserDelegate(CandidateUser candidateUser) {
        String loginIdCandidate = candidateUser.getLoginId();
        User user = new User();
        if (StringUtils.isBlank((CharSequence)loginIdCandidate) || LdapService.USE_EMAIL_BASE_LOGIN) {
            loginIdCandidate = candidateUser.getEmail().substring(0, candidateUser.getEmail().indexOf("@"));
            loginIdCandidate = UserApp.generateLoginId(user, loginIdCandidate);
        }
        String string = loginIdCandidate;
        User user2 = user;
        user2.setLoginId(string);
        string = candidateUser.getName();
        user2 = user;
        user2.setName(string);
        string = candidateUser.getEmail();
        user2 = user;
        user2.setEmail(string);
        if (StringUtils.isEmpty((CharSequence)candidateUser.getPassword())) {
            string = new SecureRandomNumberGenerator().nextBytes().toBase64();
            user2 = user;
            user2.setPassword(string);
        } else {
            string = candidateUser.getPassword();
            user2 = user;
            user2.setPassword(string);
        }
        boolean bl = candidateUser.isGuest();
        user2 = user;
        user2.setIsGuest(bl);
        return UserApp.createNewUser(user);
    }

    public static Result verifyUser(String loginId, String verificationCode) {
        if (!UserApp.currentUser().isAnonymous()) {
            return UserApp.redirect((Call)routes.Application.index());
        }
        UserVerification uv = UserVerification.findbyLoginIdAndVerificationCode(loginId, verificationCode);
        if (uv == null) {
            return UserApp.notFound((String)"Invalid verification");
        }
        if (uv.isValidDate()) {
            User user = User.findByLoginId(loginId);
            UserState userState = UserState.ACTIVE;
            User user2 = user;
            user2.setState(userState);
            user.update();
            uv.invalidate();
            return UserApp.ok((Content)verified.render("", loginId));
        }
        return UserApp.notFound((String)"Invalid verification");
    }

    private static void sendMailAfterUserCreation(User created) {
        User user = created;
        String string = null;
        string = user.getEmail();
        if (!NotificationMail.isAllowedEmailDomains(string)) {
            UserApp.flash((String)"info", (String)"user.unacceptable.email.domain");
            return;
        }
        String[] stringArray = new String[1];
        user = created;
        string = null;
        String string2 = string = user.getEmail();
        user = created;
        string = null;
        string = user.getName();
        stringArray[0] = Mailer.getEmailName((String)string2, (String)string);
        Mailer.Mail mail2 = new Mailer.Mail(Messages.get((String)"user.verification.signup.confirm", (Object[])new Object[0]) + ": " + UserApp.getServeIndexPageUrl(), UserApp.getNewAccountMailBody(created), stringArray);
        Mailer mailer = Mailer.getCustomMailer((Configuration)Configuration.root().getConfig("play-easymail"));
        mailer.sendMail(mail2);
    }

    private static Mailer.Mail.Body getNewAccountMailBody(User user) {
        String passwordResetUrl = UserApp.getServeIndexPageUrl() + routes.PasswordResetApp.lostPassword();
        StringBuilder html = new StringBuilder();
        StringBuilder plainText = new StringBuilder();
        if (UserApp.isUsingEmailVerification()) {
            UserApp.setVerificationMessage(user, html, plainText);
        }
        UserApp.setSignupInfomation(user, passwordResetUrl, html, plainText);
        return new Mailer.Mail.Body(plainText.toString(), html.toString());
    }

    private static void setSignupInfomation(User user, String passwordResetUrl, StringBuilder html, StringBuilder plainText) {
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        StringBuilder stringBuilder = html.append("URL: <a href='").append(UserApp.getServeIndexPageUrl()).append("'>").append(UserApp.getServeIndexPageUrl()).append("</a><br/>\n").append("ID: ").append(string).append("<br/>\n").append("Email: ");
        user2 = user;
        string = null;
        string = user2.getEmail();
        stringBuilder.append(string).append("<br/>\n<br/>\n").append("Password reset: <a href='").append(passwordResetUrl).append("' target='_blank'>").append(passwordResetUrl).append("</a><br/>\n");
        user2 = user;
        string = null;
        string = user2.getLoginId();
        StringBuilder stringBuilder2 = plainText.append("URL: ").append(UserApp.getServeIndexPageUrl()).append("\n").append("ID: ").append(string).append("\n").append("Email: ");
        user2 = user;
        string = null;
        string = user2.getEmail();
        stringBuilder2.append(string).append("\n\n").append("Password reset: ").append(passwordResetUrl).append("\n");
    }

    private static void setVerificationMessage(User user, StringBuilder html, StringBuilder plainText) {
        UserVerification verification = UserVerification.findbyUser(user);
        if (verification == null) {
            verification = UserVerification.newVerification(user);
        }
        Model model = user;
        String string = null;
        String string2 = string = model.getLoginId();
        model = verification;
        string = null;
        string = model.getVerificationCode();
        String verificationUrl = UserApp.getServeIndexPageUrl() + routes.UserApp.verifyUser(string2, string).toString();
        html.append("<h1>").append(Messages.get((String)"user.verification", (Object[])new Object[0])).append("</h1>\n");
        html.append("<hr />\n");
        html.append("<p><a href='").append(verificationUrl).append("'>").append(Messages.get((String)"user.verification.link.click", (Object[])new Object[0])).append("</a></p>\n");
        html.append("<br />\n");
        html.append("<br />\n");
        plainText.append(Messages.get((String)"user.verification", (Object[])new Object[0])).append("\n");
        plainText.append("--------------------------\n");
        plainText.append(verificationUrl).append("\n");
        plainText.append("\n");
        plainText.append("\n");
    }

    private static String getServeIndexPageUrl() {
        StringBuilder url = new StringBuilder();
        if (UserApp.request().secure()) {
            url.append("https://");
        } else {
            url.append("http://");
        }
        url.append(Config.getHostport("localhost:9000"));
        return url.toString();
    }

    private static String generateLoginId(User user, String loginIdCandidate) {
        User sameLoginIdUser = User.findByLoginId(loginIdCandidate);
        if (sameLoginIdUser.isAnonymous()) {
            return loginIdCandidate;
        }
        sameLoginIdUser = User.findByLoginId(loginIdCandidate + "-yona");
        if (sameLoginIdUser.isAnonymous()) {
            return loginIdCandidate + "-yona";
        }
        return UserApp.newLoginIdWithoutDup(loginIdCandidate, 2);
    }

    @Transactional
    public static Result resetUserPassword() {
        User user;
        Form userForm = Form.form(User.class).bindFromRequest(new String[0]);
        if (userForm.hasErrors()) {
            return UserApp.badRequest((Content)ErrorViews.BadRequest.render("error.badrequest"));
        }
        User currentUser = UserApp.currentUser();
        User user2 = user = (User)userForm.get();
        String string = null;
        string = user2.getOldPassword();
        if (!UserApp.isValidPassword(currentUser, string)) {
            Form currentUserForm = new Form(User.class);
            currentUserForm = currentUserForm.fill((Object)currentUser);
            UserApp.flash((String)"warning", (String)"user.wrongPassword.alert");
            return UserApp.badRequest((Content)edit.render((Form<User>)currentUserForm, currentUser));
        }
        user2 = user;
        string = null;
        string = user2.getPassword();
        UserApp.resetPassword(currentUser, string);
        UserApp.processLogout();
        UserApp.flash((String)"warning", (String)"user.loginWithNewPassword");
        return UserApp.redirect((Call)routes.UserApp.loginForm());
    }

    public static Result resetUserVisitedList() {
        RecentProject.deleteAll(UserApp.currentUser());
        UserApp.flash((String)"info", (String)"userinfo.reset.visited.project.list.done");
        return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
    }

    public static boolean isValidPassword(User currentUser, String password) {
        User user = currentUser;
        String string = null;
        string = user.getPasswordSalt();
        String hashedOldPassword = UserApp.hashedPassword(password, string);
        user = currentUser;
        string = null;
        string = user.getPassword();
        return string.equals(hashedOldPassword);
    }

    @Transactional
    public static void resetPassword(User user, String newPassword) {
        User user2 = user;
        String string = null;
        string = user2.getPasswordSalt();
        string = UserApp.hashedPassword(newPassword, string);
        user2 = user;
        user2.setPassword(string);
        user.save();
    }

    @Transactional
    public static User currentUser() {
        User user = UserApp.getUserFromSession();
        if (!user.isAnonymous()) {
            return user;
        }
        if (!(user = User.findUserIfTokenExist(user)).isAnonymous()) {
            return user;
        }
        return UserApp.getUserFromContext();
    }

    private static User getUserFromSession() {
        String userId = (String)UserApp.session().get((Object)SESSION_USERID);
        String userKey = (String)UserApp.session().get((Object)SESSION_KEY);
        if (userId == null) {
            return User.anonymous;
        }
        if (!StringUtils.isNumeric((CharSequence)userId)) {
            return UserApp.invalidSession();
        }
        User user = null;
        if (userKey != null && Long.valueOf(userId) != null) {
            user = (User)CacheStore.yonaUsers.getIfPresent((Object)Long.valueOf(userId));
        }
        if (user == null || user.isLocked()) {
            return UserApp.invalidSession();
        }
        return user;
    }

    private static User getUserFromContext() {
        Object cached = Http.Context.current().args.get(TOKEN_USER);
        if (cached instanceof User) {
            return (User)cached;
        }
        UserApp.initTokenUser();
        User foundUser = (User)Http.Context.current().args.get(TOKEN_USER);
        if (foundUser.isLocked()) {
            UserApp.processLogout();
            return User.anonymous;
        }
        return foundUser;
    }

    public static void initTokenUser() {
        User user = UserApp.getUserFromToken();
        Http.Context.current().args.put(TOKEN_USER, user);
        if (!user.isAnonymous() && UserApp.getUserFromSession().isAnonymous()) {
            UserApp.addUserInfoToSession(user);
        }
    }

    private static User getUserFromToken() {
        Http.Cookie cookie = UserApp.request().cookies().get(TOKEN);
        if (cookie == null) {
            return User.anonymous;
        }
        String[] subject = StringUtils.split((String)cookie.value(), (String)TOKEN_SEPARATOR);
        if (ArrayUtils.getLength((Object)subject) != 2) {
            return UserApp.invalidToken();
        }
        User user = UserApp.authenticateWithHashedPassword(subject[0], subject[1]);
        if (user.isAnonymous()) {
            return UserApp.invalidToken();
        }
        return user;
    }

    private static User invalidSession() {
        UserApp.session().clear();
        return User.anonymous;
    }

    private static User invalidToken() {
        UserApp.response().discardCookie(TOKEN);
        return User.anonymous;
    }

    @AnonymousCheck
    public static Result userFiles() {
        int USER_FILES_COUNT_PER_PAGE = 50;
        String pageNumString = UserApp.request().getQueryString("pageNum");
        String filter = UserApp.request().getQueryString("filter");
        int pageNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)pageNumString)) {
            pageNum = Integer.parseInt(pageNumString);
        }
        Page<Attachment> page = Attachment.findByUser(UserApp.currentUser(), 50, pageNum, filter);
        return UserApp.ok((Content)userFiles.render("User Files", page));
    }

    @AnonymousCheck
    public static Result userInfo(String loginId, int daysAgo, String selected) {
        Organization org = Organization.findByName(loginId);
        if (org != null) {
            Organization organization2 = org;
            String string = null;
            string = organization2.getName();
            return UserApp.redirect((Call)routes.OrganizationApp.organization(string));
        }
        if (daysAgo == 0) {
            Http.Cookie cookie = UserApp.request().cookie(DAYS_AGO_COOKIE);
            if (cookie != null && StringUtils.isNotEmpty((CharSequence)cookie.value())) {
                daysAgo = Integer.parseInt(cookie.value());
            } else {
                daysAgo = 14;
                UserApp.response().setCookie(DAYS_AGO_COOKIE, daysAgo + "");
            }
        } else {
            if (daysAgo < 0) {
                daysAgo = 1;
            }
            UserApp.response().setCookie(DAYS_AGO_COOKIE, daysAgo + "");
        }
        User user = User.findByLoginId(loginId);
        List<Issue> issues2 = new ArrayList<Issue>();
        List<PullRequest> pullRequests2 = new ArrayList<PullRequest>();
        ArrayList<Project> projects2 = new ArrayList();
        HashMap<Long, Boolean> projectAclMap = new HashMap<Long, Boolean>();
        if (!Application.HIDE_PROJECT_LISTING || !UserApp.currentUser().isAnonymous()) {
            projects2 = UserApp.collectProjects(user, projectAclMap);
            issues2 = UserApp.getAclValidatedIssues(Issue.findRecentlyIssuesByDaysAgo(user, daysAgo), projectAclMap);
            pullRequests2 = UserApp.getAclValidatedPullRequests(PullRequest.findOpendPullRequestsByDaysAgo(user, daysAgo), projectAclMap);
            UserApp.sortByLastPushedDateAndName(projects2);
        }
        if (user.isAnonymous()) {
            return UserApp.notFound((Content)ErrorViews.NotFound.render("user.notExists.name"));
        }
        return UserApp.ok((Content)view.render(user, projects2, issues2, pullRequests2, daysAgo, selected));
    }

    private static void sortByLastPushedDateAndName(List<Project> projects2) {
        Collections.sort(projects2, new Comparator<Project>(){

            @Override
            public int compare(Project p1, Project p2) {
                Project project2 = p1;
                Object object = null;
                object = project2.getLastPushedDate();
                if (object == null) {
                    project2 = p2;
                    object = null;
                    object = project2.getLastPushedDate();
                    if (object == null) {
                        project2 = p1;
                        object = null;
                        Object object2 = object = project2.getName();
                        project2 = p2;
                        object = null;
                        object = project2.getName();
                        return ((String)object2).compareTo((String)object);
                    }
                }
                project2 = p1;
                object = null;
                object = project2.getLastPushedDate();
                if (object == null) {
                    return 1;
                }
                project2 = p2;
                object = null;
                object = project2.getLastPushedDate();
                if (object == null) {
                    return -1;
                }
                project2 = p2;
                object = null;
                Object object3 = object = project2.getLastPushedDate();
                project2 = p1;
                object = null;
                object = project2.getLastPushedDate();
                int compareLastPushedDate = ((Date)object3).compareTo((Date)object);
                if (compareLastPushedDate == 0) {
                    project2 = p1;
                    object = null;
                    Object object4 = object = project2.getName();
                    project2 = p2;
                    object = null;
                    object = project2.getName();
                    return ((String)object4).compareTo((String)object);
                }
                return compareLastPushedDate;
            }
        });
    }

    private static List<PullRequest> getAclValidatedPullRequests(List<PullRequest> pullRequests2, Map<Long, Boolean> projectAcl) {
        ArrayList<PullRequest> aclValidatedPullRequests = new ArrayList<PullRequest>();
        for (PullRequest pullRequest2 : pullRequests2) {
            Object object = pullRequest2;
            Object object2 = null;
            object = object2 = ((PullRequest)object).getToProject();
            object2 = null;
            object2 = ((Project)object).getId();
            if (projectAcl.getOrDefault(object2, false).booleanValue()) {
                aclValidatedPullRequests.add(pullRequest2);
                continue;
            }
            object = pullRequest2;
            object2 = null;
            object2 = ((PullRequest)object).getToProject();
            if (AccessControl.isAllowed(UserApp.currentUser(), ((Project)object2).asResource(), Operation.READ)) {
                aclValidatedPullRequests.add(pullRequest2);
                object = pullRequest2;
                object2 = null;
                object = object2 = ((PullRequest)object).getToProject();
                object2 = null;
                object2 = ((Project)object).getId();
                projectAcl.putIfAbsent((Long)object2, true);
                continue;
            }
            object = pullRequest2;
            object2 = null;
            object = object2 = ((PullRequest)object).getToProject();
            object2 = null;
            object2 = ((Project)object).getId();
            projectAcl.putIfAbsent((Long)object2, false);
        }
        return aclValidatedPullRequests;
    }

    private static List<Issue> getAclValidatedIssues(List<Issue> issues2, Map<Long, Boolean> projectAcl) {
        ArrayList<Issue> aclValidatedIssues = new ArrayList<Issue>();
        for (Issue issue2 : issues2) {
            Object object = issue2;
            Object object2 = null;
            object = object2 = ((AbstractPosting)object).getProject();
            object2 = null;
            object2 = ((Project)object).getId();
            if (projectAcl.getOrDefault(object2, false).booleanValue()) {
                aclValidatedIssues.add(issue2);
                continue;
            }
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getProject();
            if (AccessControl.isAllowed(UserApp.currentUser(), ((Project)object2).asResource(), Operation.READ)) {
                aclValidatedIssues.add(issue2);
                object = issue2;
                object2 = null;
                object = object2 = ((AbstractPosting)object).getProject();
                object2 = null;
                object2 = ((Project)object).getId();
                projectAcl.putIfAbsent((Long)object2, true);
                continue;
            }
            object = issue2;
            object2 = null;
            object = object2 = ((AbstractPosting)object).getProject();
            object2 = null;
            object2 = ((Project)object).getId();
            projectAcl.putIfAbsent((Long)object2, false);
        }
        return aclValidatedIssues;
    }

    private static void sortIssues(List<Issue> issues2) {
        Collections.sort(issues2, new Comparator<Issue>(){

            @Override
            public int compare(Issue i1, Issue i2) {
                Issue issue2 = i2;
                Date date = null;
                Date date2 = date = issue2.getUpdatedDate();
                issue2 = i1;
                date = null;
                date = issue2.getUpdatedDate();
                return date2.compareTo(date);
            }
        });
    }

    private static void sortPullRequests(List<PullRequest> pullRequests2) {
        Collections.sort(pullRequests2, new Comparator<PullRequest>(){

            @Override
            public int compare(PullRequest p1, PullRequest p2) {
                PullRequest pullRequest2 = p2;
                Date date = null;
                Date date2 = date = pullRequest2.getUpdated();
                pullRequest2 = p1;
                date = null;
                date = pullRequest2.getUpdated();
                return date2.compareTo(date);
            }
        });
    }

    private static List<Project> collectProjects(User user, Map<Long, Boolean> projectAcl) {
        ArrayList<Project> projectCollection = new ArrayList<Project>();
        User user2 = user;
        Long l = null;
        l = user2.getId();
        UserApp.addProjectNotDupped(projectCollection, Project.findProjectsByMember(l), projectAcl);
        return projectCollection;
    }

    private static void addProjectNotDupped(List<Project> target, List<Project> foundProjects, Map<Long, Boolean> projectAcl) {
        for (Project project2 : foundProjects) {
            if (target.contains(project2)) continue;
            Project project3 = project2;
            Long l = null;
            l = project3.getId();
            if (projectAcl.containsKey(l)) {
                project3 = project2;
                l = null;
                l = project3.getId();
                if (!projectAcl.get(l).booleanValue()) continue;
                target.add(project2);
                continue;
            }
            if (AccessControl.isAllowed(UserApp.currentUser(), project2.asResource(), Operation.READ)) {
                target.add(project2);
                project3 = project2;
                l = null;
                l = project3.getId();
                projectAcl.putIfAbsent(l, true);
                continue;
            }
            project3 = project2;
            l = null;
            l = project3.getId();
            projectAcl.putIfAbsent(l, false);
        }
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result editUserInfoForm() {
        User user = UserApp.currentUser();
        Form userForm = new Form(User.class);
        userForm = userForm.fill((Object)user);
        return UserApp.ok((Content)edit.render((Form<User>)userForm, user));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result editUserInfoByTabForm(String tabId) {
        User user = UserApp.currentUser();
        Form userForm = new Form(User.class);
        userForm = userForm.fill((Object)user);
        switch (UserInfoFormTabType.fromString(tabId)) {
            case PASSWORD: {
                return UserApp.ok((Content)edit_password.render((Form<User>)userForm, user));
            }
            case NOTIFICATIONS: {
                return UserApp.ok((Content)edit_notifications.render((Form<User>)userForm, user));
            }
            case EMAILS: {
                return UserApp.ok((Content)edit_emails.render((Form<User>)userForm, user));
            }
            case TOKEN_RESET: {
                String string = null;
                User user2 = user;
                user2.setToken(string);
            }
            case TOKEN: {
                User user2 = user;
                String string = null;
                string = user2.getToken();
                if (StringUtils.isEmpty((CharSequence)string)) {
                    string = new Sha256Hash((Object)LocalDateTime.now().toString()).toBase64();
                    user2 = user;
                    user2.setToken(string);
                    user.save();
                }
                return UserApp.ok((Content)edit_token.render((Form<User>)userForm, user));
            }
            case PROFILE: {
                return UserApp.ok((Content)edit.render((Form<User>)userForm, user));
            }
        }
        return UserApp.ok((Content)edit.render((Form<User>)userForm, user));
    }

    public static boolean isUsingEmailVerification() {
        return usingEmailVerification;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @Transactional
    public static Result editUserInfo() {
        Object object;
        Model model;
        Form userForm = new Form(User.class).bindFromRequest(new String[]{"name", "email"});
        String newEmail = (String)userForm.data().get("email");
        String newName = HtmlUtil.defaultSanitize((String)userForm.data().get("name"));
        User user = UserApp.currentUser();
        if (StringUtils.isEmpty((CharSequence)newEmail)) {
            userForm.reject("email", "user.wrongEmail.alert");
        } else {
            model = user;
            object = null;
            object = model.getEmail();
            if (!StringUtils.equals((CharSequence)object, (CharSequence)newEmail) && User.isEmailExist(newEmail)) {
                userForm.reject("email", "user.email.duplicate");
            }
        }
        if (userForm.error("email") != null) {
            UserApp.flash((String)"warning", (String)userForm.error("email").message());
            return UserApp.badRequest((Content)edit.render((Form<User>)userForm, user));
        }
        object = newEmail;
        model = user;
        model.setEmail((String)object);
        object = HtmlUtil.defaultSanitize(newName);
        model = user;
        model.setName((String)object);
        try {
            Long avatarId = Long.valueOf((String)userForm.data().get("avatarId"));
            if (avatarId != null) {
                Attachment attachment = (Attachment)Attachment.find.byId((Object)avatarId);
                model = attachment;
                object = null;
                object = model.getMimeType();
                String primary = ((String)object).split("/")[0].toLowerCase();
                model = attachment;
                object = null;
                object = model.getSize();
                if ((Long)object > 1024000L) {
                    userForm.reject("avatarId", "user.avatar.fileSizeAlert");
                }
                if (primary.equals("image")) {
                    Attachment.deleteAll(UserApp.currentUser().avatarAsResource());
                    attachment.moveTo(UserApp.currentUser().avatarAsResource());
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        model = user;
        object = null;
        object = model.getEmail();
        Email.deleteOtherInvalidEmails((String)object);
        user.update();
        model = user;
        object = null;
        object = model.getId();
        CacheStore.yonaUsers.put(object, (Object)user);
        model = user;
        object = null;
        object = model.getLoginId();
        return UserApp.redirect((Call)routes.UserApp.userInfo((String)object, 14, DEFAULT_SELECTED_TAB));
    }

    @Transactional
    public static Result leave(String userName, String projectName) {
        User user = UserApp.currentUser();
        Object object = null;
        object = user.getId();
        ProjectApp.deleteMember(userName, projectName, (Long)object);
        user = UserApp.currentUser();
        object = null;
        object = user.getLoginId();
        return UserApp.redirect((Call)routes.UserApp.userInfo((String)object, 14, DEFAULT_SELECTED_TAB));
    }

    public static Result isUsed(String name) {
        ObjectNode result2 = Json.newObject();
        result2.put("isExist", User.isLoginIdExist(name) || Organization.isNameExist(name));
        result2.put("isReserved", ReservedWordsValidator.isReserved(name));
        return UserApp.ok((JsonNode)result2);
    }

    @BodyParser.Of(value=BodyParser.Json.class)
    public static Result isEmailExist(String email) {
        ObjectNode result2 = Json.newObject();
        result2.put("isExist", User.isEmailExist(email));
        return UserApp.ok((JsonNode)result2);
    }

    public static String hashedPassword(String plainTextPassword, String passwordSalt) {
        if (plainTextPassword == null || passwordSalt == null) {
            throw new IllegalArgumentException("Bad password or passwordSalt!");
        }
        return new Sha256Hash((Object)plainTextPassword, (Object)ByteSource.Util.bytes((String)passwordSalt), 1024).toBase64();
    }

    @Transactional
    public static Result addEmail() {
        Form emailForm = Form.form(Email.class).bindFromRequest(new String[0]);
        String newEmail = (String)emailForm.data().get("email");
        if (emailForm.hasErrors()) {
            UserApp.flash((String)"warning", (String)emailForm.error("email").message());
            return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
        }
        User currentUser = UserApp.currentUser();
        if (currentUser == null || currentUser.isAnonymous()) {
            return UserApp.forbidden((Content)ErrorViews.NotFound.render());
        }
        if (User.isEmailExist(newEmail) || Email.exists(newEmail, true) || currentUser.has(newEmail)) {
            UserApp.flash((String)"warning", (String)Messages.get((String)"user.email.duplicate", (Object[])new Object[0]));
            return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
        }
        Email email = new Email();
        User user = UserApp.currentUser();
        Object object = user;
        Email email2 = email;
        email2.setUser((User)object);
        object = newEmail;
        email2 = email;
        email2.setEmail((String)object);
        boolean bl = false;
        email2 = email;
        email2.setValid(bl);
        user.addEmail(email);
        return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
    }

    @Transactional
    public static Result deleteEmail(Long id) {
        User currentUser = UserApp.currentUser();
        Email email = (Email)((Object)Email.find.byId((Object)id));
        if (currentUser == null || currentUser.isAnonymous() || email == null) {
            return UserApp.forbidden((Content)ErrorViews.NotFound.render());
        }
        Email email2 = email;
        User user = null;
        user = email2.getUser();
        if (!AccessControl.isAllowed(currentUser, user.asResource(), Operation.DELETE)) {
            return UserApp.forbidden((Content)ErrorViews.Forbidden.render(Messages.get((String)"error.forbidden", (Object[])new Object[0])));
        }
        email.delete();
        return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
    }

    @Transactional
    public static Result sendValidationEmail(Long id) {
        User currentUser = UserApp.currentUser();
        Email email = (Email)((Object)Email.find.byId((Object)id));
        if (currentUser == null || currentUser.isAnonymous() || email == null) {
            return UserApp.forbidden((Content)ErrorViews.NotFound.render());
        }
        Email email2 = email;
        User user = null;
        user = email2.getUser();
        if (!AccessControl.isAllowed(currentUser, user.asResource(), Operation.UPDATE)) {
            return UserApp.forbidden((Content)ErrorViews.Forbidden.render(Messages.get((String)"error.forbidden", (Object[])new Object[0])));
        }
        email.sendValidationEmail();
        UserApp.flash((String)"warning", (String)"\ud655\uc778 \uba54\uc77c\uc744 \uc804\uc1a1\ud588\uc2b5\ub2c8\ub2e4.");
        return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
    }

    @Transactional
    public static Result confirmEmail(Long id, String token) {
        Email email = (Email)((Object)Email.find.byId((Object)id));
        if (email == null) {
            return UserApp.forbidden((Content)ErrorViews.NotFound.render());
        }
        if (email.validate(token)) {
            Email email2 = email;
            User user = null;
            user = email2.getUser();
            UserApp.addUserInfoToSession(user);
            return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
        }
        return UserApp.forbidden((Content)ErrorViews.NotFound.render());
    }

    @Transactional
    public static Result setAsMainEmail(Long id) {
        User currentUser = UserApp.currentUser();
        Email email = (Email)((Object)Email.find.byId((Object)id));
        if (currentUser == null || currentUser.isAnonymous() || email == null) {
            return UserApp.forbidden((Content)ErrorViews.NotFound.render());
        }
        Model model = email;
        Object object = null;
        object = model.getUser();
        if (!AccessControl.isAllowed(currentUser, ((User)object).asResource(), Operation.UPDATE)) {
            return UserApp.forbidden((Content)ErrorViews.Forbidden.render(Messages.get((String)"error.forbidden", (Object[])new Object[0])));
        }
        model = currentUser;
        object = null;
        Object oldMainEmail = object = model.getEmail();
        model = email;
        object = null;
        object = model.getEmail();
        model = currentUser;
        model.setEmail((String)object);
        currentUser.removeEmail(email);
        currentUser.update();
        Email newSubEmail = new Email();
        boolean bl = true;
        model = newSubEmail;
        model.setValid(bl);
        Object object2 = oldMainEmail;
        model = newSubEmail;
        model.setEmail((String)object2);
        object2 = currentUser;
        model = newSubEmail;
        model.setUser((User)object2);
        currentUser.addEmail(newSubEmail);
        return UserApp.redirect((Call)routes.UserApp.editUserInfoForm());
    }

    private static User authenticate(String loginId, String password, boolean hashed) {
        String string;
        User user;
        String string2;
        User user2 = User.findByLoginId(loginId);
        if (user2.isAnonymous()) {
            return user2;
        }
        if (hashed) {
            string2 = password;
        } else {
            user = user2;
            string = null;
            string = user.getPasswordSalt();
            string2 = UserApp.hashedPassword(password, string);
        }
        String hashedPassword = string2;
        user = user2;
        string = null;
        string = user.getPassword();
        if (StringUtils.equals((CharSequence)string, (CharSequence)hashedPassword)) {
            return user2;
        }
        return User.anonymous;
    }

    public static User authenticateWithLdap(String loginIdOrEmail, String password) {
        LdapService ldapService = new LdapService();
        try {
            String string;
            User user;
            LdapUser ldapUser = ldapService.authenticate(loginIdOrEmail, password);
            Logger.debug((String)("l: " + ldapUser));
            User localUserFoundByLdapLogin = User.findByEmail(ldapUser.getEmail());
            if (localUserFoundByLdapLogin.isAnonymous()) {
                return UserApp.createNewUser(password, ldapUser);
            }
            if (!localUserFoundByLdapLogin.isSamePassword(password)) {
                user = localUserFoundByLdapLogin;
                string = null;
                string = user.getLoginId();
                User.resetPassword(string, password);
            }
            localUserFoundByLdapLogin.refresh();
            string = ldapUser.getDisplayName();
            user = localUserFoundByLdapLogin;
            user.setName(string);
            if (StringUtils.isNotBlank((CharSequence)ldapUser.getEnglishName())) {
                string = ldapUser.getEnglishName();
                user = localUserFoundByLdapLogin;
                user.setEnglishName(string);
            }
            boolean bl = ldapUser.isGuestUser();
            user = localUserFoundByLdapLogin;
            user.setIsGuest(bl);
            localUserFoundByLdapLogin.update();
            return localUserFoundByLdapLogin;
        }
        catch (CommunicationException e) {
            Logger.error((String)("Cannot connect to ldap server \n" + e.getMessage()));
            e.printStackTrace();
            if (LdapService.FALLBACK_TO_LOCAL_LOGIN) {
                Logger.warn((String)("fallback to local login: " + loginIdOrEmail));
                return UserApp.authenticateWithPlainPassword(loginIdOrEmail, password);
            }
            return User.anonymous;
        }
        catch (AuthenticationException e) {
            UserApp.flash((String)"warning", (String)Messages.get((String)"user.login.invalid", (Object[])new Object[0]));
            Logger.warn((String)("login failed \n" + e.getMessage()));
            if (LdapService.FALLBACK_TO_LOCAL_LOGIN) {
                Logger.warn((String)("fallback to local login: " + loginIdOrEmail));
                return UserApp.authenticateWithPlainPassword(loginIdOrEmail, password);
            }
            return User.anonymous;
        }
        catch (NamingException e) {
            Logger.error((String)("Cannot connect to ldap server \n" + e.getMessage()));
            e.printStackTrace();
            return User.anonymous;
        }
    }

    private static User createNewUser(String password, LdapUser ldapUser) {
        User created;
        CandidateUser candidateUser = new CandidateUser(ldapUser.getDisplayName(), ldapUser.getEmail(), ldapUser.getUserLoginId(), password, ldapUser.isGuestUser());
        User user = created = UserApp.createUserDelegate(candidateUser);
        UserState userState = null;
        userState = user.getState();
        if (userState == UserState.LOCKED) {
            UserApp.flash((String)"info", (String)"user.signup.requested");
            return User.anonymous;
        }
        return created;
    }

    public static boolean isUsingSignUpConfirm() {
        Configuration config = Play.application().configuration();
        Boolean useSignUpConfirm = config.getBoolean("signup.require.admin.confirm");
        if (useSignUpConfirm == null) {
            useSignUpConfirm = config.getBoolean("signup.require.confirm", Boolean.valueOf(false));
        }
        return useSignUpConfirm;
    }

    public static void setupRememberMe(User user) {
        User user2 = user;
        String string = null;
        string = user2.getLoginId();
        StringBuilder stringBuilder = new StringBuilder().append(string).append(TOKEN_SEPARATOR);
        user2 = user;
        string = null;
        string = user2.getPassword();
        UserApp.response().setCookie(TOKEN, stringBuilder.append(string).toString(), Integer.valueOf(2592000));
        Logger.debug((String)"remember me enabled");
    }

    private static void processLogout() {
        UserApp.session().clear();
        UserApp.response().discardCookie(TOKEN);
    }

    private static void validate(Form<User> newUserForm) {
        if (newUserForm.field(SESSION_LOGINID).value().trim().isEmpty()) {
            newUserForm.reject(SESSION_LOGINID, "user.wrongloginId.alert");
        }
        if (newUserForm.field(SESSION_LOGINID).value().contains(" ")) {
            newUserForm.reject(SESSION_LOGINID, "user.wrongloginId.alert");
        }
        if (newUserForm.field("password").value().trim().isEmpty()) {
            newUserForm.reject("password", "user.wrongPassword.alert");
        }
        if (User.isLoginIdExist(newUserForm.field(SESSION_LOGINID).value()) || Organization.isNameExist(newUserForm.field(SESSION_LOGINID).value())) {
            newUserForm.reject(SESSION_LOGINID, "user.loginId.duplicate");
        }
        if (User.isEmailExist(newUserForm.field("email").value())) {
            newUserForm.reject("email", "user.email.duplicate");
        }
    }

    public static User createNewUser(User user) {
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        Object object = rng.nextBytes().toBase64();
        User user2 = user;
        user2.setPasswordSalt((String)object);
        user2 = user;
        object = null;
        String string = object = user2.getPassword();
        user2 = user;
        object = null;
        object = user2.getPasswordSalt();
        object = UserApp.hashedPassword(string, object);
        user2 = user;
        user2.setPassword((String)object);
        if (UserApp.isUsingSignUpConfirm() || UserApp.isUsingEmailVerification()) {
            object = UserState.LOCKED;
            user2 = user;
            user2.setState((UserState)((Object)object));
        } else {
            object = UserState.ACTIVE;
            user2 = user;
            user2.setState((UserState)((Object)object));
        }
        User.create(user);
        user2 = user;
        object = null;
        object = user2.getEmail();
        Email.deleteOtherInvalidEmails(object);
        if (UserApp.isUsingEmailVerification()) {
            UserVerification.newVerification(user);
            UserApp.sendMailAfterUserCreation(user);
        }
        return user;
    }

    public static void addUserInfoToSession(User user) {
        if (user.isLocked()) {
            return;
        }
        User user2 = user;
        Object object = null;
        object = user2.getPasswordSalt();
        String key = new Sha256Hash((Object)new Date().toString(), (Object)ByteSource.Util.bytes((String)object), 1024).toBase64();
        user2 = user;
        object = null;
        object = user2.getId();
        CacheStore.yonaUsers.put(object, (Object)user);
        user2 = user;
        object = null;
        object = user2.getId();
        UserApp.session((String)SESSION_USERID, (String)String.valueOf(object));
        user2 = user;
        object = null;
        object = user2.getLoginId();
        UserApp.session((String)SESSION_LOGINID, (String)object);
        user2 = user;
        object = null;
        object = user2.getName();
        UserApp.session((String)SESSION_USERNAME, (String)object);
        UserApp.session((String)SESSION_KEY, (String)key);
    }

    public static boolean linkWithExistedOrCreateLocalUser() {
        UserCredential oAuthUser = UserCredential.findByAuthUserIdentity((AuthUserIdentity)PlayAuthenticate.getUser((Http.Session)Http.Context.current().session()));
        User user = null;
        Model model = oAuthUser;
        Object object = null;
        object = model.getLoginId();
        if (object == null) {
            model = oAuthUser;
            object = null;
            object = model.getEmail();
            user = User.findByEmail((String)object);
        } else {
            model = oAuthUser;
            object = null;
            object = model.getLoginId();
            user = User.findByLoginId((String)object);
        }
        if (PlayAuthenticate.isLoggedIn((Http.Session)UserApp.session()) && user.isAnonymous()) {
            return !UserApp.createLocalUserWithOAuth(oAuthUser).isAnonymous();
        }
        model = oAuthUser;
        object = null;
        object = model.getLoginId();
        if (object == null) {
            model = user;
            object = null;
            object = model.getLoginId();
            model = oAuthUser;
            model.setLoginId((String)object);
            object = user;
            model = oAuthUser;
            model.setUser((User)object);
            oAuthUser.update();
        }
        UserApp.addUserInfoToSession(user);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePreferredLanguage() {
        Http.Request request = Http.Context.current().request();
        User user = UserApp.currentUser();
        if (user.isAnonymous()) {
            return;
        }
        if (request.acceptLanguages().isEmpty() && request.cookie(Play.langCookieName()) == null) {
            return;
        }
        String code = StringUtils.left((String)Http.Context.current().lang().code(), (int)255);
        User user2 = user;
        String string = null;
        string = user2.getLang();
        if (!code.equals(string)) {
            User user3 = user;
            synchronized (user3) {
                user.refresh();
                string = code;
                user2 = user;
                user2.setLang(string);
                user.update();
            }
        }
    }

    public static Result resetUserPasswordBySiteManager(String loginId) {
        if (!UserApp.request().getQueryString("action").equals("resetPassword")) {
            ObjectNode json = Json.newObject();
            json.put("isSuccess", false);
            json.put("reason", "BAD_REQUEST");
            return UserApp.badRequest((JsonNode)json);
        }
        String newPassword = PasswordReset.generateResetHash(loginId).substring(0, 6);
        User targetUser = User.findByLoginId(loginId);
        if (!targetUser.isAnonymous() && UserApp.currentUser().isSiteManager()) {
            User.resetPassword(loginId, newPassword);
            ObjectNode json = Json.newObject();
            User user = targetUser;
            String string = null;
            string = user.getLoginId();
            json.put(SESSION_LOGINID, string);
            user = targetUser;
            string = null;
            string = user.getName();
            json.put("name", string);
            json.put("newPassword", newPassword);
            json.put("isSuccess", true);
            return UserApp.ok((JsonNode)json);
        }
        ObjectNode json = Json.newObject();
        json.put("isSuccess", false);
        json.put("reason", "FORBIDDEN");
        return UserApp.forbidden((JsonNode)json);
    }

    public static boolean isSiteAdminLoggedInSession() {
        return "admin".equals(UserApp.session().get((Object)SESSION_LOGINID));
    }

    @AnonymousCheck
    public static Result setDefaultLoginPage() throws IOException, WriteException {
        Model model = UserApp.currentUser();
        Object object = null;
        object = model.getId();
        UserSetting userSetting = UserSetting.findByUser((Long)object);
        object = UserApp.request().getQueryString("path");
        model = userSetting;
        model.setLoginDefaultPage((String)object);
        userSetting.save();
        ObjectNode json = Json.newObject();
        model = userSetting;
        object = null;
        object = model.getLoginDefaultPage();
        json.put("defaultLoginPage", (String)object);
        return UserApp.ok((JsonNode)json);
    }

    public static Result usermenuTabContentList() {
        return UserApp.ok((Content)usermenu_tab_content_list.render());
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static enum UserInfoFormTabType {
        PROFILE("profile"),
        PASSWORD("password"),
        NOTIFICATIONS("notifications"),
        EMAILS("emails"),
        TOKEN("token"),
        TOKEN_RESET("token_reset");

        private String tabId;

        private UserInfoFormTabType(String tabId) {
            this.tabId = tabId;
        }

        public String value() {
            return this.tabId;
        }

        public static UserInfoFormTabType fromString(String text) throws IllegalArgumentException {
            for (UserInfoFormTabType tab : UserInfoFormTabType.values()) {
                if (!tab.value().equalsIgnoreCase(text)) continue;
                return tab;
            }
            throw new IllegalArgumentException("Invalid tabId");
        }
    }
}

