/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.routes;
import models.NotificationEvent;
import models.Project;
import models.PullRequest;
import models.PullRequestEvent;
import models.enumeration.Operation;
import models.enumeration.PullRequestReviewAction;
import models.enumeration.ResourceType;
import play.api.mvc.Call;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.mvc.Controller;
import play.mvc.Result;

@AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ReviewApp
extends Controller {
    @Transactional
    @IsAllowed(value=Operation.ACCEPT, resourceType=ResourceType.PULL_REQUEST)
    public static Result review(String userName, String projectName, Long pullRequestNumber) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        pullRequest2.addReviewer(UserApp.currentUser());
        Call call = routes.PullRequestApp.pullRequest(userName, projectName, pullRequestNumber);
        ReviewApp.addNotification(pullRequest2, PullRequestReviewAction.DONE);
        return ReviewApp.redirect((play.mvc.Call)call);
    }

    @Transactional
    @IsAllowed(value=Operation.ACCEPT, resourceType=ResourceType.PULL_REQUEST)
    public static Result unreview(String userName, String projectName, Long pullRequestNumber) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        PullRequest pullRequest2 = PullRequest.findOne(project2, pullRequestNumber);
        pullRequest2.removeReviewer(UserApp.currentUser());
        Call call = routes.PullRequestApp.pullRequest(userName, projectName, pullRequestNumber);
        ReviewApp.addNotification(pullRequest2, PullRequestReviewAction.CANCEL);
        return ReviewApp.redirect((play.mvc.Call)call);
    }

    private static void addNotification(PullRequest pullRequest2, PullRequestReviewAction reviewAction) {
        NotificationEvent notiEvent = NotificationEvent.afterReviewed(pullRequest2, reviewAction);
        PullRequestEvent.addFromNotificationEvent(notiEvent, pullRequest2);
    }
}

