/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.AbstractPostingApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.routes;
import java.util.Date;
import java.util.List;
import models.Attachment;
import models.Milestone;
import models.Project;
import models.enumeration.Direction;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import models.enumeration.State;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Transactional;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.JodaDateUtil;
import views.html.milestone.create;
import views.html.milestone.edit;
import views.html.milestone.list;
import views.html.milestone.view;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MilestoneApp
extends Controller {
    @IsAllowed(value=Operation.READ)
    public static Result milestones(String userName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        MilestoneCondition mCondition = (MilestoneCondition)Form.form(MilestoneCondition.class).bindFromRequest(new String[0]).get();
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getId();
        Long l = object2;
        object = mCondition;
        object2 = null;
        object2 = ((MilestoneCondition)object).getState();
        State state = State.getValue((String)object2);
        object = mCondition;
        object2 = null;
        Object object3 = object2 = ((MilestoneCondition)object).getOrderBy();
        object = mCondition;
        object2 = null;
        object2 = ((MilestoneCondition)object).getOrderDir();
        List<Milestone> milestones2 = Milestone.findMilestones(l, state, (String)object3, Direction.getValue((String)object2));
        return MilestoneApp.ok((Content)list.render("milestone", milestones2, project2, mCondition));
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsCreatable(value=ResourceType.MILESTONE)
    public static Result newMilestoneForm(String userName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        return MilestoneApp.ok((Content)create.render("title.newMilestone", (Form<Milestone>)new Form(Milestone.class), project2));
    }

    @Transactional
    @IsCreatable(value=ResourceType.MILESTONE)
    public static Result newMilestone(String userName, String projectName) {
        Form milestoneForm = new Form(Milestone.class).bindFromRequest(new String[0]);
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        MilestoneApp.validateTitle(project2, (Form<Milestone>)milestoneForm);
        MilestoneApp.validateDueDate((Form<Milestone>)milestoneForm);
        if (milestoneForm.hasErrors()) {
            return MilestoneApp.ok((Content)create.render("title.newMilestone", (Form<Milestone>)milestoneForm, project2));
        }
        Milestone newMilestone2 = (Milestone)milestoneForm.get();
        Object object = project2;
        Milestone milestone2 = newMilestone2;
        milestone2.setProject((Project)object);
        milestone2 = newMilestone2;
        object = null;
        object = milestone2.getDueDate();
        object = JodaDateUtil.lastSecondOfDay((Date)object);
        milestone2 = newMilestone2;
        milestone2.setDueDate((Date)object);
        Milestone.create(newMilestone2);
        AbstractPostingApp.attachUploadFilesToPost(newMilestone2.asResource());
        milestone2 = newMilestone2;
        object = null;
        object = milestone2.getId();
        return MilestoneApp.redirect((Call)routes.MilestoneApp.milestone(userName, projectName, (Long)object));
    }

    private static void validateTitle(Project project2, Form<Milestone> milestoneForm) {
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        if (!Milestone.isUniqueProjectIdAndTitle(l, milestoneForm.field("title").value())) {
            milestoneForm.reject("title", "milestone.title.duplicated");
            MilestoneApp.flash((String)"warning", (String)"milestone.title.duplicated");
        }
    }

    private static void validateDueDate(Form<Milestone> milestoneForm) {
        if (milestoneForm.hasErrors() && milestoneForm.errors().containsKey("dueDate")) {
            MilestoneApp.flash((String)"warning", (String)"milestone.error.duedateFormat");
        }
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.MILESTONE)
    public static Result editMilestoneForm(String userName, String projectName, Long milestoneId) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Milestone milestone2 = Milestone.findById(milestoneId);
        Form editForm = new Form(Milestone.class).fill((Object)milestone2);
        return MilestoneApp.ok((Content)edit.render("title.editMilestone", (Form<Milestone>)editForm, milestone2, project2));
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.MILESTONE)
    public static Result editMilestone(String userName, String projectName, Long milestoneId) {
        Milestone milestone2;
        Milestone original;
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Form milestoneForm = new Form(Milestone.class).bindFromRequest(new String[0]);
        Milestone milestone3 = original = Milestone.findById(milestoneId);
        Object object = null;
        object = milestone3.getTitle();
        if (!((String)object).equals(milestoneForm.field("title").value())) {
            MilestoneApp.validateTitle(project2, (Form<Milestone>)milestoneForm);
        }
        MilestoneApp.validateDueDate((Form<Milestone>)milestoneForm);
        if (milestoneForm.hasErrors()) {
            return MilestoneApp.ok((Content)edit.render("title.editMilestone", (Form<Milestone>)milestoneForm, original, project2));
        }
        Milestone existingMilestone = Milestone.findById(milestoneId);
        milestone3 = milestone2 = (Milestone)milestoneForm.get();
        object = null;
        object = milestone3.getContents();
        if (object == null) {
            return MilestoneApp.status((int)413, (Content)ErrorViews.RequestTextEntityTooLarge.render());
        }
        milestone3 = milestone2;
        object = null;
        object = milestone3.getDueDate();
        object = JodaDateUtil.lastSecondOfDay((Date)object);
        milestone3 = milestone2;
        milestone3.setDueDate((Date)object);
        existingMilestone.updateWith(milestone2);
        Attachment.moveAll(UserApp.currentUser().asResource(), existingMilestone.asResource());
        milestone3 = existingMilestone;
        object = null;
        object = milestone3.getId();
        return MilestoneApp.redirect((Call)routes.MilestoneApp.milestone(userName, projectName, (Long)object));
    }

    @Transactional
    @IsAllowed(value=Operation.DELETE, resourceType=ResourceType.MILESTONE)
    public static Result deleteMilestone(String userName, String projectName, Long id) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Milestone milestone2 = Milestone.findById(id);
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getId();
        Long l = object2;
        object = milestone2;
        object2 = null;
        object = object2 = ((Milestone)object).getProject();
        object2 = null;
        object2 = ((Project)object).getId();
        if (!l.equals(object2)) {
            return MilestoneApp.internalServerError();
        }
        milestone2.delete();
        if (HttpUtil.isRequestedWithXHR(MilestoneApp.request()).booleanValue()) {
            MilestoneApp.response().setHeader("Location", routes.MilestoneApp.milestones(userName, projectName).toString());
            return MilestoneApp.status((int)204);
        }
        return MilestoneApp.redirect((Call)routes.MilestoneApp.milestones(userName, projectName));
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.MILESTONE)
    public static Result open(String userName, String projectName, Long id) {
        Milestone milestone2 = Milestone.findById(id);
        milestone2.open();
        return MilestoneApp.redirect((Call)routes.MilestoneApp.milestone(userName, projectName, id));
    }

    @Transactional
    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.MILESTONE)
    public static Result close(String userName, String projectName, Long id) {
        Milestone milestone2 = Milestone.findById(id);
        milestone2.close();
        return MilestoneApp.redirect((Call)routes.MilestoneApp.milestone(userName, projectName, id));
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.MILESTONE)
    public static Result milestone(String userName, String projectName, Long id) {
        Project project2 = Project.findByOwnerAndProjectName(userName, projectName);
        Milestone milestone2 = Milestone.findById(id);
        String paramState = MilestoneApp.request().getQueryString("state");
        State state = State.getValue(paramState);
        UserApp.currentUser().visits(project2);
        Milestone milestone3 = milestone2;
        String string = null;
        string = milestone3.getTitle();
        return MilestoneApp.ok((Content)view.render(string, milestone2, project2, state));
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class MilestoneCondition {
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String state;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String orderBy;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String orderDir;

        public MilestoneCondition() {
            String string = "open";
            MilestoneCondition milestoneCondition = this;
            milestoneCondition.setState(string);
            string = "dueDate";
            milestoneCondition = this;
            milestoneCondition.setOrderBy(string);
            string = "asc";
            milestoneCondition = this;
            milestoneCondition.setOrderDir(string);
            string = "open";
            milestoneCondition = this;
            milestoneCondition.setState(string);
            string = "dueDate";
            milestoneCondition = this;
            milestoneCondition.setOrderBy(string);
            string = "asc";
            milestoneCondition = this;
            milestoneCondition.setOrderDir(string);
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getState() {
            return this.state;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setState(String string) {
            this.state = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getOrderBy() {
            return this.orderBy;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setOrderBy(String string) {
            this.orderBy = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getOrderDir() {
            return this.orderDir;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setOrderDir(String string) {
            this.orderDir = string;
        }
    }
}

