/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.avaje.ebean.Ebean;
import com.avaje.ebean.Query;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.RawSqlBuilder;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.AttachmentApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import models.AbstractPosting;
import models.Assignee;
import models.Attachment;
import models.Comment;
import models.Issue;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.Milestone;
import models.Organization;
import models.OrganizationUser;
import models.Posting;
import models.Project;
import models.ProjectUser;
import models.User;
import models.enumeration.ResourceType;
import models.enumeration.State;
import models.support.IssueLabelAggregate;
import org.apache.commons.lang.StringUtils;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.libs.F;
import play.libs.Json;
import play.libs.ws.WS;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import utils.ErrorViews;
import views.html.migration.home;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MigrationApp {
    static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final String YONA_SERVER = "/";

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static F.Promise<Result> migration() {
        boolean isAllowed = Configuration.root().getBoolean("github.allow.migration", Boolean.valueOf(false));
        if (!isAllowed) {
            return F.Promise.pure((Object)Results.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden.or.not.allowed")));
        }
        String authProcessingCode = Http.Context.Implicit.request().getQueryString("code");
        if (StringUtils.isNotBlank((String)authProcessingCode)) {
            return MigrationApp.getOAuthToken(authProcessingCode).map(token -> Results.ok((Content)home.render("Migration", authProcessingCode, token)));
        }
        return F.Promise.promise(() -> Results.ok((Content)home.render("Migration", null, null)));
    }

    private static F.Promise<String> getOAuthToken(String code) {
        String ACCESS_TOKEN_URL = "https://github.com/login/oauth/access_token";
        String CLIENT_ID = Configuration.root().getString("github.client.id");
        String CLIENT_SECRET = Configuration.root().getString("github.client.secret");
        return WS.url((String)"https://github.com/login/oauth/access_token").setContentType("application/x-www-form-urlencoded").setHeader("Accept", "application/json,application/x-www-form-urlencoded,text/html,*/*").post("client_id=" + CLIENT_ID + "&client_secret=" + CLIENT_SECRET + "&code=" + code).map(response -> {
            Logger.debug((String)response.getBody());
            String accessToken = "";
            try {
                Pattern p = Pattern.compile("access_token=([^&]+)");
                Matcher m = p.matcher(response.getBody());
                if (m.find()) {
                    accessToken = m.group(1);
                }
            }
            catch (PatternSyntaxException ex) {
                Logger.error((String)"Couldn't find access_token");
            }
            Logger.error((String)("token=" + accessToken));
            return accessToken;
        });
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result projects() {
        HashSet<Project> sourceProjects = new HashSet<Project>();
        MigrationApp.getheringOrgProjects(sourceProjects);
        MigrationApp.gatheringUserProjects(sourceProjects);
        ArrayList<ObjectNode> projects2 = new ArrayList<ObjectNode>();
        for (Project project2 : MigrationApp.sortProjectsByOwnerAndName(sourceProjects)) {
            ObjectNode projectNode = Json.newObject();
            Project project3 = project2;
            String string = null;
            string = project3.getOwner();
            projectNode.put("owner", string);
            project3 = project2;
            string = null;
            string = project3.getName();
            projectNode.put("projectName", string);
            projectNode.put("private", project2.isPrivate());
            projectNode.put("members", project2.members().size());
            project3 = project2;
            string = null;
            string = project3.getOwner();
            StringBuilder stringBuilder = new StringBuilder().append(string).append(YONA_SERVER);
            project3 = project2;
            string = null;
            string = project3.getName();
            projectNode.put("full_name", stringBuilder.append(string).toString());
            projects2.add(projectNode);
        }
        return Results.ok((JsonNode)Json.toJson(projects2));
    }

    private static List<Project> sortProjectsByOwnerAndName(Set<Project> projects2) {
        Comparator<Project> comparator = Comparator.comparing(project2 -> {
            Project project3 = project2;
            String string = null;
            string = project3.getOwner();
            return string;
        });
        comparator = comparator.thenComparing(Comparator.comparing(project2 -> {
            Project project3 = project2;
            String string = null;
            string = project3.getName();
            return string;
        }));
        ArrayList<Project> list2 = new ArrayList<Project>(projects2);
        Collections.sort(list2, comparator);
        return list2;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result project(String owner, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ObjectNode result2 = Json.newObject();
        Project project3 = project2;
        List<Model> list2 = null;
        list2 = project3.getOwner();
        result2.put("owner", (String)((Object)list2));
        project3 = project2;
        list2 = null;
        list2 = project3.getName();
        result2.put("projectName", (String)((Object)list2));
        project3 = project2;
        list2 = null;
        list2 = project3.getOwner();
        StringBuilder stringBuilder = new StringBuilder().append((String)((Object)list2)).append(YONA_SERVER);
        project3 = project2;
        list2 = null;
        list2 = project3.getName();
        result2.put("full_name", stringBuilder.append((String)((Object)list2)).toString());
        result2.put("assignees", Json.toJson((Object)MigrationApp.getAssginees(project2).toArray()));
        result2.put("memberCount", project2.members().size());
        project3 = project2;
        list2 = null;
        list2 = project3.getIssues();
        result2.put("issueCount", list2.size());
        project3 = project2;
        list2 = null;
        list2 = project3.getPosts();
        result2.put("postCount", list2.size());
        project3 = project2;
        list2 = null;
        list2 = project3.getMilestones();
        result2.put("milestoneCount", list2.size());
        return Results.ok((JsonNode)result2);
    }

    public static List<ObjectNode> getAssginees(Project project2) {
        ArrayList<ObjectNode> members2 = new ArrayList<ObjectNode>();
        Object object = project2;
        Object object2 = null;
        object2 = ((Project)object).getAssignees();
        Iterator<Assignee> iterator = object2.iterator();
        while (iterator.hasNext()) {
            Assignee assignee = iterator.next();
            ObjectNode member = Json.newObject();
            object = assignee;
            object2 = null;
            object = object2 = ((Assignee)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getName();
            member.put("name", (String)object2);
            object = assignee;
            object2 = null;
            object = object2 = ((Assignee)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getLoginId();
            member.put("login", (String)object2);
            object = assignee;
            object2 = null;
            object = object2 = ((Assignee)((Object)object)).getUser();
            object2 = null;
            object2 = ((User)object).getEmail();
            member.put("email", (String)object2);
            members2.add(member);
        }
        return members2;
    }

    public static List<ObjectNode> getAuthors(Project project2) {
        ArrayList<ObjectNode> authors = new ArrayList<ObjectNode>();
        for (User user : project2.findAuthors()) {
            ObjectNode member = Json.newObject();
            User user2 = user;
            String string = null;
            string = user2.getName();
            member.put("name", string);
            user2 = user;
            string = null;
            string = user2.getLoginId();
            member.put("login", string);
            user2 = user;
            string = null;
            string = user2.getEmail();
            member.put("email", string);
            authors.add(member);
        }
        return authors;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result exportIssueLabelPairs(String owner, String projectName) {
        ObjectNode issueLabelPairs = MigrationApp.composeIssueLabelPairJson(owner, projectName);
        return Results.ok((JsonNode)issueLabelPairs);
    }

    public static ObjectNode composeIssueLabelPairJson(String owner, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Query query = Ebean.find(IssueLabelAggregate.class);
        Project project3 = project2;
        Long l = null;
        l = project3.getId();
        String sql = "select issue_id, issue_label_id \nfrom issue i, issue_issue_label iil \nwhere project_id = " + l + "\nand i.id = iil.issue_id";
        RawSql rawSql = RawSqlBuilder.parse((String)sql).create();
        query.setRawSql(rawSql);
        List results = query.findList();
        ObjectNode issueLabelPairs = Json.newObject();
        issueLabelPairs.put("issueLabelPairs", Json.toJson((Object)results));
        return issueLabelPairs;
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result exportLabels(String owner, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(owner, projectName);
        ObjectNode labels2 = Json.newObject();
        for (IssueLabel label : IssueLabel.findByProject(project2)) {
            ObjectNode node = Json.newObject();
            Object object = label;
            Object object2 = null;
            object2 = ((IssueLabel)object).getId();
            node.put("id", (Long)object2);
            object = label;
            object2 = null;
            object2 = ((IssueLabel)object).getName();
            node.put("name", (String)object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            object2 = null;
            object2 = ((IssueLabelCategory)object).getId();
            node.put("categoryId", (Long)object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            object2 = null;
            object2 = ((IssueLabelCategory)object).getName();
            node.put("categoryName", (String)object2);
            object = label;
            object2 = null;
            object2 = ((IssueLabel)object).getId();
            labels2.put(String.valueOf(object2), (JsonNode)node);
        }
        ObjectNode exportData2 = Json.newObject();
        exportData2.put("labels", Json.toJson((Object)labels2));
        return Results.ok((JsonNode)exportData2);
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result exportMilestones(String owner, String projectName) {
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(owner, projectName);
        List<Milestone> list2 = null;
        list2 = project3.getMilestones();
        List milestones2 = list2.stream().map(MigrationApp::composeMilestoneJson).collect(Collectors.toList());
        ObjectNode exportData2 = Json.newObject();
        exportData2.put("milestones", Json.toJson(milestones2));
        return Results.ok((JsonNode)exportData2);
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result exportPosts(String owner, String projectName) {
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(owner, projectName);
        List<Posting> list2 = null;
        list2 = project3.getPosts();
        List issues2 = list2.stream().map(MigrationApp::composePostJson).collect(Collectors.toList());
        ObjectNode exportData2 = Json.newObject();
        exportData2.put("issues", Json.toJson(issues2));
        return Results.ok((JsonNode)exportData2);
    }

    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result exportIssues(String owner, String projectName) {
        Project project2;
        Project project3 = project2 = Project.findByOwnerAndProjectName(owner, projectName);
        Set<Issue> set = null;
        set = project3.getIssues();
        List issues2 = set.stream().map(MigrationApp::composeIssueJson).collect(Collectors.toList());
        ObjectNode exportData2 = Json.newObject();
        exportData2.put("issues", Json.toJson(issues2));
        return Results.ok((JsonNode)exportData2);
    }

    public static ObjectNode composeMilestoneJson(Milestone m) {
        ObjectNode milestoneJson = Json.newObject();
        milestoneJson.put("milestone", (JsonNode)MigrationApp.getMilestoneNode(m));
        return milestoneJson;
    }

    public static ObjectNode getMilestoneNode(Milestone m) {
        ObjectNode node = Json.newObject();
        Milestone milestone2 = m;
        Object object = null;
        object = milestone2.getId();
        node.put("id", (Long)object);
        milestone2 = m;
        object = null;
        object = milestone2.getTitle();
        node.put("title", (String)object);
        milestone2 = m;
        object = null;
        object = milestone2.getState();
        node.put("state", ((State)((Object)object)).state());
        milestone2 = m;
        object = null;
        object = milestone2.getContents();
        node.put("description", (String)object);
        milestone2 = m;
        object = null;
        object = milestone2.getDueDate();
        Optional.ofNullable(object).ifPresent(dueDate -> {
            Milestone milestone2 = m;
            Date date = null;
            date = milestone2.getDueDate();
            node.put("due_on", LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(formatter));
        });
        return node;
    }

    private static String addOriginalAuthorName(String bodyText, String authorLoginId, String authorName, String type, String link) {
        return String.format("@%s (%s) \ub2d8\uc774 \uc791\uc131\ud55c [%s](%s)\uc785\ub2c8\ub2e4. \n\\---\n\n%s", authorLoginId, authorName, type, link, bodyText);
    }

    private static String relativeLinksToAbsolutePath(String text) {
        return text.replaceAll("(<img src=[\"'])/(?<link>.*)([\"']>)", "$1/$2$3").replaceAll("\\[(?<text>[^\\]]*)\\]\\(/(?<link>[^\\)]*)\\)", "[$1](/$2)");
    }

    private static String relativeLinksToWikiCommitPath(String text) {
        return text.replaceAll("(<img src=[\"'])/(?<link>.*)([\"']>)", "$1/$2$3").replaceAll("\\[(?<text>[^\\]]*)\\]\\(/(?<link>[^\\)]*)\\)", "[$1](../wiki/$2/$1)");
    }

    private static StringBuilder addAttachmentsString(@NotNull StringBuilder sb, ResourceType type, String id) {
        try {
            List<Map<String, String>> attachments = AttachmentApp.getFileList(type.toString(), id).get("attachments");
            if (attachments.size() > 0) {
                MigrationApp.addListHeader(sb);
            }
            for (Map<String, String> attachment : attachments) {
                sb.append(String.format("\n[%s](%s)", attachment.get("name"), YONA_SERVER + attachment.get("url")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb;
    }

    private static void addListHeader(@NotNull StringBuilder sb) {
        sb.append("\n\n--- attachments ---");
    }

    private static StringBuilder addAttachmentsStringUsingWikiCommit(@NotNull StringBuilder sb, ResourceType type, String id) {
        try {
            List<Map<String, String>> attachments = AttachmentApp.getFileList(type.toString(), id).get("attachments");
            if (attachments.size() > 0) {
                MigrationApp.addListHeader(sb);
            }
            for (Map<String, String> attachment : attachments) {
                sb.append(String.format("\n[%s](../wiki/files/%s/%s)", attachment.get("name"), attachment.get("id"), attachment.get("name").replaceAll("#", "%23")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb;
    }

    private static ObjectNode composePostJson(Posting posting) {
        Object[] objectArray = new Object[3];
        Object object = posting;
        Object object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getOwner();
        objectArray[0] = YONA_SERVER + (String)object2;
        object = posting;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        objectArray[1] = object2 = ((Project)object).getName();
        objectArray[2] = posting.getNumber();
        String originalPostingLink = String.format("%s/%s/post/%s", objectArray);
        ObjectNode node = Json.newObject();
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getTitle();
        node.put("title", (String)object2);
        StringBuilder sb = new StringBuilder();
        if (MigrationApp.usingWikiCommitForAttachment()) {
            object = posting;
            object2 = null;
            object2 = ((AbstractPosting)object).getBody();
            String string = MigrationApp.relativeLinksToWikiCommitPath((String)object2);
            object = posting;
            object2 = null;
            Object object3 = object2 = ((AbstractPosting)object).getAuthorLoginId();
            object = posting;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorName();
            sb.append(MigrationApp.addOriginalAuthorName(string, (String)object3, (String)object2, "\uac8c\uc2dc\uae00", originalPostingLink));
            object = posting;
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            sb = MigrationApp.addAttachmentsStringUsingWikiCommit(sb, ResourceType.BOARD_POST, ((Long)object2).toString());
        } else {
            object = posting;
            object2 = null;
            object2 = ((AbstractPosting)object).getBody();
            String string = MigrationApp.relativeLinksToAbsolutePath((String)object2);
            object = posting;
            object2 = null;
            Object object4 = object2 = ((AbstractPosting)object).getAuthorLoginId();
            object = posting;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorName();
            sb.append(MigrationApp.addOriginalAuthorName(string, (String)object4, (String)object2, "\uac8c\uc2dc\uae00", originalPostingLink));
            object = posting;
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            sb = MigrationApp.addAttachmentsString(sb, ResourceType.BOARD_POST, ((Long)object2).toString());
        }
        node.put("body", sb.toString());
        object = posting;
        object2 = null;
        object2 = ((AbstractPosting)object).getCreatedDate();
        node.put("created_at", LocalDateTime.ofInstant(((Date)object2).toInstant(), ZoneId.systemDefault()).format(formatter));
        ObjectNode postingJson = Json.newObject();
        postingJson.put("issue", (JsonNode)node);
        postingJson.put("comments", Json.toJson(MigrationApp.composeCommentsJson(posting, originalPostingLink, ResourceType.NONISSUE_COMMENT)));
        return postingJson;
    }

    private static boolean usingWikiCommitForAttachment() {
        String withWikiCommit = Http.Context.Implicit.request().getQueryString("withWikiCommit");
        boolean usingWikiCommit = StringUtils.isNotBlank((String)withWikiCommit) && withWikiCommit.endsWith("true");
        return usingWikiCommit;
    }

    private static ObjectNode composeIssueJson(Issue issue2) {
        Object[] objectArray = new Object[3];
        Object object = issue2;
        Object object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        object2 = ((Project)object).getOwner();
        objectArray[0] = YONA_SERVER + (String)object2;
        object = issue2;
        object2 = null;
        object = object2 = ((AbstractPosting)object).getProject();
        object2 = null;
        objectArray[1] = object2 = ((Project)object).getName();
        objectArray[2] = issue2.getNumber();
        String originalIssueLink = String.format("%s/%s/issue/%s", objectArray);
        ObjectNode node = Json.newObject();
        object = issue2;
        object2 = null;
        object2 = ((AbstractPosting)object).getId();
        node.put("id", (Long)object2);
        object = issue2;
        object2 = null;
        object2 = ((AbstractPosting)object).getTitle();
        node.put("title", (String)object2);
        StringBuilder sb = new StringBuilder();
        if (MigrationApp.usingWikiCommitForAttachment()) {
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getBody();
            String string = MigrationApp.relativeLinksToWikiCommitPath((String)object2);
            object = issue2;
            object2 = null;
            Object object3 = object2 = ((AbstractPosting)object).getAuthorLoginId();
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorName();
            sb.append(MigrationApp.addOriginalAuthorName(string, (String)object3, (String)object2, "\uc774\uc288", originalIssueLink));
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            sb = MigrationApp.addAttachmentsStringUsingWikiCommit(sb, ResourceType.ISSUE_POST, ((Long)object2).toString());
        } else {
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getBody();
            String string = MigrationApp.relativeLinksToAbsolutePath((String)object2);
            object = issue2;
            object2 = null;
            Object object4 = object2 = ((AbstractPosting)object).getAuthorLoginId();
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getAuthorName();
            sb.append(MigrationApp.addOriginalAuthorName(string, (String)object4, (String)object2, "\uc774\uc288", originalIssueLink));
            object = issue2;
            object2 = null;
            object2 = ((AbstractPosting)object).getId();
            sb = MigrationApp.addAttachmentsString(sb, ResourceType.ISSUE_POST, ((Long)object2).toString());
        }
        node.put("body", sb.toString());
        object = issue2;
        object2 = null;
        object2 = ((AbstractPosting)object).getCreatedDate();
        node.put("created_at", LocalDateTime.ofInstant(((Date)object2).toInstant(), ZoneId.systemDefault()).format(formatter));
        object = issue2;
        object2 = null;
        object2 = ((Issue)object).getAssignee();
        Optional.ofNullable(object2).ifPresent(assignee -> {
            Model model = assignee;
            Object object = null;
            object = model.getUser();
            model = object;
            object = null;
            object = model.getLoginId();
            node.put("assignee", (String)object);
        });
        object = issue2;
        object2 = null;
        object2 = ((Issue)object).getMilestone();
        Optional.ofNullable(object2).ifPresent(milestone2 -> {
            Milestone milestone3 = milestone2;
            String string = null;
            string = milestone3.getTitle();
            node.put("milestone", string);
        });
        object = issue2;
        object2 = null;
        object2 = ((Issue)object).getMilestone();
        Optional.ofNullable(object2).ifPresent(milestone2 -> {
            Milestone milestone3 = milestone2;
            Long l = null;
            l = milestone3.getId();
            node.put("milestoneId", l);
        });
        node.put("closed", issue2.isClosed());
        ObjectNode issueJson = Json.newObject();
        issueJson.put("issue", (JsonNode)node);
        issueJson.put("comments", Json.toJson(MigrationApp.composeCommentsJson(issue2, originalIssueLink, ResourceType.ISSUE_COMMENT)));
        return issueJson;
    }

    public static List<ObjectNode> composeCommentsJson(AbstractPosting posting, String orgLink, ResourceType type) {
        ArrayList<ObjectNode> comments = new ArrayList<ObjectNode>();
        for (Comment comment : posting.getComments()) {
            StringBuilder sb = new StringBuilder();
            ObjectNode commentNode = Json.newObject();
            Comment comment2 = comment;
            Object object = null;
            object = comment2.getCreatedDate();
            commentNode.put("created_at", LocalDateTime.ofInstant(((Date)object).toInstant(), ZoneId.systemDefault()).format(formatter));
            if (MigrationApp.usingWikiCommitForAttachment()) {
                comment2 = comment;
                object = null;
                object = comment2.getContents();
                String string = MigrationApp.relativeLinksToWikiCommitPath((String)object);
                comment2 = comment;
                object = null;
                Object object2 = object = comment2.getAuthorLoginId();
                comment2 = comment;
                object = null;
                Object object3 = object = comment2.getAuthorName();
                comment2 = comment;
                object = null;
                object = comment2.getId();
                sb.append(MigrationApp.addOriginalAuthorName(string, (String)object2, (String)object3, "\ucf54\uba58\ud2b8", orgLink + "#comment-" + object));
                comment2 = comment;
                object = null;
                object = comment2.getId();
                sb = MigrationApp.addAttachmentsStringUsingWikiCommit(sb, type, ((Long)object).toString());
            } else {
                comment2 = comment;
                object = null;
                object = comment2.getContents();
                String string = MigrationApp.relativeLinksToAbsolutePath((String)object);
                comment2 = comment;
                object = null;
                Object object4 = object = comment2.getAuthorLoginId();
                comment2 = comment;
                object = null;
                Object object5 = object = comment2.getAuthorName();
                comment2 = comment;
                object = null;
                object = comment2.getId();
                sb.append(MigrationApp.addOriginalAuthorName(string, (String)object4, (String)object5, "\ucf54\uba58\ud2b8", orgLink + "#comment-" + object));
                comment2 = comment;
                object = null;
                object = comment2.getId();
                sb = MigrationApp.addAttachmentsString(sb, type, ((Long)object).toString());
            }
            commentNode.put("body", sb.toString());
            comments.add(commentNode);
        }
        return comments;
    }

    public static List<ObjectNode> composePlainCommentsJson(AbstractPosting posting, ResourceType type) {
        ArrayList<ObjectNode> comments = new ArrayList<ObjectNode>();
        for (Comment comment : posting.getComments()) {
            ObjectNode commentNode = Json.newObject();
            Comment comment2 = comment;
            Object object = null;
            object = comment2.getId();
            commentNode.put("id", (Long)object);
            commentNode.put("type", comment.asResource().getType().toString());
            comment2 = comment;
            object = null;
            object = comment2.getAuthorLoginId();
            commentNode.put("authorId", (String)object);
            comment2 = comment;
            object = null;
            object = comment2.getAuthorName();
            commentNode.put("authorName", (String)object);
            comment2 = comment;
            object = null;
            object = comment2.getCreatedDate();
            commentNode.put("created_at", ((Date)object).getTime());
            comment2 = comment;
            object = null;
            object = comment2.getContents();
            commentNode.put("body", (String)object);
            List<Attachment> attachments = Attachment.findByContainer(comment.asResource());
            if (attachments.size() > 0) {
                commentNode.put("attachments", Json.toJson(attachments));
            }
            comments.add(commentNode);
        }
        return comments;
    }

    private static void gatheringUserProjects(Set<Project> targetProjects) {
        User worker;
        User user = worker = UserApp.currentUser();
        List<ProjectUser> list2 = null;
        list2 = user.getProjectUser();
        targetProjects.addAll(list2.stream().filter(projectUser -> {
            Model model = worker;
            Object object = null;
            object = model.getLoginId();
            String string = object;
            model = projectUser;
            object = null;
            object = model.getProject();
            return ProjectUser.isAllowedToSettings(string, (Project)object);
        }).map(projectUser -> {
            ProjectUser projectUser2 = projectUser;
            Project project2 = null;
            project2 = projectUser2.getProject();
            return project2;
        }).collect(Collectors.toList()));
    }

    private static void getheringOrgProjects(Set<Project> targetProjects) {
        User worker = UserApp.currentUser();
        Object object = worker;
        List<Project> list2 = null;
        list2 = ((User)object).getId();
        for (OrganizationUser organizationUser : OrganizationUser.findByAdmin((Long)((Object)list2))) {
            object = organizationUser;
            list2 = null;
            list2 = ((OrganizationUser)((Object)object)).getOrganization();
            object = list2;
            list2 = null;
            list2 = ((Organization)object).getProjects();
            targetProjects.addAll(list2);
        }
    }
}

