/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import controllers.annotation.IsCreatable;
import controllers.routes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Size;
import models.IssueLabel;
import models.IssueLabelCategory;
import models.Project;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import play.core.enhancers.PropertiesEnhancer;
import play.data.DynamicForm;
import play.data.Form;
import play.data.validation.Constraints;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.libs.Json;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.ErrorViews;
import utils.HttpUtil;
import views.html.common.issueLabelColor;
import views.html.project.issuelabels;
import views.html.project.partial_issuelabels_list;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IssueLabelApp
extends Controller {
    @IsAllowed(value=Operation.READ)
    public static Result labels(String ownerName, String projectName) {
        if (HttpUtil.isPJAXRequest(IssueLabelApp.request()).booleanValue()) {
            return IssueLabelApp.labelsAsPjax(ownerName, projectName);
        }
        return IssueLabelApp.labelsAsJSON(ownerName, projectName);
    }

    private static Result labelsAsJSON(String ownerName, String projectName) {
        if (!IssueLabelApp.request().accepts("application/json")) {
            return IssueLabelApp.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        ArrayList labels2 = new ArrayList();
        for (IssueLabel label : IssueLabel.findByProject(project2)) {
            HashMap<String, Object> labelPropertyMap = new HashMap<String, Object>();
            Object object = label;
            Object object2 = null;
            object2 = ((IssueLabel)object).getId();
            labelPropertyMap.put("id", "" + object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            object2 = null;
            object2 = ((IssueLabelCategory)object).getName();
            labelPropertyMap.put("category", object2);
            object = label;
            object2 = null;
            object = object2 = ((IssueLabel)object).getCategory();
            object2 = null;
            object2 = ((IssueLabelCategory)object).getId();
            labelPropertyMap.put("categoryId", "" + object2);
            object = label;
            object2 = null;
            object2 = ((IssueLabel)object).getColor();
            labelPropertyMap.put("color", object2);
            object = label;
            object2 = null;
            object2 = ((IssueLabel)object).getName();
            labelPropertyMap.put("name", object2);
            labels2.add(labelPropertyMap);
        }
        IssueLabelApp.response().setHeader("Content-Type", "application/json");
        return IssueLabelApp.ok((JsonNode)Json.toJson(labels2));
    }

    private static Result labelsAsPjax(String ownerName, String projectName) {
        IssueLabelApp.response().setHeader("Cache-Control", "no-cache, no-store");
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        List<IssueLabel> labels2 = IssueLabel.findByProject(project2);
        return IssueLabelApp.ok((Content)partial_issuelabels_list.render(project2, labels2));
    }

    @IsAllowed(value=Operation.UPDATE)
    public static Result labelsForm(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        List<IssueLabel> labels2 = IssueLabel.findByProject(project2);
        return IssueLabelApp.ok((Content)issuelabels.render(project2, labels2));
    }

    @Transactional
    @IsCreatable(value=ResourceType.ISSUE_LABEL)
    public static Result newLabel(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        Form newLabelForm = Form.form(NewLabel.class).bindFromRequest(new String[0]);
        if (newLabelForm.hasErrors()) {
            return IssueLabelApp.badRequest((JsonNode)newLabelForm.errorsAsJson());
        }
        IssueLabelCategory category2 = ((NewLabel)newLabelForm.get()).getIssueLabelCategory(project2);
        if (category2.exists()) {
            category2 = IssueLabelCategory.findBy(category2);
        } else {
            category2.save();
        }
        IssueLabel label = ((NewLabel)newLabelForm.get()).getIssueLabel(project2, category2);
        if (label.exists()) {
            return IssueLabelApp.noContent();
        }
        label.save();
        if (!IssueLabelApp.request().accepts("application/json")) {
            return IssueLabelApp.created();
        }
        IssueLabelApp.response().setHeader("Content-Type", "application/json");
        HashMap<String, Object> labelPropertyMap = new HashMap<String, Object>();
        Object object = label;
        Object object2 = null;
        object2 = ((IssueLabel)object).getId();
        labelPropertyMap.put("id", "" + object2);
        object = label;
        object2 = null;
        object2 = ((IssueLabel)object).getName();
        labelPropertyMap.put("name", object2);
        object = label;
        object2 = null;
        object2 = ((IssueLabel)object).getColor();
        labelPropertyMap.put("color", object2);
        object = label;
        object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        object2 = null;
        object2 = ((IssueLabelCategory)object).getName();
        labelPropertyMap.put("category", object2);
        object = label;
        object2 = null;
        object = object2 = ((IssueLabel)object).getCategory();
        object2 = null;
        object2 = ((IssueLabelCategory)object).getId();
        labelPropertyMap.put("categoryId", "" + object2);
        return IssueLabelApp.created((JsonNode)Json.toJson(labelPropertyMap));
    }

    @Transactional
    @IsAllowed(value=Operation.DELETE, resourceType=ResourceType.ISSUE_LABEL)
    public static Result delete(String ownerName, String projectName, Long id) {
        IssueLabel label;
        DynamicForm bindedForm = Form.form().bindFromRequest(new String[0]);
        if (!bindedForm.get("_method").toLowerCase().equals("delete")) {
            return IssueLabelApp.badRequest((Content)ErrorViews.BadRequest.render("_method must be 'delete'."));
        }
        IssueLabel issueLabel = label = (IssueLabel)IssueLabel.finder.byId((Object)id);
        Model model = null;
        IssueLabelCategory category2 = model = issueLabel.getCategory();
        label.delete();
        issueLabel = label;
        model = null;
        model = issueLabel.getProject();
        long labelCategoryRemainCount = IssueLabel.findByProject((Project)model).stream().filter(lb -> {
            IssueLabel issueLabel = lb;
            IssueLabelCategory issueLabelCategory = null;
            issueLabelCategory = issueLabel.getCategory();
            return issueLabelCategory.equals(category2);
        }).count();
        if (labelCategoryRemainCount == 0L) {
            category2.delete();
        }
        return IssueLabelApp.ok();
    }

    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.ISSUE_LABEL)
    public static Result update(String ownerName, String projectName, Long id) {
        Form form = new Form(IssueLabel.class).bindFromRequest(new String[0]);
        if (form.hasErrors()) {
            return IssueLabelApp.badRequest((JsonNode)form.errorsAsJson());
        }
        IssueLabel label = (IssueLabel)form.get();
        Object object = id;
        IssueLabel issueLabel = label;
        issueLabel.setId((Long)object);
        object = Project.findByOwnerAndProjectName(ownerName, projectName);
        issueLabel = label;
        issueLabel.setProject((Project)object);
        label.update();
        return IssueLabelApp.ok();
    }

    @IsAllowed(value=Operation.READ)
    public static Result labelStyles(String ownerName, String projectName) {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        List<IssueLabel> labels2 = IssueLabel.findByProject(project2);
        String eTag = "\"" + labels2.hashCode() + "\"";
        String ifNoneMatchValue = IssueLabelApp.request().getHeader("If-None-Match");
        if (ifNoneMatchValue != null && ifNoneMatchValue.equals(eTag)) {
            IssueLabelApp.response().setHeader("ETag", eTag);
            return IssueLabelApp.status((int)304);
        }
        IssueLabelApp.response().setHeader("ETag", eTag);
        return IssueLabelApp.ok((Content)issueLabelColor.render(labels2)).as("text/css");
    }

    @IsAllowed(value=Operation.READ)
    public static Result categories(String ownerName, String projectName) {
        if (!IssueLabelApp.request().accepts("application/json")) {
            return IssueLabelApp.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        ArrayList<Map<String, String>> categories2 = new ArrayList<Map<String, String>>();
        for (IssueLabelCategory category2 : IssueLabelCategory.findByProject(project2)) {
            categories2.add(IssueLabelApp.toMap(category2));
        }
        return IssueLabelApp.ok((JsonNode)Json.toJson(categories2)).as("application/json");
    }

    @IsAllowed(value=Operation.READ, resourceType=ResourceType.ISSUE_LABEL_CATEGORY)
    public static Result category(String ownerName, String projectName, Long id) {
        if (!IssueLabelApp.request().accepts("application/json")) {
            return IssueLabelApp.status((int)406);
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        IssueLabelCategory category2 = (IssueLabelCategory)IssueLabelCategory.find.byId((Object)id);
        return IssueLabelApp.ok((JsonNode)Json.toJson(IssueLabelApp.toMap(category2))).as("application/json");
    }

    @IsAllowed(value=Operation.UPDATE, resourceType=ResourceType.ISSUE_LABEL_CATEGORY)
    public static Result updateCategory(String ownerName, String projectName, Long id) {
        IssueLabelCategory category2;
        Form form = new Form(IssueLabelCategory.class).bindFromRequest(new String[0]);
        if (form.hasErrors()) {
            return IssueLabelApp.badRequest((JsonNode)form.errorsAsJson());
        }
        IssueLabelCategory issueLabelCategory = category2 = (IssueLabelCategory)form.get();
        Object object = null;
        object = issueLabelCategory.getProject();
        if (IssueLabelCategory.findByProject((Project)object).stream().filter(lc -> {
            IssueLabelCategory issueLabelCategory = lc;
            Object object = null;
            object = issueLabelCategory.getName();
            String string = object;
            issueLabelCategory = category2;
            object = null;
            object = issueLabelCategory.getName();
            if (!string.equals(object)) return false;
            issueLabelCategory = lc;
            object = null;
            Object object2 = object = issueLabelCategory.getId();
            issueLabelCategory = category2;
            object = null;
            object = issueLabelCategory.getId();
            if (((Long)object2).equals(object)) return false;
            return true;
        }).count() > 0L) {
            return IssueLabelApp.badRequest((JsonNode)form.errorsAsJson());
        }
        object = id;
        issueLabelCategory = category2;
        issueLabelCategory.setId((Long)object);
        object = Project.findByOwnerAndProjectName(ownerName, projectName);
        issueLabelCategory = category2;
        issueLabelCategory.setProject((Project)object);
        category2.update();
        return IssueLabelApp.ok();
    }

    @IsCreatable(value=ResourceType.ISSUE_LABEL_CATEGORY)
    public static Result newCategory(String ownerName, String projectName) {
        Form form = new Form(IssueLabelCategory.class).bindFromRequest(new String[0]);
        if (form.hasErrors()) {
            return IssueLabelApp.badRequest();
        }
        IssueLabelCategory category2 = (IssueLabelCategory)form.get();
        Object object = Project.findByOwnerAndProjectName(ownerName, projectName);
        IssueLabelCategory issueLabelCategory = category2;
        issueLabelCategory.setProject((Project)object);
        if (category2.exists()) {
            return IssueLabelApp.noContent();
        }
        category2.save();
        if (!IssueLabelApp.request().accepts("application/json")) {
            return IssueLabelApp.created();
        }
        HashMap<String, Object> categoryPropertyMap = new HashMap<String, Object>();
        issueLabelCategory = category2;
        object = null;
        object = issueLabelCategory.getId();
        categoryPropertyMap.put("id", "" + object);
        issueLabelCategory = category2;
        object = null;
        object = issueLabelCategory.getName();
        categoryPropertyMap.put("name", object);
        issueLabelCategory = category2;
        boolean bl = false;
        bl = issueLabelCategory.getIsExclusive();
        categoryPropertyMap.put("isExclusive", "" + bl);
        return IssueLabelApp.created((JsonNode)Json.toJson(categoryPropertyMap)).as("application/json");
    }

    @Transactional
    @IsAllowed(value=Operation.DELETE, resourceType=ResourceType.ISSUE_LABEL_CATEGORY)
    public static Result deleteCategory(String ownerName, String projectName, Long id) {
        ((IssueLabelCategory)IssueLabelCategory.find.byId((Object)id)).delete();
        return IssueLabelApp.ok();
    }

    private static Map<String, String> toMap(IssueLabelCategory category2) {
        HashMap<String, String> map = new HashMap<String, String>();
        IssueLabelCategory issueLabelCategory = category2;
        Object object = null;
        object = issueLabelCategory.getId();
        map.put("id", "" + object);
        issueLabelCategory = category2;
        object = null;
        object = issueLabelCategory.getName();
        map.put("name", (String)object);
        issueLabelCategory = category2;
        boolean bl = false;
        bl = issueLabelCategory.getIsExclusive();
        map.put("isExclusive", "" + bl);
        return map;
    }

    @IsCreatable(value=ResourceType.ISSUE_LABEL)
    public static Result copyLabels(String ownerName, String projectName) {
        Map form = IssueLabelApp.request().body().asFormUrlEncoded();
        String fromOwner = HttpUtil.getFirstValueFromQuery(form, "owner");
        String fromProjectName = HttpUtil.getFirstValueFromQuery(form, "projectName");
        Project fromProject = Project.findByOwnerAndProjectName(fromOwner, fromProjectName);
        Project toProject = Project.findByOwnerAndProjectName(ownerName, projectName);
        if (fromProject != null && toProject != null && AccessControl.isAllowed(UserApp.currentUser(), fromProject.labelsAsResource(), Operation.READ)) {
            IssueLabel.copyIssueLabels(fromProject, toProject);
        }
        return IssueLabelApp.redirect((Call)routes.IssueLabelApp.labelsForm(ownerName, projectName));
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class NewLabel {
        @Constraints.Required(message="label.error.labelName.empty")
        @Size(max=255, message="label.error.labelName.tooLongSize")
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String labelName;
        @Constraints.Required(message="label.error.color.empty")
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String labelColor;
        @Constraints.Required(message="label.error.categoryName.empty")
        @Size(max=255, message="label.error.categoryName.tooLongSize")
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String categoryName;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public boolean categoryIsExclusive;

        public IssueLabelCategory getIssueLabelCategory(Project project2) {
            IssueLabelCategory category2 = new IssueLabelCategory();
            Object object = project2;
            Object object2 = category2;
            ((IssueLabelCategory)object2).setProject((Project)object);
            object2 = this;
            object = null;
            object = ((NewLabel)object2).getCategoryName();
            object2 = category2;
            ((IssueLabelCategory)object2).setName((String)object);
            object2 = this;
            boolean bl = false;
            bl = ((NewLabel)object2).getCategoryIsExclusive();
            object2 = category2;
            ((IssueLabelCategory)object2).setIsExclusive(bl);
            return category2;
        }

        public IssueLabel getIssueLabel(Project project2, IssueLabelCategory category2) {
            IssueLabel label = new IssueLabel();
            Object object = project2;
            Object object2 = label;
            ((IssueLabel)object2).setProject((Project)object);
            object2 = this;
            object = null;
            object = ((NewLabel)object2).getLabelName();
            object2 = label;
            ((IssueLabel)object2).setName((String)object);
            object2 = this;
            object = null;
            object = ((NewLabel)object2).getLabelColor();
            object2 = label;
            ((IssueLabel)object2).setColor((String)object);
            object = category2;
            object2 = label;
            ((IssueLabel)object2).setCategory((IssueLabelCategory)object);
            return label;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getLabelName() {
            return this.labelName;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLabelName(String string) {
            this.labelName = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getLabelColor() {
            return this.labelColor;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setLabelColor(String string) {
            this.labelColor = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getCategoryName() {
            return this.categoryName;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setCategoryName(String string) {
            this.categoryName = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public boolean getCategoryIsExclusive() {
            return this.categoryIsExclusive;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setCategoryIsExclusive(boolean bl) {
            this.categoryIsExclusive = bl;
        }
    }
}

