/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.routes;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import models.Organization;
import models.OrganizationUser;
import models.Project;
import models.ProjectMenuSetting;
import models.ProjectUser;
import models.User;
import models.enumeration.RoleType;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.db.ebean.Transactional;
import play.i18n.Messages;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;
import playRepository.GitRepository;
import utils.AccessControl;
import utils.ErrorViews;
import utils.FileUtil;
import utils.ValidationResult;
import views.html.project.create;
import views.html.project.importing;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ImportApp
extends Controller {
    @AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
    public static Result importForm() {
        Form projectForm = Form.form(Project.class).bindFromRequest(new String[]{"owner"});
        projectForm.discardErrors();
        User user = UserApp.currentUser();
        Long l = null;
        l = user.getId();
        List<OrganizationUser> orgUserList = OrganizationUser.findByAdmin(l);
        return ImportApp.ok((Content)importing.render("title.newProject", (Form<Project>)projectForm, orgUserList));
    }

    @Transactional
    public static Result newProject() throws Exception {
        Model model;
        Object object;
        User user;
        String owner;
        Organization organization2;
        if (!AccessControl.isGlobalResourceCreatable(UserApp.currentUser())) {
            User user2 = UserApp.currentUser();
            String string = null;
            string = user2.getName();
            return ImportApp.forbidden((String)("'" + string + "' has no permission"));
        }
        Form filledNewProjectForm = Form.form(Project.class).bindFromRequest(new String[0]);
        ValidationResult result2 = ImportApp.validateForm((Form<Project>)filledNewProjectForm, organization2 = Organization.findByName(owner = filledNewProjectForm.field("owner").value()), user = User.findByLoginId(owner));
        if (result2.hasError()) {
            return result2.getResult();
        }
        String gitUrl = (String)filledNewProjectForm.data().get("url");
        Project project2 = (Project)filledNewProjectForm.get();
        if (Organization.isNameExist(owner)) {
            object = organization2;
            model = project2;
            model.setOrganization((Organization)object);
        }
        String authId = filledNewProjectForm.field("authId").value();
        String authPw = filledNewProjectForm.field("authPw").value();
        boolean hasNoCredentials = StringUtils.isEmpty((CharSequence)authId) && StringUtils.isEmpty((CharSequence)authPw);
        try {
            if (hasNoCredentials) {
                GitRepository.cloneRepository(gitUrl, project2);
            } else {
                GitRepository.cloneRepository(gitUrl, project2, authId, authPw);
            }
            Long projectId = Project.create(project2);
            ImportApp.saveProjectMenuSetting(project2);
            if (User.isLoginIdExist(owner)) {
                model = UserApp.currentUser();
                object = null;
                object = model.getId();
                ProjectUser.assignRole((Long)object, projectId, RoleType.MANAGER);
            }
        }
        catch (InvalidRemoteException e) {
            filledNewProjectForm.reject("url", "project.import.error.wrong.url");
        }
        catch (JGitInternalException e) {
            filledNewProjectForm.reject("url", "project.import.error.wrong.url");
        }
        catch (TransportException e) {
            ImportApp.addDetailedTransportErrorMessage((Form<Project>)filledNewProjectForm, e, hasNoCredentials);
        }
        if (!filledNewProjectForm.errors().isEmpty()) {
            model = UserApp.currentUser();
            object = null;
            object = model.getId();
            List<OrganizationUser> orgUserList = OrganizationUser.findByAdmin((Long)object);
            FileUtil.rm_rf(GitRepository.getGitDirectory(project2));
            return ImportApp.badRequest((Content)importing.render("title.newProject", (Form<Project>)filledNewProjectForm, orgUserList));
        }
        model = project2;
        object = null;
        Object object2 = object = model.getOwner();
        model = project2;
        object = null;
        object = model.getName();
        return ImportApp.redirect((Call)routes.ProjectApp.project((String)object2, (String)object));
    }

    private static void saveProjectMenuSetting(Project project2) {
        Form filledUpdatedProjectMenuSettingForm = Form.form(ProjectMenuSetting.class).bindFromRequest(new String[0]);
        ProjectMenuSetting updatedProjectMenuSetting = (ProjectMenuSetting)((Object)filledUpdatedProjectMenuSettingForm.get());
        project2.refresh();
        Object object = project2;
        Model model = updatedProjectMenuSetting;
        model.setProject((Project)object);
        model = project2;
        object = null;
        object = model.getMenuSetting();
        if (object == null) {
            updatedProjectMenuSetting.save();
        } else {
            model = project2;
            object = null;
            object = model.getMenuSetting();
            model = object;
            object = null;
            object = model.getId();
            model = updatedProjectMenuSetting;
            model.setId((Long)object);
            updatedProjectMenuSetting.update();
        }
    }

    private static void addDetailedTransportErrorMessage(Form<Project> filledNewProjectForm, TransportException e, boolean hasNoCredentials) {
        String errorMessage = e.getMessage();
        if (errorMessage.contains(JGitText.get().notAuthorized)) {
            if (hasNoCredentials) {
                filledNewProjectForm.reject("repoAuth", "required");
                filledNewProjectForm.reject("url", "project.import.error.transport.unauthorized");
            } else {
                filledNewProjectForm.reject("authId", "project.import.error.transport.failedToAuth");
            }
        } else if (errorMessage.contains(MessageFormat.format(JGitText.get().serviceNotPermitted, ""))) {
            filledNewProjectForm.reject("url", "project.import.error.transport.forbidden");
        } else {
            String statusCode = errorMessage.split(" ")[1];
            filledNewProjectForm.reject("url", Messages.get((String)"project.import.error.transport", (Object[])new Object[]{statusCode}));
        }
    }

    private static ValidationResult validateForm(Form<Project> newProjectForm2, Organization organization2, User user) {
        String gitUrl;
        boolean hasError = false;
        Results.Status result2 = null;
        Model model = UserApp.currentUser();
        Object object = null;
        object = model.getId();
        List<OrganizationUser> orgUserList = OrganizationUser.findByAdmin((Long)object);
        String owner = newProjectForm2.field("owner").value();
        String name = newProjectForm2.field("name").value();
        boolean ownerIsUser = User.isLoginIdExist(owner);
        boolean ownerIsOrganization = Organization.isNameExist(owner);
        if (!ownerIsUser && !ownerIsOrganization) {
            newProjectForm2.reject("owner", "project.owner.invalidate");
            hasError = true;
            result2 = ImportApp.badRequest((Content)create.render("title.newProject", newProjectForm2, orgUserList));
        }
        if (ownerIsUser) {
            model = UserApp.currentUser();
            object = null;
            object = model.getId();
            Long l = object;
            model = user;
            object = null;
            object = model.getId();
            if (!Objects.equals(l, object)) {
                newProjectForm2.reject("owner", "project.owner.invalidate");
                hasError = true;
                result2 = ImportApp.badRequest((Content)create.render("title.newProject", newProjectForm2, orgUserList));
            }
        }
        if (ownerIsOrganization) {
            model = organization2;
            object = null;
            object = model.getId();
            Long l = object;
            model = UserApp.currentUser();
            object = null;
            object = model.getId();
            if (!OrganizationUser.isAdmin(l, (Long)object)) {
                hasError = true;
                model = UserApp.currentUser();
                object = null;
                object = model.getName();
                result2 = ImportApp.forbidden((Content)ErrorViews.Forbidden.render("'" + (String)object + "' has no permission"));
            }
        }
        if (Project.exists(owner, name)) {
            newProjectForm2.reject("name", "project.name.duplicate");
            hasError = true;
            result2 = ImportApp.badRequest((Content)importing.render("title.newProject", newProjectForm2, orgUserList));
        }
        if (StringUtils.isBlank((CharSequence)(gitUrl = StringUtils.trim((String)((String)newProjectForm2.data().get("url")))))) {
            newProjectForm2.reject("url", "project.import.error.empty.url");
            hasError = true;
            result2 = ImportApp.badRequest((Content)importing.render("title.newProject", newProjectForm2, orgUserList));
        }
        if (newProjectForm2.hasErrors()) {
            newProjectForm2.reject("name", "project.name.alert");
            hasError = true;
            result2 = ImportApp.badRequest((Content)importing.render("title.newProject", newProjectForm2, orgUserList));
        }
        return new ValidationResult((Result)result2, hasError);
    }
}

