/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import actions.DefaultProjectCheckAction;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import models.NotificationEvent;
import models.Project;
import models.ProjectUser;
import models.User;
import models.enumeration.RequestState;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Transactional;
import play.mvc.Controller;
import play.mvc.Result;
import play.mvc.With;

@AnonymousCheck(requiresLogin=true, displaysFlashMessage=true)
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class EnrollProjectApp
extends Controller {
    @Transactional
    @With(value={DefaultProjectCheckAction.class})
    public static Result enroll(String loginId, String projectName) {
        User user;
        Project project2 = Project.findByOwnerAndProjectName(loginId, projectName);
        if (!ProjectUser.isGuest(project2, user = UserApp.currentUser())) {
            return EnrollProjectApp.badRequest();
        }
        if (!User.enrolled(project2)) {
            user.enroll(project2);
            NotificationEvent.afterMemberRequest(project2, user, RequestState.REQUEST);
        }
        return EnrollProjectApp.ok();
    }

    @Transactional
    @With(value={DefaultProjectCheckAction.class})
    public static Result cancelEnroll(String loginId, String proejctName) {
        User user;
        Project project2 = Project.findByOwnerAndProjectName(loginId, proejctName);
        if (!ProjectUser.isGuest(project2, user = UserApp.currentUser())) {
            return EnrollProjectApp.badRequest();
        }
        if (User.enrolled(project2)) {
            user.cancelEnroll(project2);
            NotificationEvent.afterMemberRequest(project2, user, RequestState.CANCEL);
        }
        return EnrollProjectApp.ok();
    }
}

