/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.annotation.AnonymousCheck;
import controllers.annotation.IsAllowed;
import java.util.List;
import models.Project;
import models.enumeration.Operation;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import playRepository.Commit;
import playRepository.FileDiff;
import playRepository.PlayRepository;
import playRepository.RepositoryService;
import utils.ErrorViews;
import views.html.code.compare;
import views.html.code.compare_svn;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class CompareApp
extends Controller {
    @IsAllowed(value=Operation.READ)
    public static Result compare(String ownerName, String projectName, String revA, String revB) throws Exception {
        Project project2 = Project.findByOwnerAndProjectName(ownerName, projectName);
        PlayRepository repository = RepositoryService.getRepository(project2);
        Commit commitA = repository.getCommit(revA);
        Commit commitB = repository.getCommit(revB);
        if (commitA == null || commitB == null) {
            return CompareApp.notFound((Content)ErrorViews.NotFound.render("error.notfound.commit", project2));
        }
        Project project3 = project2;
        String string = null;
        string = project3.getVcs();
        if ("Subversion".equals(string)) {
            String patch = repository.getPatch(revA, revB);
            if (patch == null) {
                return CompareApp.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2));
            }
            return CompareApp.ok((Content)compare_svn.render(project2, commitA, commitB, patch));
        }
        List<FileDiff> diffs = repository.getDiff(revA, revB);
        if (diffs == null) {
            return CompareApp.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2));
        }
        return CompareApp.ok((Content)compare.render(project2, commitA, commitB, diffs));
    }
}

