/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.routes;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import models.Attachment;
import models.User;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import utils.AccessControl;
import utils.HttpUtil;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AttachmentApp
extends Controller {
    public static final String TAG_NAME_FOR_TEMPORARY_UPLOAD_FILES = "temporaryUploadFiles";
    public static final long TEMPORARYFILES_KEEPUP_TIME_MILLIS = Configuration.root().getMilliseconds("application.temporaryfiles.keep-up.time", Long.valueOf(86400000L));

    private static User findUploader(Map<String, String[]> formUrlEncoded) {
        if (formUrlEncoded == null || formUrlEncoded.isEmpty()) {
            return UserApp.currentUser();
        }
        String authorEmail = HttpUtil.getFirstValueFromQuery(formUrlEncoded, "authorEmail");
        User found = User.findByEmail(authorEmail);
        if (found.isAnonymous()) {
            String authorLoginId = HttpUtil.getFirstValueFromQuery(formUrlEncoded, "authorLoginId");
            User fallbackSearch = User.findByLoginId(authorLoginId);
            if (fallbackSearch.isAnonymous()) {
                return UserApp.currentUser();
            }
            return fallbackSearch;
        }
        return found;
    }

    public static Result uploadFile() throws NoSuchAlgorithmException, IOException {
        Http.MultipartFormData.FilePart filePart = AttachmentApp.request().body().asMultipartFormData().getFile("filePath");
        if (filePart == null) {
            return AttachmentApp.badRequest();
        }
        File file = filePart.getFile();
        User uploader = AttachmentApp.findUploader(AttachmentApp.request().body().asMultipartFormData().asFormUrlEncoded());
        if (uploader.isAnonymous()) {
            uploader = User.findByUserToken(User.extractUserTokenFromRequestHeader(AttachmentApp.request()));
        }
        if (uploader.isAnonymous()) {
            return AttachmentApp.forbidden();
        }
        Attachment attach = new Attachment();
        boolean isCreated = attach.store(file, Normalizer.normalize(filePart.getFilename(), Normalizer.Form.NFC), uploader.asResource());
        Attachment attachment = attach;
        Object object = null;
        object = attachment.getId();
        String url = routes.AttachmentApp.getFile((Long)object).url();
        AttachmentApp.response().setHeader("Location", url);
        String contentType = HttpUtil.getPreferType(AttachmentApp.request(), "application/json", "text/html");
        AttachmentApp.response().setHeader("Content-Type", contentType);
        AttachmentApp.response().setHeader("Vary", "Accept");
        HashMap<String, Object> fileInfo = new HashMap<String, Object>();
        attachment = attach;
        object = null;
        object = attachment.getId();
        fileInfo.put("id", ((Long)object).toString());
        attachment = attach;
        object = null;
        object = attachment.getMimeType();
        fileInfo.put("mimeType", object);
        attachment = attach;
        object = null;
        object = attachment.getName();
        fileInfo.put("name", object);
        fileInfo.put("url", url);
        attachment = attach;
        object = null;
        object = attachment.getSize();
        fileInfo.put("size", ((Long)object).toString());
        JsonNode responseBody = Json.toJson(fileInfo);
        if (isCreated) {
            return AttachmentApp.created((JsonNode)responseBody);
        }
        return AttachmentApp.ok((JsonNode)responseBody);
    }

    public static Result getFile(Long id) throws IOException {
        String dispositionType;
        Attachment attachment = (Attachment)Attachment.find.byId((Object)id);
        String action = HttpUtil.getFirstValueFromQuery(AttachmentApp.request().queryString(), "action");
        String string = dispositionType = StringUtils.equals((CharSequence)action, (CharSequence)"download") ? "attachment" : "inline";
        if (attachment == null) {
            return AttachmentApp.notFound((String)"The file does not exist.");
        }
        Attachment attachment2 = attachment;
        String string2 = null;
        string2 = attachment2.getHash();
        String eTag = "\"" + string2 + "-" + dispositionType + "\"";
        if (!AccessControl.isAllowed(UserApp.currentUser(), attachment.asResource(), Operation.READ)) {
            return AttachmentApp.forbidden((String)"You have no permission to get the file.");
        }
        AttachmentApp.response().setHeader("Cache-Control", "private, max-age=3600");
        String ifNoneMatchValue = AttachmentApp.request().getHeader("If-None-Match");
        if (ifNoneMatchValue != null && ifNoneMatchValue.equals(eTag)) {
            AttachmentApp.response().setHeader("ETag", eTag);
            return AttachmentApp.status((int)304);
        }
        File file = attachment.getFile();
        if (file != null && !file.exists()) {
            Logger.error((String)("Attachment ID:" + id + " (" + file.getAbsolutePath() + ") does not exist on storage"));
            return AttachmentApp.internalServerError((String)"The file does not exist");
        }
        attachment2 = attachment;
        string2 = null;
        string2 = attachment2.getName();
        String filename = HttpUtil.encodeContentDisposition(string2);
        if (AttachmentApp.request().hasHeader("RANGE")) {
            AttachmentApp.response().setHeader("Accept-Ranges", "bytes");
        }
        attachment2 = attachment;
        string2 = null;
        string2 = attachment2.getMimeType();
        AttachmentApp.response().setHeader("Content-Type", string2);
        AttachmentApp.response().setHeader("Content-Disposition", dispositionType + "; " + filename);
        AttachmentApp.response().setHeader("ETag", eTag);
        return AttachmentApp.ok((File)file);
    }

    public static Result deleteFile(Long id) {
        Map data2;
        Http.MultipartFormData formData = AttachmentApp.request().body().asMultipartFormData();
        if (formData != null && !HttpUtil.getFirstValueFromQuery(data2 = formData.asFormUrlEncoded(), "_method").toLowerCase().equals("delete")) {
            return AttachmentApp.badRequest((String)"_method must be 'delete'.");
        }
        Attachment attach = (Attachment)Attachment.find.byId((Object)id);
        if (attach == null) {
            return AttachmentApp.notFound();
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), attach.asResource(), Operation.DELETE)) {
            return AttachmentApp.forbidden();
        }
        attach.delete();
        Attachment attachment = attach;
        String string = null;
        string = attachment.getHash();
        AttachmentApp.logIfOriginFileIsNotValid(string);
        attachment = attach;
        string = null;
        string = attachment.getHash();
        if (Attachment.fileExists(string)) {
            return AttachmentApp.ok((String)"The attachment is removed successfully, but its origin file still exists.");
        }
        return AttachmentApp.ok((String)"Both the attachment and its origin file are removed successfully.");
    }

    private static void logIfOriginFileIsNotValid(String hash) {
        if (!Attachment.fileExists(hash) && Attachment.exists(hash)) {
            Logger.error((String)("The origin file '" + hash + "' cannot be found even if the file is still referred by someattachments."));
        }
        if (Attachment.fileExists(hash) && !Attachment.exists(hash)) {
            Logger.warn((String)("The attachment is removed successfully, but its origin file '" + hash + "' still exists abnormally even if the file referred by nowhere."));
        }
    }

    private static Map<String, String> extractFileMetaDataFromAttachementAsMap(Attachment attach) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        Attachment attachment = attach;
        Object object = null;
        object = attachment.getId();
        metadata.put("id", ((Long)object).toString());
        attachment = attach;
        object = null;
        object = attachment.getMimeType();
        metadata.put("mimeType", (String)object);
        attachment = attach;
        object = null;
        object = attachment.getName();
        metadata.put("name", (String)object);
        attachment = attach;
        object = null;
        object = attachment.getId();
        metadata.put("url", routes.AttachmentApp.getFile((Long)object).url());
        attachment = attach;
        object = null;
        object = attachment.getSize();
        metadata.put("size", ((Long)object).toString());
        return metadata;
    }

    public static Map<String, List<Map<String, String>>> getFileList(ResourceType resourceType, Long containerId) throws PermissionDeniedException {
        return AttachmentApp.getFileList(resourceType.toString(), String.valueOf(containerId));
    }

    public static Map<String, List<Map<String, String>>> getFileList(String containerType, String containerId) throws PermissionDeniedException {
        HashMap<String, List<Map<String, String>>> files = new HashMap<String, List<Map<String, String>>>();
        if (StringUtils.isNotEmpty((CharSequence)containerType) && StringUtils.isNotEmpty((CharSequence)containerId)) {
            ArrayList<Map<String, String>> attachments = new ArrayList<Map<String, String>>();
            for (Attachment attach : Attachment.findByContainer(ResourceType.valueOf(containerType), containerId)) {
                if (!AccessControl.isAllowed(UserApp.currentUser(), attach.asResource(), Operation.READ)) {
                    throw new PermissionDeniedException();
                }
                Attachment attachment = attach;
                String string = null;
                string = attachment.getName();
                string = Normalizer.normalize(string, Normalizer.Form.NFC);
                attachment = attach;
                attachment.setName(string);
                attachments.add(AttachmentApp.extractFileMetaDataFromAttachementAsMap(attach));
            }
            files.put("attachments", attachments);
        }
        return files;
    }

    public static Result getFileList() {
        Map query = AttachmentApp.request().queryString();
        String containerType = HttpUtil.getFirstValueFromQuery(query, "containerType");
        String containerId = HttpUtil.getFirstValueFromQuery(query, "containerId");
        AttachmentApp.response().setHeader("Content-Type", "application/json");
        try {
            return AttachmentApp.ok((JsonNode)Json.toJson(AttachmentApp.getFileList(containerType, containerId)));
        }
        catch (PermissionDeniedException e) {
            return AttachmentApp.forbidden();
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class PermissionDeniedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private PermissionDeniedException() {
        }
    }
}

