/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.controllers.Authenticate;
import com.feth.play.module.pa.user.AuthUserIdentity;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import controllers.routes;
import java.util.Iterator;
import jsmessages.JsMessages;
import models.Project;
import models.User;
import models.UserCredential;
import models.UserSetting;
import org.apache.commons.lang3.StringUtils;
import play.Configuration;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;
import play.db.ebean.Model;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import playRepository.RepositoryService;
import views.html.error.notfound_default;
import views.html.help.UIKit;
import views.html.index.index;
import views.html.index.notifications;
import views.html.index.sidebar;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Application
extends Controller {
    public static final String FLASH_MESSAGE_KEY = "message";
    public static final String FLASH_ERROR_KEY = "error";
    public static boolean useSocialNameSync = Configuration.root().getBoolean("application.use.social.login.name.sync", Boolean.valueOf(false));
    public static String GITHUB_NAME = Configuration.root().getString("application.social.login.github.name", "github");
    public static String ALLOWED_SENDING_MAIL_DOMAINS = Configuration.root().getString("application.allowed.sending.mail.domains", "");
    public static String PRIVATE_IS_DEFAULT = Configuration.root().getString("project.default.scope.when.create", "public");
    public static boolean HIDE_PROJECT_LISTING = Configuration.root().getBoolean("application.hide.project.listing", Boolean.valueOf(false));
    public static boolean SEND_YONA_USAGE = Configuration.root().getBoolean("application.send.yona.usage", Boolean.valueOf(true));
    public static String GUEST_USER_LOGIN_ID_PREFIX = Configuration.root().getString("application.guest.user.login.id.prefix ", "");
    public static String LOGIN_PAGE_LOGINID_PLACEHOLDER = Configuration.root().getString("application.login.page.loginId.placeholder", "");
    public static String LOGIN_PAGE_PASSWORD_PLACEHOLDER = Configuration.root().getString("application.login.page.password.placeholder", "");
    public static boolean SHOW_USER_EMAIL = Configuration.root().getBoolean("application.show.user.email", Boolean.valueOf(true));
    public static String NAVBAR_CUSTOM_LINK_NAME = Configuration.root().getString("application.navbar.custom.link.name", "");
    public static String NAVBAR_CUSTOM_LINK_URL = Configuration.root().getString("application.navbar.custom.link.url", "");
    static final JsMessages messages = JsMessages.create((play.Application)Play.application());

    @AnonymousCheck
    public static Result index() {
        User user = UserApp.currentUser();
        Model model = user;
        Object object = null;
        object = model.getId();
        UserSetting userSetting = UserSetting.findByUser((Long)object);
        if (!user.isAnonymous()) {
            model = userSetting;
            object = null;
            object = model.getLoginDefaultPage();
            if (StringUtils.isNotBlank((CharSequence)object)) {
                model = userSetting;
                object = null;
                object = model.getLoginDefaultPage();
                return Application.redirect((String)object);
            }
        }
        return Application.ok((Content)index.render(UserApp.currentUser()));
    }

    @AnonymousCheck
    public static Result sidebar() {
        return Application.ok((Content)sidebar.render(UserApp.currentUser()));
    }

    @AnonymousCheck
    public static Result notifications() {
        return Application.ok((Content)notifications.render(UserApp.currentUser()));
    }

    public static Result oAuth(String provider) {
        return Authenticate.authenticate((String)provider);
    }

    public static Result oAuthLogout() {
        UserApp.logout();
        Authenticate.logout();
        return Application.returnToReferer();
    }

    public static Result oAuthDenied(String providerKey) {
        Authenticate.noCache((Http.Response)Application.response());
        Application.flash((String)FLASH_ERROR_KEY, (String)"You need to accept the OAuth connection in order to use this website!");
        return Application.redirect((Call)routes.Application.index());
    }

    public static UserCredential getLocalUser(Http.Session session) {
        UserCredential localUser = UserCredential.findByAuthUserIdentity((AuthUserIdentity)PlayAuthenticate.getUser((Http.Session)session));
        return localUser;
    }

    public static UserCredential getLocalUser() {
        UserCredential localUser = UserCredential.findByAuthUserIdentity((AuthUserIdentity)PlayAuthenticate.getUser((Http.Session)Application.session()));
        return localUser;
    }

    public static Result removeTrailer(String paths) {
        String path = Application.request().path();
        if (path.charAt(path.length() - 1) != '/') {
            Logger.error((String)("Unexpected url call : " + Application.request().path()));
            return Application.notFound((Content)notfound_default.render("error.notfound"));
        }
        path = path.substring(0, path.length() - 1);
        Logger.debug((String)("Trailing slash removed and redirected: " + Application.request().path() + " to " + path));
        return Application.redirect((String)path);
    }

    public static Result init() {
        Application.makeTestRepository();
        return Application.redirect((Call)routes.Application.index());
    }

    public static Result jsMessages() {
        return Application.ok((Content)messages.generate("Messages")).as("application/javascript");
    }

    private static void makeTestRepository() {
        Iterator iterator = Project.find.all().iterator();
        while (iterator.hasNext()) {
            Project project2;
            Project project3 = project2 = (Project)iterator.next();
            String string = null;
            string = project3.getName();
            Logger.debug((String)("makeTestRepository: " + string));
            try {
                RepositoryService.createRepository(project2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Result navi() {
        return Application.ok((Content)index.render(UserApp.currentUser()));
    }

    public static Result UIKit() {
        return Application.ok((Content)UIKit.render());
    }

    public static Result fake() {
        return Application.badRequest();
    }

    public static Result returnToReferer() {
        return Application.redirect((String)StringUtils.defaultString((String)Application.request().getHeader("referer"), (String)Application.index().toString()));
    }
}

