/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.fasterxml.jackson.databind.JsonNode;
import controllers.AttachmentApp;
import controllers.UserApp;
import controllers.annotation.AnonymousCheck;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import models.AbstractPosting;
import models.Attachment;
import models.Comment;
import models.IssueLabel;
import models.Project;
import models.TitleHead;
import models.User;
import models.enumeration.Direction;
import models.enumeration.Operation;
import models.resource.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;
import play.data.Form;
import play.db.ebean.Model;
import play.i18n.Messages;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.ErrorViews;
import utils.HttpUtil;
import utils.JodaDateUtil;
import utils.diff_match_patch;

@AnonymousCheck
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class AbstractPostingApp
extends Controller {
    public static final int ITEMS_PER_PAGE = 15;
    private static final short Diff_EditCost = 16;

    public static Comment saveComment(Comment comment, Runnable containerUpdater) {
        containerUpdater.run();
        Comment comment2 = comment;
        Long l = null;
        l = comment2.getId();
        if (l != null && AccessControl.isAllowed(UserApp.currentUser(), comment.asResource(), Operation.UPDATE)) {
            comment.update();
        } else {
            comment.setAuthor(UserApp.currentUser());
            comment.save();
        }
        AbstractPostingApp.attachUploadFilesToPost(comment.asResource());
        return comment;
    }

    protected static Result delete(Model target, Resource resource, Call redirectTo) {
        if (!AccessControl.isAllowed(UserApp.currentUser(), resource, Operation.DELETE)) {
            return AbstractPostingApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", resource.getProject()));
        }
        target.delete();
        if (HttpUtil.isRequestedWithXHR(AbstractPostingApp.request()).booleanValue()) {
            AbstractPostingApp.response().setHeader("Location", redirectTo.url());
            return AbstractPostingApp.status((int)204);
        }
        return AbstractPostingApp.redirect((Call)redirectTo);
    }

    protected static Result editPosting(AbstractPosting original, AbstractPosting posting, Form<? extends AbstractPosting> postingForm, Call redirectTo, Runnable preUpdateHook) {
        if (postingForm.hasErrors()) {
            AbstractPosting abstractPosting = original;
            Project project2 = null;
            project2 = abstractPosting.getProject();
            return AbstractPostingApp.badRequest((Content)ErrorViews.BadRequest.render("error.validation", project2));
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), original.asResource(), Operation.UPDATE)) {
            AbstractPosting abstractPosting = original;
            Project project3 = null;
            project3 = abstractPosting.getProject();
            return AbstractPostingApp.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project3));
        }
        Model model = posting;
        Object object = null;
        object = model.getBody();
        if (object == null) {
            return AbstractPostingApp.status((int)413, (Content)ErrorViews.RequestTextEntityTooLarge.render());
        }
        model = original;
        object = null;
        object = model.getId();
        model = posting;
        model.setId((Long)object);
        model = original;
        object = null;
        object = model.getCreatedDate();
        model = posting;
        model.setCreatedDate((Date)object);
        object = JodaDateUtil.now();
        model = posting;
        model.setUpdatedDate((Date)object);
        model = original;
        object = null;
        object = model.getAuthorId();
        model = posting;
        model.setAuthorId((Long)object);
        model = original;
        object = null;
        object = model.getAuthorLoginId();
        model = posting;
        model.setAuthorLoginId((String)object);
        model = original;
        object = null;
        object = model.getAuthorName();
        model = posting;
        model.setAuthorName((String)object);
        model = original;
        object = null;
        object = model.getProject();
        model = posting;
        model.setProject((Project)object);
        posting.setNumber(original.getNumber());
        model = UserApp.currentUser();
        object = null;
        object = model.getId();
        model = posting;
        model.setUpdatedByAuthorId((Long)object);
        model = original;
        object = null;
        object = model.getBody();
        String string = StringUtils.defaultString((String)object, (String)"");
        model = posting;
        object = null;
        object = model.getBody();
        if (!string.equals(StringUtils.defaultString((String)object, (String)""))) {
            model = original;
            object = null;
            object = model.getHistory();
            object = AbstractPostingApp.addToHistory(original, posting) + StringUtils.defaultString((String)object, (String)"");
            model = posting;
            model.setHistory((String)object);
        }
        preUpdateHook.run();
        try {
            posting.checkLabels();
        }
        catch (IssueLabel.IssueLabelException e) {
            return AbstractPostingApp.badRequest((String)e.getMessage());
        }
        posting.update();
        posting.updateProperties();
        model = posting;
        object = null;
        Object object2 = object = model.getProject();
        model = posting;
        object = null;
        object = model.getTitle();
        TitleHead.saveTitleHeadKeyword((Project)object2, (String)object);
        model = original;
        object = null;
        Object object3 = object = model.getProject();
        model = original;
        object = null;
        object = model.getTitle();
        TitleHead.deleteTitleHeadKeyword((Project)object3, (String)object);
        AbstractPostingApp.attachUploadFilesToPost(original.asResource());
        return AbstractPostingApp.redirect((Call)redirectTo);
    }

    private static String addToHistory(AbstractPosting original, AbstractPosting posting) {
        diff_match_patch dmp = new diff_match_patch();
        dmp.Diff_EditCost = (short)16;
        AbstractPosting abstractPosting = original;
        String string = null;
        String string2 = string = abstractPosting.getBody();
        abstractPosting = posting;
        string = null;
        string = abstractPosting.getBody();
        LinkedList<diff_match_patch.Diff> diffs = dmp.diff_main(string2, string);
        dmp.diff_cleanupEfficiency(diffs);
        abstractPosting = original;
        string = null;
        String string3 = string = abstractPosting.getBody();
        abstractPosting = posting;
        string = null;
        string = abstractPosting.getBody();
        return (AbstractPostingApp.getHistoryMadeBy(posting, diffs) + AbstractPostingApp.getDiffText(string3, string) + "\n").replaceAll("\n", "</br>\n");
    }

    private static String getHistoryMadeBy(AbstractPosting posting, LinkedList<diff_match_patch.Diff> diffs) {
        Object object;
        Object object2;
        int insertions = 0;
        int deletions = 0;
        for (diff_match_patch.Diff diff2 : diffs) {
            object2 = diff2;
            object = null;
            object = ((diff_match_patch.Diff)object2).getOperation();
            switch (object) {
                case DELETE: {
                    ++deletions;
                    break;
                }
                case INSERT: {
                    ++insertions;
                    break;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        object2 = UserApp.currentUser();
        object = null;
        object = ((User)object2).getName();
        StringBuilder stringBuilder = sb.append("<div class='history-made-by'>").append((String)object).append("(");
        object2 = UserApp.currentUser();
        object = null;
        object = ((User)object2).getLoginId();
        stringBuilder.append((String)object).append(") ");
        if (insertions > 0) {
            sb.append("<span class='added'> ").append(" + ").append(insertions).append(" </span>");
        }
        if (deletions > 0) {
            sb.append("<span class='deleted'> ").append(" - ").append(deletions).append(" </span>");
        }
        object2 = posting;
        object = null;
        object = ((AbstractPosting)object2).getUpdatedDate();
        sb.append(" at ").append(JodaDateUtil.getDateString((Date)object, "yyyy-MM-dd h:mm:ss a")).append("</div><hr/>\n");
        return sb.toString();
    }

    private static String getDiffText(String oldValue, String newValue) {
        int EQUAL_TEXT_ELLIPSIS_SIZE = 100;
        diff_match_patch dmp = new diff_match_patch();
        dmp.Diff_EditCost = (short)16;
        StringBuilder sb = new StringBuilder();
        if (oldValue != null) {
            LinkedList<diff_match_patch.Diff> diffs = dmp.diff_main(oldValue, newValue);
            dmp.diff_cleanupEfficiency(diffs);
            Iterator iterator = diffs.iterator();
            while (iterator.hasNext()) {
                diff_match_patch.Diff diff2;
                diff_match_patch.Diff diff3 = diff2 = (diff_match_patch.Diff)iterator.next();
                Object object = null;
                object = diff3.getOperation();
                switch (1.$SwitchMap$utils$diff_match_patch$Operation[((Enum)object).ordinal()]) {
                    case 1: {
                        sb.append("<span class='diff-deleted'>");
                        diff3 = diff2;
                        object = null;
                        object = diff3.getText();
                        sb.append(StringEscapeUtils.escapeHtml4((String)object));
                        sb.append("</span>");
                        break;
                    }
                    case 3: {
                        diff3 = diff2;
                        object = null;
                        object = diff3.getText();
                        int textLength = ((String)object).length();
                        if (textLength > 100) {
                            diff3 = diff2;
                            object = null;
                            object = diff3.getText();
                            if (!((String)object).substring(0, 50).equals(oldValue.substring(0, 50))) {
                                diff3 = diff2;
                                object = null;
                                object = diff3.getText();
                                sb.append(StringEscapeUtils.escapeHtml4((String)((String)object).substring(0, 50)));
                            }
                            sb.append("<span class='diff-ellipsis'>...\n").append("......\n").append("......\n").append("...</span>");
                            diff3 = diff2;
                            object = null;
                            object = diff3.getText();
                            if (((String)object).substring(textLength - 50).equals(oldValue.substring(oldValue.length() - 50))) break;
                            diff3 = diff2;
                            object = null;
                            object = diff3.getText();
                            sb.append(StringEscapeUtils.escapeHtml4((String)((String)object).substring(textLength - 50)));
                            break;
                        }
                        diff3 = diff2;
                        object = null;
                        object = diff3.getText();
                        sb.append(StringEscapeUtils.escapeHtml4((String)object));
                        break;
                    }
                    case 2: {
                        sb.append("<span class='diff-added'>");
                        diff3 = diff2;
                        object = null;
                        object = diff3.getText();
                        sb.append(StringEscapeUtils.escapeHtml4((String)object));
                        sb.append("</span>");
                        break;
                    }
                }
            }
        }
        return sb.toString().replaceAll("\n", "&nbsp<br/>\n");
    }

    public static void attachUploadFilesToPost(Resource resource) {
        int attachedFileCount;
        String[] temporaryUploadFiles = AbstractPostingApp.getTemporaryFileListFromHiddenForm();
        if (AbstractPostingApp.isTemporaryFilesExist(temporaryUploadFiles) && (attachedFileCount = Attachment.moveOnlySelected(UserApp.currentUser().asResource(), resource, temporaryUploadFiles)) != temporaryUploadFiles.length) {
            AbstractPostingApp.flash((String)"title", (String)Messages.get((String)"post.popup.fileAttach.hasMissing", (Object[])new Object[]{temporaryUploadFiles.length - attachedFileCount}));
            AbstractPostingApp.flash((String)"description", (String)Messages.get((String)"post.popup.fileAttach.hasMissing.description", (Object[])new Object[]{AbstractPostingApp.getTemporaryFilesServerKeepUpTimeOfMinuntes()}));
        }
    }

    public static void attachUploadFilesToPost(JsonNode files, Resource resource) {
        if (files != null && files.isArray() && files.size() > 0) {
            String[] fileIds = new String[files.size()];
            int idx = 0;
            for (JsonNode fileNo : files) {
                fileIds[idx] = fileNo.asText();
                ++idx;
            }
            int attachedFileCount = Attachment.moveOnlySelected(UserApp.currentUser().asResource(), resource, fileIds);
            if (attachedFileCount != files.size()) {
                AbstractPostingApp.flash((String)"title", (String)Messages.get((String)"post.popup.fileAttach.hasMissing", (Object[])new Object[]{files.size() - attachedFileCount}));
                AbstractPostingApp.flash((String)"description", (String)Messages.get((String)"post.popup.fileAttach.hasMissing.description", (Object[])new Object[]{AbstractPostingApp.getTemporaryFilesServerKeepUpTimeOfMinuntes()}));
            }
        }
    }

    private static long getTemporaryFilesServerKeepUpTimeOfMinuntes() {
        return AttachmentApp.TEMPORARYFILES_KEEPUP_TIME_MILLIS / 60000L;
    }

    public static String[] getTemporaryFileListFromHiddenForm() {
        Http.MultipartFormData body = AbstractPostingApp.request().body().asMultipartFormData();
        if (body == null) {
            return new String[0];
        }
        String[] temporaryUploadFiles = (String[])body.asFormUrlEncoded().get("temporaryUploadFiles");
        if (temporaryUploadFiles == null) {
            return new String[0];
        }
        String CSV_DELIMITER = ",";
        return temporaryUploadFiles[0].split(",");
    }

    private static boolean isTemporaryFilesExist(String[] files) {
        if (ArrayUtils.getLength((Object)files) == 0) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)files[0]);
    }

    protected static boolean isSelectedToSendNotificationMail() {
        Map data2 = AbstractPostingApp.isMultiPartFormData() ? AbstractPostingApp.request().body().asMultipartFormData().asFormUrlEncoded() : AbstractPostingApp.request().body().asFormUrlEncoded();
        return "yes".equalsIgnoreCase(HttpUtil.getFirstValueFromQuery(data2, "notificationMail"));
    }

    private static boolean isMultiPartFormData() {
        return AbstractPostingApp.request().body().asMultipartFormData() != null;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class SearchCondition {
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String orderBy;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String orderDir;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public String filter;
        @PropertiesEnhancer.GeneratedGetAccessor
        @PropertiesEnhancer.GeneratedSetAccessor
        public int pageNum;

        public SearchCondition() {
            String string = Direction.DESC.direction();
            SearchCondition searchCondition = this;
            searchCondition.setOrderDir(string);
            string = "id";
            searchCondition = this;
            searchCondition.setOrderBy(string);
            string = "";
            searchCondition = this;
            searchCondition.setFilter(string);
            int n = 1;
            searchCondition = this;
            searchCondition.setPageNum(n);
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getOrderBy() {
            return this.orderBy;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setOrderBy(String string) {
            this.orderBy = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getOrderDir() {
            return this.orderDir;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setOrderDir(String string) {
            this.orderDir = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public String getFilter() {
            return this.filter;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setFilter(String string) {
            this.filter = string;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public int getPageNum() {
            return this.pageNum;
        }

        @PropertiesEnhancer.GeneratedAccessor
        public void setPageNum(int n) {
            this.pageNum = n;
        }
    }
}

