/*
 * Decompiled with CFR 0.152.
 */
package actors;

import akka.actor.UntypedActor;
import models.NotificationEvent;
import models.PullRequest;
import models.PullRequestEvent;
import models.PullRequestEventMessage;
import models.PullRequestMergeResult;
import models.enumeration.EventType;
import models.enumeration.State;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class PullRequestActor
extends UntypedActor {
    protected void processPullRequestMerging(PullRequestEventMessage message, PullRequest pullRequest2) {
        try {
            NotificationEvent notiEvent;
            boolean bl;
            PullRequest pullRequest3 = pullRequest2;
            Object object = null;
            object = pullRequest3.getMergedCommitIdTo();
            String oldMergeCommitId = object;
            pullRequest3 = pullRequest2;
            object = null;
            object = pullRequest3.getIsConflict();
            if (object != null) {
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getIsConflict();
                bl = (Boolean)object;
            } else {
                bl = false;
            }
            boolean wasConflict = bl;
            PullRequestMergeResult mergeResult2 = pullRequest2.updateMerge();
            if (mergeResult2.hasDiffCommits()) {
                mergeResult2.saveCommits();
                if (!mergeResult2.getNewCommits().isEmpty()) {
                    if (!message.isNewPullRequest()) {
                        NotificationEvent.afterPullRequestCommitChanged(message.getSender(), pullRequest2);
                    }
                    pullRequest3 = pullRequest2;
                    object = null;
                    object = pullRequest3.getMergedCommitIdTo();
                    PullRequestEvent.addCommitEvents(message.getSender(), pullRequest2, mergeResult2.getNewCommits(), this.getCommitEventOldValue(oldMergeCommitId, (String)object));
                    pullRequest2.clearReviewers();
                }
            } else {
                mergeResult2.setMergedStateOfPullRequest(message.getSender());
                pullRequest3 = pullRequest2;
                object = null;
                object = pullRequest3.getState();
                if (object != State.MERGED) {
                    pullRequest3 = pullRequest2;
                    object = null;
                    object = pullRequest3.getState();
                    notiEvent = NotificationEvent.afterPullRequestUpdated(message.getSender(), pullRequest2, (State)((Object)object), State.MERGED);
                    PullRequestEvent.addFromNotificationEvent(notiEvent, pullRequest2);
                }
            }
            if (!wasConflict && mergeResult2.conflicts()) {
                mergeResult2.setConflictStateOfPullRequest();
                notiEvent = NotificationEvent.afterMerge(message.getSender(), pullRequest2, State.CONFLICT);
                PullRequestEvent.addMergeEvent(notiEvent.getSender(), EventType.PULL_REQUEST_MERGED, State.CONFLICT, pullRequest2);
            }
            if (wasConflict && !mergeResult2.conflicts()) {
                mergeResult2.setResolvedStateOfPullRequest();
                notiEvent = NotificationEvent.afterMerge(message.getSender(), pullRequest2, State.RESOLVED);
                PullRequestEvent.addMergeEvent(notiEvent.getSender(), EventType.PULL_REQUEST_MERGED, State.RESOLVED, pullRequest2);
            }
            mergeResult2.save();
        }
        catch (Exception e) {
            Logger.error((String)("Failed to check merging from " + pullRequest2), (Throwable)e);
        }
    }

    private String getCommitEventOldValue(String oldMergeCommitId, String newMergeCommitId) {
        if (oldMergeCommitId == null) {
            return null;
        }
        return oldMergeCommitId + "," + newMergeCommitId;
    }
}

