/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.support.PathParser;
import controllers.UserApp;
import models.Project;
import models.User;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessLogger;
import utils.ErrorViews;
import utils.RedirectUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class NullProjectCheckAction
extends Action<Void> {
    public F.Promise<Result> call(Http.Context context) throws Throwable {
        String projectName;
        PathParser parser = new PathParser(context);
        String ownerLoginId = parser.getOwnerLoginId();
        Project project2 = Project.findByOwnerAndProjectName(ownerLoginId, projectName = parser.getProjectName());
        if (project2 == null) {
            F.Promise promise;
            Project previousProject = Project.findByPreviousPlaceOf(ownerLoginId, projectName);
            if (previousProject != null) {
                return RedirectUtil.redirect(previousProject);
            }
            if (UserApp.currentUser() == User.anonymous) {
                Controller.flash((String)"failed", (String)Messages.get((String)"error.auth.unauthorized.waringMessage", (Object[])new Object[0]));
                promise = F.Promise.pure((Object)NullProjectCheckAction.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden.or.notfound", context.request().path())));
            } else {
                promise = F.Promise.pure((Object)NullProjectCheckAction.forbidden((Content)ErrorViews.NotFound.render("error.forbidden.or.notfound")));
            }
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        return this.delegate.call(context);
    }
}

