/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.AbstractProjectCheckAction;
import actions.support.PathParser;
import controllers.UserApp;
import controllers.annotation.IsAllowed;
import models.Project;
import models.enumeration.Operation;
import models.enumeration.ResourceType;
import models.resource.Resource;
import models.resource.ResourceConvertible;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.AccessLogger;
import utils.ErrorViews;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class IsAllowedAction
extends AbstractProjectCheckAction<IsAllowed> {
    @Override
    protected F.Promise<Result> call(Project project2, Http.Context context, PathParser parser) throws Throwable {
        ResourceType resourceType = ((IsAllowed)this.configuration).resourceType();
        ResourceConvertible resourceObject = Resource.getResourceObject(parser, project2, resourceType);
        Operation operation = ((IsAllowed)this.configuration).value();
        if (resourceObject == null) {
            F.Promise promise = F.Promise.pure((Object)IsAllowedAction.notFound((Content)ErrorViews.NotFound.render("error.notfound", project2, resourceType.resource())));
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), resourceObject.asResource(), operation)) {
            F.Promise promise = F.Promise.pure((Object)IsAllowedAction.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden", project2)));
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        return this.delegate.call(context);
    }
}

