/*
 * Decompiled with CFR 0.152.
 */
package actions;

import actions.support.PathParser;
import controllers.UserApp;
import models.Project;
import models.User;
import models.enumeration.Operation;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import play.libs.F;
import play.mvc.Action;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;
import utils.AccessControl;
import utils.AccessLogger;
import utils.ErrorViews;
import utils.PathVariable;
import utils.RedirectUtil;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class AbstractProjectCheckAction<T>
extends Action<T> {
    public final F.Promise<Result> call(Http.Context context) throws Throwable {
        String ownerLoginId = null;
        String projectName = null;
        PathParser parser = new PathParser(context);
        PathVariable pathVariable = new PathVariable(Http.Context.current().request().path());
        if (pathVariable.isApiCall()) {
            ownerLoginId = pathVariable.getPathVariable("owners");
            projectName = pathVariable.getPathVariable("projects");
        } else {
            ownerLoginId = parser.getOwnerLoginId();
            projectName = parser.getProjectName();
        }
        Project project2 = Project.findByOwnerAndProjectName(ownerLoginId, projectName);
        if (project2 == null) {
            F.Promise promise;
            Project previousProject = Project.findByPreviousPlaceOf(ownerLoginId, projectName);
            if (previousProject != null) {
                return RedirectUtil.redirect(previousProject);
            }
            if (UserApp.currentUser() == User.anonymous) {
                Controller.flash((String)"failed", (String)Messages.get((String)"error.auth.unauthorized.waringMessage", (Object[])new Object[0]));
                promise = F.Promise.pure((Object)AbstractProjectCheckAction.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden.or.notfound", context.request().path())));
            } else {
                promise = F.Promise.pure((Object)AbstractProjectCheckAction.forbidden((Content)ErrorViews.NotFound.render("error.forbidden.or.notfound")));
            }
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        if (!AccessControl.isAllowed(UserApp.currentUser(), project2.asResource(), Operation.READ)) {
            Controller.flash((String)"failed", (String)Messages.get((String)"error.auth.unauthorized.waringMessage", (Object[])new Object[0]));
            F.Promise promise = F.Promise.pure((Object)AbstractProjectCheckAction.forbidden((Content)ErrorViews.Forbidden.render("error.forbidden.or.notfound", context.request().path())));
            AccessLogger.log(context.request(), (F.Promise<Result>)promise, null);
            return promise;
        }
        return this.call(project2, context, parser);
    }

    protected abstract F.Promise<Result> call(Project var1, Http.Context var2, PathParser var3) throws Throwable;
}

