/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminEvent {
    private String myTxnName;
    private File myTxnDir;
    private long myShard;
    private long myRevision;
    private long myOriginalRevision;
    private long myDroppedRevisionsCount;
    private int myDroppedNodesCount;
    private SVNAdminEventAction myAction;
    private String myPath;
    private String myMessage;
    private SVNLock myLock;
    private SVNErrorMessage myError;

    public SVNAdminEvent(long revision, long originalRevision, SVNAdminEventAction action, String message) {
        this.myRevision = revision;
        this.myOriginalRevision = originalRevision;
        this.myAction = action;
        this.myMessage = message;
    }

    public SVNAdminEvent(SVNAdminEventAction action, String path, String message) {
        this.myAction = action;
        this.myPath = path;
        if (this.myPath != null && this.myPath.startsWith("/")) {
            this.myPath = this.myPath.substring("/".length());
        }
        this.myMessage = message;
    }

    public SVNAdminEvent(SVNAdminEventAction action, long shard) {
        this.myAction = action;
        this.myShard = shard;
    }

    public SVNAdminEvent(long revision, SVNAdminEventAction action, String message) {
        this.myOriginalRevision = -1L;
        this.myRevision = -1L;
        this.myMessage = message;
        if (action == SVNAdminEventAction.REVISION_LOAD) {
            this.myOriginalRevision = revision;
        } else {
            this.myRevision = revision;
        }
        this.myAction = action;
    }

    public SVNAdminEvent(String txnName, File txnDir, SVNAdminEventAction action) {
        this.myTxnName = txnName;
        this.myTxnDir = txnDir;
        this.myRevision = -1L;
        this.myOriginalRevision = -1L;
        this.myAction = action;
    }

    public SVNAdminEvent(SVNAdminEventAction action, SVNLock lock, SVNErrorMessage error, String message) {
        this.myError = error;
        this.myMessage = message;
        this.myAction = action;
        this.myLock = lock;
    }

    public SVNAdminEvent(SVNAdminEventAction action, String message) {
        this.myAction = action;
        this.myMessage = message;
    }

    public SVNAdminEvent(SVNAdminEventAction action) {
        this(action, null);
    }

    public SVNAdminEventAction getAction() {
        return this.myAction;
    }

    public String getMessage() {
        return this.myMessage == null ? "" : this.myMessage;
    }

    public long getOriginalRevision() {
        return this.myOriginalRevision;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public File getTxnDir() {
        return this.myTxnDir;
    }

    public String getTxnName() {
        return this.myTxnName;
    }

    public String getPath() {
        return this.myPath;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public SVNErrorMessage getError() {
        return this.myError;
    }

    public long getDroppedRevisionsCount() {
        return this.myDroppedRevisionsCount;
    }

    public int getDroppedNodesCount() {
        return this.myDroppedNodesCount;
    }

    public void setDroppedRevisionsCount(long droppedRevisionsCount) {
        this.myDroppedRevisionsCount = droppedRevisionsCount;
    }

    public void setDroppedNodesCount(int droppedNodesCount) {
        this.myDroppedNodesCount = droppedNodesCount;
    }

    public long getShard() {
        return this.myShard;
    }
}

