/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.wwwauth.negotiate;

import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.wwwauth.WWWAuthenticateProvider;
import com.feth.play.module.pa.providers.wwwauth.negotiate.SpnegoAuthUser;
import com.feth.play.module.pa.user.AuthUser;
import com.ning.http.util.Base64;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import play.Application;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SpnegoAuthProvider
extends WWWAuthenticateProvider {
    public static final String PROVIDER_KEY = "spnego";
    private static Oid SPNEGO_MECH_OID;

    public SpnegoAuthProvider(Application app) {
        super(app);
        String realm = this.getConfiguration().getString("realm");
        String kdc = this.getConfiguration().getString("kdc");
        if (realm != null && kdc != null) {
            System.setProperty("java.security.krb5.realm", realm);
            System.setProperty("java.security.krb5.kdc", kdc);
        } else if (realm != null || kdc != null) {
            Logger.error((String)"Both realm and kdc must be given, falling back to krb5.conf");
        }
    }

    @Override
    protected String authScheme() {
        return "Negotiate";
    }

    @Override
    protected String challenge(Http.Context context) {
        return null;
    }

    protected AuthUser makeAuthUser(GSSContext gssContext) {
        try {
            return new SpnegoAuthUser(gssContext);
        }
        catch (GSSException e) {
            Logger.warn((String)"Error creating SpnegoAuthUser", (Throwable)e);
            return null;
        }
    }

    @Override
    protected AuthUser authenticateResponse(String response) throws AuthException {
        if (response.startsWith("TlRMTVNTU")) {
            Logger.warn((String)"Discarding deprecated NTLMSSP authentication attempt");
            return null;
        }
        byte[] token = Base64.decode((String)response);
        try {
            GSSManager gssManager = GSSManager.getInstance();
            GSSCredential gssCred = gssManager.createCredential(null, 0, SPNEGO_MECH_OID, 2);
            GSSContext gssContext = gssManager.createContext(gssCred);
            byte[] tokenForPeer = gssContext.acceptSecContext(token, 0, token.length);
            if (!gssContext.isEstablished()) {
                throw new AuthException("Couldn't establish GSS context");
            }
            if (tokenForPeer != null) {
                Logger.warn((String)"Ignoring token for peer");
            }
            Logger.debug((String)("Authenticated " + gssContext.getSrcName() + " with " + gssContext.getTargName()));
            return this.makeAuthUser(gssContext);
        }
        catch (GSSException e) {
            throw new AuthException("SPNEGO authentication failed: " + e);
        }
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    static {
        try {
            SPNEGO_MECH_OID = new Oid("1.3.6.1.5.5.2");
        }
        catch (GSSException e) {
            Logger.error((String)"SPNEGO Oid is undefined");
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class SettingKeys {
        public static final String REALM = "realm";
        public static final String KDC = "kdc";
    }
}

