/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.wwwauth.basic;

import com.feth.play.module.pa.providers.wwwauth.WWWAuthenticateProvider;
import com.feth.play.module.pa.user.AuthUser;
import com.ning.http.util.Base64;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class BasicAuthProvider
extends WWWAuthenticateProvider {
    public BasicAuthProvider(Application app) {
        super(app);
    }

    protected abstract AuthUser authenticateUser(String var1, String var2);

    @Override
    protected List<String> neededSettingKeys() {
        return Collections.singletonList("realm");
    }

    @Override
    protected String authScheme() {
        return "Basic";
    }

    @Override
    protected String challenge(Http.Context context) {
        String realm = this.getConfiguration().getString("realm");
        return String.format("realm=\"%s\"", UTF8UrlEncoder.encode((String)realm));
    }

    @Override
    protected AuthUser authenticateResponse(String response) {
        String decoded;
        try {
            decoded = new String(Base64.decode((String)response), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            decoded = "";
        }
        String[] parts = decoded.split(":", 2);
        if (parts.length == 2) {
            return this.authenticateUser(parts[0], parts[1]);
        }
        return null;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class SettingKeys {
        public static final String REALM = "realm";
    }
}

