/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.wwwauth;

import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.AuthProvider;
import com.feth.play.module.pa.user.AuthUser;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import play.twirl.api.Content;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class WWWAuthenticateProvider
extends AuthProvider {
    public WWWAuthenticateProvider(Application app) {
        super(app);
    }

    protected abstract String authScheme();

    protected abstract String challenge(Http.Context var1);

    protected abstract AuthUser authenticateResponse(String var1) throws AuthException;

    protected Content unauthorized(Http.Context context) {
        return new Content(){

            public String body() {
                return "Go away, you don't exit.";
            }

            public String contentType() {
                return "text/plain";
            }
        };
    }

    private Result deny(Http.Context context) {
        String authChallenge = this.challenge(context);
        authChallenge = authChallenge == null ? this.authScheme() : this.authScheme() + " " + authChallenge;
        context.response().setHeader("WWW-Authenticate", authChallenge);
        return Controller.unauthorized((Content)this.unauthorized(context));
    }

    @Override
    public Object authenticate(Http.Context context, Object payload) throws AuthException {
        String auth = context.request().getHeader("Authorization");
        if (auth == null) {
            return this.deny(context);
        }
        int ix = auth.indexOf(32);
        if (ix == -1 || !this.authScheme().equalsIgnoreCase(auth.substring(0, ix))) {
            return this.deny(context);
        }
        AuthUser user = this.authenticateResponse(auth.substring(ix + 1));
        if (user == null) {
            return this.deny(context);
        }
        return user;
    }

    @Override
    public boolean isExternal() {
        return false;
    }
}

