/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.vk;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth2.BasicOAuth2AuthUser;
import com.feth.play.module.pa.providers.oauth2.vk.VkAuthInfo;
import com.feth.play.module.pa.user.ExtendedIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class VkAuthUser
extends BasicOAuth2AuthUser
implements ExtendedIdentity,
PicturedIdentity {
    private static final long serialVersionUID = 1L;
    private String firstName;
    private String lastName;
    private String nickname;
    private String screenName;
    private String gender;
    private String birthDate;
    private int timezone;
    private String photo50;
    private String photo100;
    private String photo200;

    public VkAuthUser(JsonNode node, VkAuthInfo info, String state) {
        super(node.get("uid").asText(), info, state);
        if (node.has("first_name")) {
            this.firstName = node.get("first_name").asText();
        }
        if (node.has("last_name")) {
            this.lastName = node.get("last_name").asText();
        }
        if (node.has("nickname")) {
            this.nickname = node.get("nickname").asText();
        }
        if (node.has("screen_name")) {
            this.screenName = node.get("screen_name").asText();
        }
        if (node.has("sex")) {
            int genderId = node.get("sex").asInt();
            if (genderId == 1) {
                this.gender = "female";
            } else if (genderId == 2) {
                this.gender = "male";
            }
        }
        if (node.has("bdate")) {
            this.birthDate = node.get("bdate").asText();
        }
        if (node.has("timezone")) {
            this.timezone = node.get("timezone").asInt();
        }
        if (node.has("photo_50")) {
            this.photo50 = node.get("photo_50").asText();
        }
        if (node.has("photo_100")) {
            this.photo100 = node.get("photo_100").asText();
        }
        if (node.has("photo_200_orig")) {
            this.photo200 = node.get("photo_200_orig").asText();
        }
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public String getProvider() {
        return "vk";
    }

    @Override
    public String getName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getPicture() {
        return this.getPhoto200();
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getPhoto100() {
        return this.photo100;
    }

    public String getPhoto200() {
        return this.photo200;
    }

    public String getPhoto50() {
        return this.photo50;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public int getTimezone() {
        return this.timezone;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static abstract class Constants {
        public static final String UID = "uid";
        public static final String FIRST_NAME = "first_name";
        public static final String LAST_NAME = "last_name";
        public static final String NICKNAME = "nickname";
        public static final String SCREEN_NAME = "screen_name";
        public static final String GENDER = "sex";
        public static final String BIRTH_DATE = "bdate";
        public static final String TIMEZONE = "timezone";
        public static final String PHOTO_50 = "photo_50";
        public static final String PHOTO_100 = "photo_100";
        public static final String PHOTO_200 = "photo_200_orig";

        private Constants() {
        }
    }
}

