/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.untappd;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth2.BasicOAuth2AuthUser;
import com.feth.play.module.pa.providers.oauth2.untappd.UntappdAuthInfo;
import com.feth.play.module.pa.user.BasicIdentity;
import com.feth.play.module.pa.user.FirstLastNameIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class UntappdAuthUser
extends BasicOAuth2AuthUser
implements BasicIdentity,
FirstLastNameIdentity,
PicturedIdentity {
    private static final long serialVersionUID = 1L;
    private String displayName;
    private String email;
    private String firstName;
    private String avatar;
    private String lastName;

    public UntappdAuthUser(JsonNode n, UntappdAuthInfo info, String state) {
        super(n.get("id").asText(), info, state);
        JsonNode settingsNode;
        if (n.has("first_name")) {
            this.firstName = n.get("first_name").asText();
        }
        if (n.has("last_name")) {
            this.lastName = n.get("last_name").asText();
        }
        if (n.has("user_name")) {
            this.displayName = n.get("user_name").asText();
        }
        if (n.has("settings") && (settingsNode = n.get("settings")).has("email_address")) {
            this.email = settingsNode.get("email_address").asText();
        }
        if (n.has("user_avatar")) {
            this.avatar = n.get("user_avatar").asText();
        }
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public String getPicture() {
        return this.avatar;
    }

    @Override
    public String getProvider() {
        return "untappd";
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static class Constants {
        public static final String EMAIL = "email_address";
        public static final String DISPLAY_NAME = "user_name";
        public static final String FIRST_NAME = "first_name";
        public static final String ID = "id";
        public static final String LAST_NAME = "last_name";
        public static final String AVATAR_URL = "user_avatar";
        public static final String SETTINGS = "settings";

        private Constants() {
        }
    }
}

