/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.pocket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.exceptions.ResolverMissingException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.pocket.PocketAuthInfo;
import com.feth.play.module.pa.providers.oauth2.pocket.PocketAuthUser;
import com.feth.play.module.pa.user.AuthUserIdentity;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import play.Application;
import play.Configuration;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PocketAuthProvider
extends OAuth2AuthProvider<PocketAuthUser, PocketAuthInfo> {
    public static final String PROVIDER_KEY = "pocket";

    public PocketAuthProvider(Application app) {
        super(app);
    }

    private static JsonNode encodeParamsAsJson(List<NameValuePair> params) {
        HashMap<String, String> map = new HashMap<String, String>(params.size());
        for (NameValuePair nameValuePair : params) {
            map.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return new ObjectMapper().valueToTree(map);
    }

    @Override
    protected List<String> neededSettingKeys() {
        return Arrays.asList("accessTokenUrl", "authorizationUrl", "requestTokenUrl", "consumerKey");
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected PocketAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        if (r.getStatus() >= 400) {
            throw new AccessTokenException(r.asJson().asText());
        }
        List list = URLEncodedUtils.parse((String)r.getBody(), (Charset)Charset.forName("UTF-8"));
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (NameValuePair nameValuePair : list) {
            map.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return new PocketAuthInfo(map);
    }

    @Override
    protected AuthUserIdentity transform(PocketAuthInfo info, String state) throws AuthException {
        return new PocketAuthUser(info, state);
    }

    @Override
    protected String getAccessTokenParams(Configuration c, String code, Http.Request request) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("consumer_key", c.getString("consumerKey")));
        params.add(new BasicNameValuePair("code", code));
        return URLEncodedUtils.format(params, (String)"UTF-8");
    }

    private String getRequestToken(Http.Request request) throws AuthException {
        Configuration c = this.getConfiguration();
        List<NameValuePair> params = this.getRequestTokenParams(request, c);
        WSResponse r = (WSResponse)WS.url((String)c.getString("requestTokenUrl")).setHeader("Content-Type", "application/json").setHeader("X-Accept", "application/json").post(PocketAuthProvider.encodeParamsAsJson(params)).get(this.getTimeout());
        if (r.getStatus() >= 400) {
            throw new AuthException(r.asJson().asText());
        }
        return r.asJson().get("code").asText();
    }

    private List<NameValuePair> getRequestTokenParams(Http.Request request, Configuration c) throws ResolverMissingException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("consumer_key", c.getString("consumerKey")));
        params.add((NameValuePair)new BasicNameValuePair(this.getRedirectUriKey(), this.getRedirectUrl(request)));
        return params;
    }

    @Override
    protected List<NameValuePair> getAuthParams(Configuration c, Http.Request request, String state) throws AuthException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("consumer_key", c.getString("consumerKey")));
        String requestToken = this.getRequestToken(request);
        params.add((NameValuePair)new BasicNameValuePair("request_token", requestToken));
        if (state != null) {
            params.add((NameValuePair)new BasicNameValuePair("state", state));
        }
        String redirectUrl = this.getRedirectUrl(request, Arrays.asList(new BasicNameValuePair("code", requestToken)));
        params.add((NameValuePair)new BasicNameValuePair(this.getRedirectUriKey(), redirectUrl));
        return params;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class PocketConstants
    extends OAuth2AuthProvider.Constants {
        public static final String CONSUMER_KEY = "consumer_key";
        public static final String REQUEST_TOKEN = "request_token";
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class SettingKeys
    extends OAuth2AuthProvider.SettingKeys {
        public static final String REQUEST_TOKEN_URL = "requestTokenUrl";
        public static final String CONSUMER_KEY = "consumerKey";
    }
}

