/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.google;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.google.GoogleAuthInfo;
import com.feth.play.module.pa.providers.oauth2.google.GoogleAuthUser;
import play.Application;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GoogleAuthProvider
extends OAuth2AuthProvider<GoogleAuthUser, GoogleAuthInfo> {
    public static final String PROVIDER_KEY = "google";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";

    public GoogleAuthProvider(Application app) {
        super(app);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    protected GoogleAuthUser transform(GoogleAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter("access_token", info.getAccessToken()).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (result.get("error") != null) {
            throw new AuthException(result.get("error").asText());
        }
        Logger.debug((String)result.toString());
        return new GoogleAuthUser(result, info, state);
    }

    @Override
    protected GoogleAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        JsonNode n = r.asJson();
        Logger.debug((String)n.toString());
        if (n.get("error") != null) {
            throw new AccessTokenException(n.get("error").asText());
        }
        return new GoogleAuthInfo(n);
    }
}

