/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.foursquare;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthInfo;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.foursquare.FoursquareAuthInfo;
import com.feth.play.module.pa.providers.oauth2.foursquare.FoursquareAuthUser;
import com.feth.play.module.pa.user.AuthUserIdentity;
import play.Application;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class FoursquareAuthProvider
extends OAuth2AuthProvider<FoursquareAuthUser, FoursquareAuthInfo> {
    public static final String PROVIDER_KEY = "foursquare";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String OAUTH_TOKEN = "oauth_token";
    private static final String VERSION = "20120617";

    public FoursquareAuthProvider(Application app) {
        super(app);
    }

    @Override
    protected FoursquareAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        if (r.getStatus() >= 400) {
            throw new AccessTokenException(r.toString());
        }
        JsonNode result = r.asJson();
        Logger.debug((String)result.asText());
        return new FoursquareAuthInfo(result.get("access_token").asText());
    }

    @Override
    protected AuthUserIdentity transform(FoursquareAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter(OAUTH_TOKEN, info.getAccessToken()).setQueryParameter("v", VERSION).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (r.getStatus() >= 400) {
            throw new AuthException(result.get("meta").get("errorDetail").asText());
        }
        Logger.debug((String)result.toString());
        return new FoursquareAuthUser(result.get("response").get("user"), (OAuth2AuthInfo)info, state);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }
}

