/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.eventbrite;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth2.BasicOAuth2AuthUser;
import com.feth.play.module.pa.providers.oauth2.eventbrite.EventBriteAuthInfo;
import com.feth.play.module.pa.user.FirstLastNameIdentity;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class EventBriteAuthUser
extends BasicOAuth2AuthUser
implements FirstLastNameIdentity {
    private static final long serialVersionUID = 1L;
    private String name;
    private String firstName;
    private String lastName;
    private String email;
    private boolean verified = false;

    public EventBriteAuthUser(JsonNode node, EventBriteAuthInfo info, String state) {
        super(node.get("id").asText(), info, state);
        if (node.has("first_name")) {
            this.firstName = node.get("first_name").asText();
        }
        if (node.has("last_name")) {
            this.lastName = node.get("last_name").asText();
        }
        if (node.has("name")) {
            this.name = node.get("name").asText();
        }
        if (node.has("emails")) {
            JsonNode eMailsNode = node.get("emails");
            Logger.debug((String)("Emails : " + eMailsNode));
            for (JsonNode jsonNode : eMailsNode) {
                if (jsonNode.get("primary").asBoolean(false)) {
                    this.email = jsonNode.get("email").asText();
                    this.verified = jsonNode.get("verified").asBoolean();
                    Logger.debug((String)("Found primary email: " + this.email));
                    break;
                }
                if (this.email != null) continue;
                this.email = jsonNode.get("email").asText();
                this.verified = jsonNode.get("verified").asBoolean();
                Logger.debug((String)("First email: " + this.email));
            }
        }
    }

    @Override
    public String getProvider() {
        return "eventbrite";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    public boolean isVerified() {
        return this.verified;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static abstract class Constants {
        public static final String ID = "id";
        public static final String NAME = "name";
        public static final String FIRST_NAME = "first_name";
        public static final String LAST_NAME = "last_name";
        public static final String EMAILS_EMAIL = "email";
        public static final String EMAILS = "emails";
        public static final String PRIMARY = "primary";
        public static final String EMAILS_EMAIL_VERIFIED = "verified";

        private Constants() {
        }
    }
}

