/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth2.eventbrite;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth2.OAuth2AuthProvider;
import com.feth.play.module.pa.providers.oauth2.eventbrite.EventBriteAuthInfo;
import com.feth.play.module.pa.providers.oauth2.eventbrite.EventBriteAuthUser;
import play.Application;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class EventBriteAuthProvider
extends OAuth2AuthProvider<EventBriteAuthUser, EventBriteAuthInfo> {
    public static final String PROVIDER_KEY = "eventbrite";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String TOKEN = "token";

    public EventBriteAuthProvider(Application app) {
        super(app);
    }

    protected EventBriteAuthUser transform(EventBriteAuthInfo info, String state) throws AuthException {
        String url = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        WSResponse r = (WSResponse)WS.url((String)url).setQueryParameter(TOKEN, info.getAccessToken()).get().get(this.getTimeout());
        JsonNode result = r.asJson();
        if (r.getStatus() >= 400) {
            throw new AuthException(result.get("meta").get("errorDetail").asText());
        }
        Logger.debug((String)result.toString());
        return new EventBriteAuthUser(result, info, state);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected EventBriteAuthInfo buildInfo(WSResponse r) throws AccessTokenException {
        if (r.getStatus() >= 400) {
            throw new AccessTokenException(r.toString());
        }
        JsonNode result = r.asJson();
        Logger.debug((String)result.asText());
        return new EventBriteAuthInfo(result.get("access_token").asText());
    }
}

