/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth1.xing;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.exceptions.AccessDeniedException;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.oauth1.OAuth1AuthProvider;
import com.feth.play.module.pa.providers.oauth1.xing.XingAuthInfo;
import com.feth.play.module.pa.providers.oauth1.xing.XingAuthUser;
import java.util.List;
import play.Application;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.oauth.OAuth;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class XingAuthProvider
extends OAuth1AuthProvider<XingAuthUser, XingAuthInfo> {
    public static final String PROVIDER_KEY = "xing";
    private static final String NODE_USERS = "users";
    private static final String USER_INFO_URL_SETTING_KEY = "userInfoUrl";
    private static final String XING_ERROR = "xing_error";
    private static final String ACCESS_DENIED = "user_abort";

    public XingAuthProvider(Application app) {
        super(app);
    }

    @Override
    protected XingAuthInfo buildInfo(OAuth.RequestToken rtoken) throws AccessTokenException {
        return new XingAuthInfo(rtoken.token, rtoken.secret);
    }

    @Override
    public String getKey() {
        return PROVIDER_KEY;
    }

    @Override
    protected List<String> neededSettingKeys() {
        List<String> neededSettingKeys = super.neededSettingKeys();
        neededSettingKeys.add(USER_INFO_URL_SETTING_KEY);
        return neededSettingKeys;
    }

    @Override
    protected XingAuthUser transform(XingAuthInfo info) throws AuthException {
        String userInfoUrl = this.getConfiguration().getString(USER_INFO_URL_SETTING_KEY);
        OAuth.OAuthCalculator op = this.getOAuthCalculator(info);
        JsonNode userJson = this.signedOauthGet(userInfoUrl, op);
        return new XingAuthUser(userJson.path(NODE_USERS).get(0), info);
    }

    @Override
    protected void checkError(Http.Request request) throws AuthException {
        String error = request.getQueryString(XING_ERROR);
        if (error != null) {
            if (error.equals(ACCESS_DENIED)) {
                throw new AccessDeniedException(this.getKey());
            }
            throw new AuthException(error);
        }
    }
}

