/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth1.twitter;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth1.BasicOAuth1AuthUser;
import com.feth.play.module.pa.providers.oauth1.OAuth1AuthInfo;
import com.feth.play.module.pa.user.AuthUser;
import com.feth.play.module.pa.user.LocaleIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import java.util.Locale;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class TwitterAuthUser
extends BasicOAuth1AuthUser
implements PicturedIdentity,
LocaleIdentity {
    private static final long serialVersionUID = 1L;
    private String name;
    private String screenName;
    private boolean verified = false;
    private String locale;
    private String picture;

    public TwitterAuthUser(JsonNode node, OAuth1AuthInfo info) {
        super(node.get("id").asText(), info, null);
        if (node.has("name")) {
            this.name = node.get("name").asText();
        }
        if (node.has("lang")) {
            this.locale = node.get("lang").asText();
        }
        if (node.has("screen_name")) {
            this.screenName = node.get("screen_name").asText();
        }
        if (node.has("verified")) {
            this.verified = node.get("verified").asBoolean(false);
        }
        if (node.has("profile_image_url")) {
            this.picture = node.get("profile_image_url").asText();
        }
    }

    @Override
    public String getProvider() {
        return "twitter";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public Locale getLocale() {
        return AuthUser.getLocaleFromString(this.locale);
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static abstract class Constants {
        public static final String ID = "id";
        public static final String PROFILE_IMAGE_URL = "profile_image_url";
        public static final String NAME = "name";
        public static final String SCREEN_NAME = "screen_name";
        public static final String VERIFIED = "verified";
        public static final String LOCALE = "lang";

        private Constants() {
        }
    }
}

