/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth1.linkedin;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.providers.oauth1.BasicOAuth1AuthUser;
import com.feth.play.module.pa.providers.oauth1.OAuth1AuthInfo;
import com.feth.play.module.pa.user.BasicIdentity;
import com.feth.play.module.pa.user.EducationsIdentity;
import com.feth.play.module.pa.user.EmploymentsIdentity;
import com.feth.play.module.pa.user.FirstLastNameIdentity;
import com.feth.play.module.pa.user.PicturedIdentity;
import com.feth.play.module.pa.user.ProfiledIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class LinkedinAuthUser
extends BasicOAuth1AuthUser
implements BasicIdentity,
FirstLastNameIdentity,
PicturedIdentity,
EmploymentsIdentity,
EducationsIdentity,
ProfiledIdentity {
    private static final long serialVersionUID = 1L;
    private String picture;
    private String firstName;
    private String lastName;
    private String industry;
    private String email;
    private List<EmploymentsIdentity.EmploymentInfo> employments;
    private List<EducationsIdentity.EducationInfo> educations;
    private String publicProfileUrl;

    public LinkedinAuthUser(JsonNode nodeInfo, String email, OAuth1AuthInfo info) {
        super(nodeInfo.get("id").asText(), info, null);
        JsonNode node;
        if (nodeInfo.has("firstName")) {
            this.firstName = nodeInfo.get("firstName").asText();
        }
        if (nodeInfo.has("lastName")) {
            this.lastName = nodeInfo.get("lastName").asText();
        }
        if (nodeInfo.has("pictureUrl")) {
            this.picture = nodeInfo.get("pictureUrl").asText();
        }
        if (nodeInfo.has("industry")) {
            this.industry = nodeInfo.get("industry").asText();
        }
        if ((node = LinkedinAuthUser.traverse(nodeInfo, "positions/values")) != null) {
            this.employments = new ArrayList<EmploymentsIdentity.EmploymentInfo>();
            for (JsonNode j : node) {
                this.employments.add(LinkedinAuthUser.makeEmployment(j));
            }
        }
        if ((node = LinkedinAuthUser.traverse(nodeInfo, "educations/values")) != null) {
            this.educations = new ArrayList<EducationsIdentity.EducationInfo>();
            for (JsonNode j : node) {
                this.educations.add(LinkedinAuthUser.makeEducation(j));
            }
        }
        if (!StringUtils.isBlank((CharSequence)email)) {
            this.email = email;
        }
        if (nodeInfo.has("publicProfileUrl")) {
            this.publicProfileUrl = nodeInfo.get("publicProfileUrl").asText();
        }
    }

    private static EducationsIdentity.EducationInfo makeEducation(JsonNode node) {
        JsonNode childNode;
        String id = null;
        String schoolName = null;
        String degree = null;
        int startDateYear = 0;
        int endDateYear = 0;
        if (node.has("id")) {
            id = node.get("id").asText();
        }
        if (node.has("schoolName")) {
            schoolName = node.get("schoolName").asText();
        }
        if (node.has("degree")) {
            degree = node.get("degree").asText();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "startDate/year")) != null) {
            startDateYear = childNode.asInt();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "endDate/year")) != null) {
            endDateYear = childNode.asInt();
        }
        return new EducationsIdentity.EducationInfo(id, schoolName, degree, startDateYear, endDateYear);
    }

    private static EmploymentsIdentity.EmploymentInfo makeEmployment(JsonNode node) {
        JsonNode childNode;
        String id = null;
        String title = null;
        String summary = null;
        String companyName = null;
        int startDateMonth = 0;
        int startDateYear = 0;
        int endDateMonth = 0;
        int endDateYear = 0;
        boolean isCurrent = false;
        if (node.has("id")) {
            id = node.get("id").asText();
        }
        if (node.has("title")) {
            title = node.get("title").asText();
        }
        if (node.has("summary")) {
            summary = node.get("summary").asText();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "startDate/month")) != null) {
            startDateMonth = childNode.asInt();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "startDate/year")) != null) {
            startDateYear = childNode.asInt();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "endDate/month")) != null) {
            endDateMonth = childNode.asInt();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "endDate/year")) != null) {
            endDateYear = childNode.asInt();
        }
        if (node.has("isCurrent")) {
            isCurrent = node.get("isCurrent").asBoolean();
        }
        if ((childNode = LinkedinAuthUser.traverse(node, "company/name")) != null) {
            companyName = childNode.asText();
        }
        return new EmploymentsIdentity.EmploymentInfo(id, title, summary, startDateMonth, startDateYear, endDateMonth, endDateYear, isCurrent, companyName);
    }

    private static JsonNode traverse(JsonNode topNode, String childExpression) {
        String[] segments;
        JsonNode jsonNode = topNode;
        for (String segment : segments = childExpression.split("/")) {
            if (jsonNode == null) {
                return null;
            }
            jsonNode = jsonNode.get(segment);
        }
        return jsonNode;
    }

    @Override
    public String getProvider() {
        return "linkedin";
    }

    @Override
    public String getName() {
        return this.firstName + " " + this.lastName;
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    public String getIndustry() {
        return this.industry;
    }

    @Override
    public Collection<EmploymentsIdentity.EmploymentInfo> getEmployments() {
        return this.employments;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Collection<EducationsIdentity.EducationInfo> getEducations() {
        return this.educations;
    }

    @Override
    public String getProfileLink() {
        return this.publicProfileUrl;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private static abstract class Constants {
        public static final String ID = "id";
        public static final String PROFILE_IMAGE_URL = "pictureUrl";
        public static final String FIRST_NAME = "firstName";
        public static final String LAST_NAME = "lastName";
        public static final String INDUSTRY = "industry";
        public static final String POSITIONS = "positions/values";
        public static final String EDUCATIONS = "educations/values";
        public static final String PUBLIC_PROFILE_URL = "publicProfileUrl";

        private Constants() {
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        private static abstract class Employment {
            public static final String ID = "id";
            public static final String TITLE = "title";
            public static final String SUMMARY = "summary";
            public static final String START_DATE_MONTH = "startDate/month";
            public static final String START_DATE_YEAR = "startDate/year";
            public static final String END_DATE_MONTH = "endDate/month";
            public static final String END_DATE_YEAR = "endDate/year";
            public static final String IS_CURRENT = "isCurrent";
            public static final String COMPANY_NAME = "company/name";

            private Employment() {
            }
        }

        @PropertiesEnhancer.GeneratedAccessor
        @PropertiesEnhancer.RewrittenAccessor
        private static abstract class Education {
            public static final String ID = "id";
            public static final String SCHOOL_NAME = "schoolName";
            public static final String DEGREE = "degree";
            public static final String START_DATE_YEAR = "startDate/year";
            public static final String END_DATE_YEAR = "endDate/year";

            private Education() {
            }
        }
    }
}

