/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa.providers.oauth1;

import com.fasterxml.jackson.databind.JsonNode;
import com.feth.play.module.pa.PlayAuthenticate;
import com.feth.play.module.pa.exceptions.AccessDeniedException;
import com.feth.play.module.pa.exceptions.AccessTokenException;
import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.ext.ExternalAuthProvider;
import com.feth.play.module.pa.providers.oauth1.OAuth1AuthInfo;
import com.feth.play.module.pa.user.AuthUserIdentity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import play.Application;
import play.Configuration;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.F;
import play.libs.oauth.OAuth;
import play.libs.ws.WS;
import play.libs.ws.WSResponse;
import play.libs.ws.WSSignatureCalculator;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class OAuth1AuthProvider<U extends AuthUserIdentity, I extends OAuth1AuthInfo>
extends ExternalAuthProvider {
    private static final String CACHE_TOKEN = "pa.oauth1.rtoken";

    public OAuth1AuthProvider(Application app) {
        super(app);
    }

    protected abstract I buildInfo(OAuth.RequestToken var1) throws AccessTokenException;

    @Override
    protected List<String> neededSettingKeys() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(super.neededSettingKeys());
        ret.add("accessTokenUrl");
        ret.add("authorizationUrl");
        ret.add("requestTokenUrl");
        ret.add("consumerKey");
        ret.add("consumerSecret");
        return ret;
    }

    protected void checkError(Http.Request request) throws AuthException {
        String error = request.getQueryString("oauth_problem");
        if (error != null) {
            if (error.equals("access_denied")) {
                throw new AccessDeniedException(this.getKey());
            }
            throw new AuthException(error);
        }
    }

    @Override
    public Object authenticate(Http.Context context, Object payload) throws AuthException {
        Http.Request request = context.request();
        String uri = request.uri();
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)("Returned with URL: '" + uri + "'"));
        }
        Configuration c = this.getConfiguration();
        OAuth.ConsumerKey key = new OAuth.ConsumerKey(c.getString("consumerKey"), c.getString("consumerSecret"));
        String requestTokenURL = c.getString("requestTokenUrl");
        String accessTokenURL = c.getString("accessTokenUrl");
        String authorizationURL = c.getString("authorizationUrl");
        OAuth.ServiceInfo info = new OAuth.ServiceInfo(requestTokenURL, accessTokenURL, authorizationURL, key);
        OAuth service = new OAuth(info, true);
        this.checkError(request);
        if (uri.contains("oauth_verifier")) {
            OAuth.RequestToken rtoken = (OAuth.RequestToken)PlayAuthenticate.removeFromCache(context.session(), CACHE_TOKEN);
            String verifier = request.getQueryString("oauth_verifier");
            try {
                OAuth.RequestToken response = service.retrieveAccessToken(rtoken, verifier);
                I i = this.buildInfo(response);
                return this.transform(i);
            }
            catch (RuntimeException ex) {
                throw new AuthException(ex.getLocalizedMessage());
            }
        }
        String callbackURL = this.getRedirectUrl(request);
        try {
            OAuth.RequestToken response = service.retrieveRequestToken(callbackURL);
            String token = response.token;
            String redirectUrl = service.redirectUrl(token);
            PlayAuthenticate.storeInCache(context.session(), CACHE_TOKEN, new SerializableRequestToken(response));
            return redirectUrl;
        }
        catch (RuntimeException ex) {
            throw new AuthException(ex.getLocalizedMessage());
        }
    }

    protected JsonNode signedOauthGet(String url, OAuth.OAuthCalculator calculator) {
        F.Promise promise = WS.url((String)url).sign((WSSignatureCalculator)calculator).get();
        WSResponse response = (WSResponse)promise.get(this.getTimeout());
        return response.asJson();
    }

    protected OAuth.OAuthCalculator getOAuthCalculator(OAuth1AuthInfo info) {
        OAuth.RequestToken token = new OAuth.RequestToken(info.getAccessToken(), info.getAccessTokenSecret());
        Configuration c = this.getConfiguration();
        OAuth.ConsumerKey cK = new OAuth.ConsumerKey(c.getString("consumerKey"), c.getString("consumerSecret"));
        return new OAuth.OAuthCalculator(cK, token);
    }

    protected abstract U transform(I var1) throws AuthException;

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static class SerializableRequestToken
    extends OAuth.RequestToken
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SerializableRequestToken(OAuth.RequestToken source) {
            super(source.token, source.secret);
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class Constants {
        public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
        public static final String OAUTH_TOKEN = "oauth_token";
        public static final String OAUTH_VERIFIER = "oauth_verifier";
        public static final String OAUTH_PROBLEM = "oauth_problem";
        public static final String OAUTH_ACCESS_DENIED = "access_denied";
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class SettingKeys {
        public static final String REQUEST_TOKEN_URL = "requestTokenUrl";
        public static final String AUTHORIZATION_URL = "authorizationUrl";
        public static final String ACCESS_TOKEN_URL = "accessTokenUrl";
        public static final String CONSUMER_KEY = "consumerKey";
        public static final String CONSUMER_SECRET = "consumerSecret";
    }
}

