/*
 * Decompiled with CFR 0.152.
 */
package com.feth.play.module.pa;

import com.feth.play.module.pa.exceptions.AuthException;
import com.feth.play.module.pa.providers.AuthProvider;
import com.feth.play.module.pa.service.UserService;
import com.feth.play.module.pa.user.AuthUser;
import java.util.Date;
import java.util.UUID;
import play.Configuration;
import play.Logger;
import play.Play;
import play.cache.Cache;
import play.core.enhancers.PropertiesEnhancer;
import play.i18n.Messages;
import play.mvc.Call;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public abstract class PlayAuthenticate {
    public static final String SETTING_KEY_PLAY_AUTHENTICATE = "play-authenticate";
    private static final String SETTING_KEY_AFTER_AUTH_FALLBACK = "afterAuthFallback";
    private static final String SETTING_KEY_AFTER_LOGOUT_FALLBACK = "afterLogoutFallback";
    private static final String SETTING_KEY_ACCOUNT_MERGE_ENABLED = "accountMergeEnabled";
    private static final String SETTING_KEY_ACCOUNT_AUTO_LINK = "accountAutoLink";
    private static final String SETTING_KEY_ACCOUNT_AUTO_MERGE = "accountAutoMerge";
    private static Resolver resolver;
    private static UserService userService;
    private static final String ORIGINAL_URL = "pa.url.orig";
    private static final String USER_KEY = "pa.u.id";
    private static final String PROVIDER_KEY = "pa.p.id";
    private static final String EXPIRES_KEY = "pa.u.exp";
    private static final String SESSION_ID_KEY = "pa.s.id";
    public static final long TIMEOUT = 10000L;
    private static final String MERGE_USER_KEY;
    private static final String LINK_USER_KEY;

    public static void setResolver(Resolver res) {
        resolver = res;
    }

    public static Resolver getResolver() {
        return resolver;
    }

    public static void setUserService(UserService service) {
        userService = service;
    }

    public static UserService getUserService() {
        if (userService == null) {
            throw new RuntimeException(Messages.get((String)"playauthenticate.core.exception.no_user_service", (Object[])new Object[0]));
        }
        return userService;
    }

    public static Configuration getConfiguration() {
        return Play.application().configuration().getConfig(SETTING_KEY_PLAY_AUTHENTICATE);
    }

    public static String getOriginalUrl(Http.Context context) {
        return context.session().remove((Object)ORIGINAL_URL);
    }

    public static String storeOriginalUrl(Http.Context context) {
        String loginUrl = null;
        if (PlayAuthenticate.getResolver().login() != null) {
            loginUrl = PlayAuthenticate.getResolver().login().url();
        } else {
            Logger.warn((String)"You should define a login call in the resolver");
        }
        if (context.request().method().equals("GET") && !context.request().path().equals(loginUrl)) {
            Logger.debug((String)("Path where we are coming from (" + context.request().uri() + ") is different than the login URL (" + loginUrl + ")"));
            context.session().put(ORIGINAL_URL, context.request().uri());
        } else {
            Logger.debug((String)"The path we are coming from is the Login URL - delete jumpback");
            context.session().remove((Object)ORIGINAL_URL);
        }
        return (String)context.session().get((Object)ORIGINAL_URL);
    }

    public static void storeUser(Http.Session session, AuthUser authUser) {
        AuthUser u = PlayAuthenticate.getUserService().update(authUser);
        session.put(USER_KEY, u.getId());
        session.put(PROVIDER_KEY, u.getProvider());
        if (u.expires() != -1L) {
            session.put(EXPIRES_KEY, Long.toString(u.expires()));
        } else {
            session.remove((Object)EXPIRES_KEY);
        }
    }

    public static boolean isLoggedIn(Http.Session session) {
        long expires;
        boolean ret = session.containsKey((Object)USER_KEY) && session.containsKey((Object)PROVIDER_KEY);
        ret &= AuthProvider.Registry.hasProvider((String)session.get((Object)PROVIDER_KEY));
        if (session.containsKey((Object)EXPIRES_KEY) && (expires = PlayAuthenticate.getExpiration(session)) != -1L) {
            ret &= new Date().getTime() < expires;
        }
        return ret;
    }

    public static Result logout(Http.Session session) {
        session.remove((Object)USER_KEY);
        session.remove((Object)PROVIDER_KEY);
        session.remove((Object)EXPIRES_KEY);
        session.remove((Object)ORIGINAL_URL);
        return Controller.redirect((String)PlayAuthenticate.getUrl(PlayAuthenticate.getResolver().afterLogout(), SETTING_KEY_AFTER_LOGOUT_FALLBACK));
    }

    public static String peekOriginalUrl(Http.Context context) {
        return (String)context.session().get((Object)ORIGINAL_URL);
    }

    public static boolean hasUserService() {
        return userService != null;
    }

    private static long getExpiration(Http.Session session) {
        long expires;
        if (session.containsKey((Object)EXPIRES_KEY)) {
            try {
                expires = Long.parseLong((String)session.get((Object)EXPIRES_KEY));
            }
            catch (NumberFormatException nfe) {
                expires = -1L;
            }
        } else {
            expires = -1L;
        }
        return expires;
    }

    public static AuthUser getUser(Http.Session session) {
        String provider = (String)session.get((Object)PROVIDER_KEY);
        String id = (String)session.get((Object)USER_KEY);
        long expires = PlayAuthenticate.getExpiration(session);
        if (provider != null && id != null) {
            return PlayAuthenticate.getProvider(provider).getSessionAuthUser(id, expires);
        }
        return null;
    }

    public static AuthUser getUser(Http.Context context) {
        return PlayAuthenticate.getUser(context.session());
    }

    public static boolean isAccountAutoMerge() {
        return PlayAuthenticate.getConfiguration().getBoolean(SETTING_KEY_ACCOUNT_AUTO_MERGE);
    }

    public static boolean isAccountAutoLink() {
        return PlayAuthenticate.getConfiguration().getBoolean(SETTING_KEY_ACCOUNT_AUTO_LINK);
    }

    public static boolean isAccountMergeEnabled() {
        return PlayAuthenticate.getConfiguration().getBoolean(SETTING_KEY_ACCOUNT_MERGE_ENABLED);
    }

    private static String getPlayAuthSessionId(Http.Session session) {
        String uuid = (String)session.get((Object)SESSION_ID_KEY);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            session.put(SESSION_ID_KEY, uuid);
        }
        return uuid;
    }

    private static void storeUserInCache(Http.Session session, String key, AuthUser identity) {
        PlayAuthenticate.storeInCache(session, key, identity);
    }

    public static void storeInCache(Http.Session session, String key, Object o) {
        Cache.set((String)PlayAuthenticate.getCacheKey(session, key), (Object)o);
    }

    public static <T> T removeFromCache(Http.Session session, String key) {
        T o = PlayAuthenticate.getFromCache(session, key);
        String k = PlayAuthenticate.getCacheKey(session, key);
        Cache.remove((String)k);
        return o;
    }

    private static String getCacheKey(Http.Session session, String key) {
        String id = PlayAuthenticate.getPlayAuthSessionId(session);
        return id + "_" + key;
    }

    public static <T> T getFromCache(Http.Session session, String key) {
        return (T)Cache.get((String)PlayAuthenticate.getCacheKey(session, key));
    }

    private static AuthUser getUserFromCache(Http.Session session, String key) {
        Object o = PlayAuthenticate.getFromCache(session, key);
        if (o != null && o instanceof AuthUser) {
            return (AuthUser)o;
        }
        return null;
    }

    public static void storeMergeUser(AuthUser identity, Http.Session session) {
        PlayAuthenticate.storeUserInCache(session, MERGE_USER_KEY, identity);
    }

    public static AuthUser getMergeUser(Http.Session session) {
        return PlayAuthenticate.getUserFromCache(session, MERGE_USER_KEY);
    }

    public static void removeMergeUser(Http.Session session) {
        PlayAuthenticate.removeFromCache(session, MERGE_USER_KEY);
    }

    public static void storeLinkUser(AuthUser identity, Http.Session session) {
        PlayAuthenticate.storeUserInCache(session, LINK_USER_KEY, identity);
    }

    public static AuthUser getLinkUser(Http.Session session) {
        return PlayAuthenticate.getUserFromCache(session, LINK_USER_KEY);
    }

    public static void removeLinkUser(Http.Session session) {
        PlayAuthenticate.removeFromCache(session, LINK_USER_KEY);
    }

    private static String getJumpUrl(Http.Context ctx) {
        String originalUrl = PlayAuthenticate.getOriginalUrl(ctx);
        if (originalUrl != null) {
            return originalUrl;
        }
        return PlayAuthenticate.getUrl(PlayAuthenticate.getResolver().afterAuth(), SETTING_KEY_AFTER_AUTH_FALLBACK);
    }

    private static String getUrl(Call c, String settingFallback) {
        if (c != null) {
            return c.url();
        }
        Logger.warn((String)"Resolver did not contain information about where to go - redirecting to /");
        String afterAuthFallback = PlayAuthenticate.getConfiguration().getString(settingFallback);
        if (afterAuthFallback != null && !afterAuthFallback.equals("")) {
            return afterAuthFallback;
        }
        Logger.error((String)("Config setting '" + settingFallback + "' was not present!"));
        return "/";
    }

    public static Result link(Http.Context context, boolean link) {
        AuthUser loginUser;
        AuthUser linkUser = PlayAuthenticate.getLinkUser(context.session());
        if (linkUser == null) {
            return Controller.forbidden();
        }
        if (link) {
            loginUser = PlayAuthenticate.getUserService().link(PlayAuthenticate.getUser(context.session()), linkUser);
        } else {
            try {
                loginUser = PlayAuthenticate.signupUser(linkUser, context.session(), PlayAuthenticate.getProvider(linkUser.getProvider()));
            }
            catch (AuthException e) {
                return Controller.internalServerError((String)e.getMessage());
            }
        }
        PlayAuthenticate.removeLinkUser(context.session());
        return PlayAuthenticate.loginAndRedirect(context, loginUser);
    }

    public static Result loginAndRedirect(Http.Context context, AuthUser loginUser) {
        PlayAuthenticate.storeUser(context.session(), loginUser);
        return Controller.redirect((String)PlayAuthenticate.getJumpUrl(context));
    }

    public static Result merge(Http.Context context, boolean merge) {
        AuthUser mergeUser = PlayAuthenticate.getMergeUser(context.session());
        if (mergeUser == null) {
            return Controller.forbidden();
        }
        AuthUser loginUser = merge ? PlayAuthenticate.getUserService().merge(mergeUser, PlayAuthenticate.getUser(context.session())) : mergeUser;
        PlayAuthenticate.removeMergeUser(context.session());
        return PlayAuthenticate.loginAndRedirect(context, loginUser);
    }

    private static AuthUser signupUser(AuthUser u, Http.Session session, AuthProvider provider) throws AuthException {
        Object id = PlayAuthenticate.getUserService().save(u);
        if (id == null) {
            throw new AuthException(Messages.get((String)"playauthenticate.core.exception.signupuser_failed", (Object[])new Object[0]));
        }
        provider.afterSave(u, id, session);
        return u;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result handleAuthentication(String provider, Http.Context context, Object payload) {
        AuthProvider ap = PlayAuthenticate.getProvider(provider);
        if (ap == null) {
            return Controller.notFound((String)Messages.get((String)"playauthenticate.core.exception.provider_not_found", (Object[])new Object[]{provider}));
        }
        try {
            AuthUser loginUser;
            Object loginIdentity;
            boolean isLinked;
            Object o = ap.authenticate(context, payload);
            if (o instanceof String) {
                return Controller.redirect((String)((String)o));
            }
            if (o instanceof Result) {
                return (Result)o;
            }
            if (!(o instanceof AuthUser)) return Controller.internalServerError((String)Messages.get((String)"playauthenticate.core.exception.general", (Object[])new Object[0]));
            AuthUser newUser = (AuthUser)o;
            Http.Session session = context.session();
            AuthUser oldUser = PlayAuthenticate.getUser(session);
            boolean isLoggedIn = PlayAuthenticate.isLoggedIn(session);
            Object oldIdentity = null;
            if (isLoggedIn) {
                oldIdentity = PlayAuthenticate.getUserService().getLocalIdentity(oldUser);
                boolean bl = isLoggedIn = oldIdentity != null;
                if (!isLoggedIn) {
                    PlayAuthenticate.logout(session);
                    oldUser = null;
                }
            }
            boolean bl = isLinked = (loginIdentity = PlayAuthenticate.getUserService().getLocalIdentity(newUser)) != null;
            if (isLinked && !isLoggedIn) {
                loginUser = newUser;
                return PlayAuthenticate.loginAndRedirect(context, loginUser);
            }
            if (isLinked) {
                if (PlayAuthenticate.isAccountMergeEnabled() && !loginIdentity.equals(oldIdentity)) {
                    if (PlayAuthenticate.isAccountAutoMerge()) {
                        loginUser = PlayAuthenticate.getUserService().merge(newUser, oldUser);
                        return PlayAuthenticate.loginAndRedirect(context, loginUser);
                    }
                    Call c = PlayAuthenticate.getResolver().askMerge();
                    if (c == null) {
                        throw new RuntimeException(Messages.get((String)"playauthenticate.core.exception.merge.controller_undefined", (Object[])new Object[]{SETTING_KEY_ACCOUNT_AUTO_MERGE}));
                    }
                    PlayAuthenticate.storeMergeUser(newUser, session);
                    return Controller.redirect((Call)c);
                }
                loginUser = newUser;
                return PlayAuthenticate.loginAndRedirect(context, loginUser);
            }
            if (!isLoggedIn) {
                loginUser = PlayAuthenticate.signupUser(newUser, session, ap);
                return PlayAuthenticate.loginAndRedirect(context, loginUser);
            }
            if (PlayAuthenticate.isAccountAutoLink()) {
                loginUser = PlayAuthenticate.getUserService().link(oldUser, newUser);
                return PlayAuthenticate.loginAndRedirect(context, loginUser);
            }
            Call c = PlayAuthenticate.getResolver().askLink();
            if (c == null) {
                throw new RuntimeException(Messages.get((String)"playauthenticate.core.exception.link.controller_undefined", (Object[])new Object[]{SETTING_KEY_ACCOUNT_AUTO_LINK}));
            }
            PlayAuthenticate.storeLinkUser(newUser, session);
            return Controller.redirect((Call)c);
        }
        catch (AuthException e) {
            Call c = PlayAuthenticate.getResolver().onException(e);
            if (c != null) {
                return Controller.redirect((Call)c);
            }
            String message = e.getMessage();
            if (message == null) return Controller.internalServerError();
            return Controller.internalServerError((String)message);
        }
    }

    public static AuthProvider getProvider(String providerKey) {
        return AuthProvider.Registry.get(providerKey);
    }

    static {
        MERGE_USER_KEY = null;
        LINK_USER_KEY = null;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    public static abstract class Resolver {
        public abstract Call login();

        public abstract Call afterAuth();

        public abstract Call auth(String var1);

        public abstract Call askMerge();

        public abstract Call askLink();

        public abstract Call afterLogout();

        public Call onException(AuthException e) {
            return null;
        }
    }
}

