/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.repcache;

import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;

public class FSRepresentationCacheRecord {
    public static int HASH_FIELD = 0;
    public static int REVISION_FIELD = 1;
    public static int OFFSET_FIELD = 2;
    public static int SIZE_FIELD = 3;
    public static int EXPANDED_SIZE_FIELD = 4;
    private String myHash = "";
    private long myRevision = 0L;
    private long myOffset = 0L;
    private long mySize = 0L;
    private long myExpandedSize = 0L;

    public FSRepresentationCacheRecord(String hash, long revision, long offset, long size, long expandedSize) {
        this.myHash = hash;
        this.myRevision = revision;
        this.myOffset = offset;
        this.mySize = size;
        this.myExpandedSize = expandedSize;
    }

    FSRepresentationCacheRecord(ISqlJetCursor cursor) throws SqlJetException {
        int fieldsCount = cursor.getFieldsCount();
        if (fieldsCount == 0) {
            return;
        }
        if (!cursor.isNull(HASH_FIELD)) {
            this.myHash = cursor.getString(HASH_FIELD);
        }
        if (fieldsCount == 1) {
            return;
        }
        if (!cursor.isNull(REVISION_FIELD)) {
            this.myRevision = cursor.getInteger(REVISION_FIELD);
        }
        if (fieldsCount == 2) {
            return;
        }
        if (!cursor.isNull(OFFSET_FIELD)) {
            this.myOffset = cursor.getInteger(OFFSET_FIELD);
        }
        if (fieldsCount == 3) {
            return;
        }
        if (!cursor.isNull(SIZE_FIELD)) {
            this.mySize = cursor.getInteger(SIZE_FIELD);
        }
        if (fieldsCount == 4) {
            return;
        }
        if (!cursor.isNull(EXPANDED_SIZE_FIELD)) {
            this.myExpandedSize = cursor.getInteger(EXPANDED_SIZE_FIELD);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("rep_cache( ");
        b.append("hash: ").append(this.myHash);
        b.append(", revision: ").append(this.myRevision);
        b.append(", offset: ").append(this.myOffset);
        b.append(", size: ").append(this.mySize);
        b.append(", expanded_size: ").append(this.myExpandedSize);
        b.append(" )");
        return b.toString();
    }

    public String getHash() {
        return this.myHash;
    }

    public void setHash(String hash) {
        this.myHash = hash;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public void setRevision(long revision) {
        this.myRevision = revision;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public void setOffset(long offset) {
        this.myOffset = offset;
    }

    public long getSize() {
        return this.mySize;
    }

    public void setSize(long size) {
        this.mySize = size;
    }

    public long getExpandedSize() {
        return this.myExpandedSize;
    }

    public void setExpandedSize(long expandedSize) {
        this.myExpandedSize = expandedSize;
    }
}

