/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVUpdateRequest
extends DAVRequest {
    private static final DAVElement TARGET_REVISION = DAVElement.getElement((String)"svn:", (String)"target-revision");
    private static final DAVElement SRC_PATH = DAVElement.getElement((String)"svn:", (String)"src-path");
    private static final DAVElement DST_PATH = DAVElement.getElement((String)"svn:", (String)"dst-path");
    private static final DAVElement UPDATE_TARGET = DAVElement.getElement((String)"svn:", (String)"update-target");
    private static final DAVElement DEPTH = DAVElement.getElement((String)"svn:", (String)"depth");
    private static final DAVElement RECURSIVE = DAVElement.getElement((String)"svn:", (String)"recursive");
    private static final DAVElement SEND_COPYFROM_ARGS = DAVElement.getElement((String)"svn:", (String)"send-copyfrom-args");
    private static final DAVElement IGNORE_ANCESTRY = DAVElement.getElement((String)"svn:", (String)"ignore-ancestry");
    private static final DAVElement TEXT_DELTAS = DAVElement.getElement((String)"svn:", (String)"text-deltas");
    private static final DAVElement RESOURCE_WALK = DAVElement.getElement((String)"svn:", (String)"resource-walk");
    private boolean mySendAll = false;
    private long myRevision = -1L;
    private String mySrcPath = null;
    private SVNURL mySrcURL = null;
    private SVNURL myDstURL = null;
    private String myTarget = "";
    private boolean myTextDeltas = true;
    private SVNDepth myDepth = SVNDepth.UNKNOWN;
    private boolean mySendCopyFromArgs = false;
    private boolean myDepthRequested = false;
    private boolean myRecursiveRequested = false;
    private boolean myIgnoreAncestry = false;
    private boolean myResourceWalk = false;
    private boolean myIsInitialized;

    public boolean isSendAll() {
        return this.mySendAll;
    }

    private void setSendAll(boolean sendAll) {
        this.mySendAll = sendAll;
    }

    public long getRevision() {
        return this.myRevision;
    }

    private void setRevision(long revision) {
        this.myRevision = revision;
    }

    public String getSrcPath() {
        return this.mySrcPath;
    }

    public void setSrcPath(String srcPath) {
        this.mySrcPath = srcPath;
    }

    public SVNURL getSrcURL() {
        return this.mySrcURL;
    }

    private void setSrcURL(SVNURL srcURL) {
        this.mySrcURL = srcURL;
    }

    public SVNURL getDstURL() {
        return this.myDstURL;
    }

    private void setDstURL(SVNURL dstURL) {
        this.myDstURL = dstURL;
    }

    public String getTarget() {
        return this.myTarget;
    }

    private void setTarget(String target) {
        this.myTarget = target;
    }

    public boolean isTextDeltas() {
        return this.myTextDeltas;
    }

    private void setTextDeltas(boolean textDeltas) {
        this.myTextDeltas = textDeltas;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    private void setDepth(SVNDepth depth) {
        this.myDepth = depth;
    }

    public boolean isSendCopyFromArgs() {
        return this.mySendCopyFromArgs;
    }

    private void setSendCopyFromArgs(boolean sendCopyFromArgs) {
        this.mySendCopyFromArgs = sendCopyFromArgs;
    }

    public boolean isDepthRequested() {
        return this.myDepthRequested;
    }

    private void setDepthRequested(boolean depthRequested) {
        this.myDepthRequested = depthRequested;
    }

    public boolean isRecursiveRequested() {
        return this.myRecursiveRequested;
    }

    private void setRecursiveRequested(boolean recursiveRequested) {
        this.myRecursiveRequested = recursiveRequested;
    }

    public boolean isIgnoreAncestry() {
        return this.myIgnoreAncestry;
    }

    private void setIgnoreAncestry(boolean ignoreAncestry) {
        this.myIgnoreAncestry = ignoreAncestry;
    }

    public boolean isResourceWalk() {
        return this.myResourceWalk;
    }

    private void setResourceWalk(boolean resourceWalk) {
        this.myResourceWalk = resourceWalk;
    }

    private boolean isInitialized() {
        return this.myIsInitialized;
    }

    private void setInitialized(boolean isInitialized) {
        this.myIsInitialized = isInitialized;
    }

    @Override
    protected void init() throws SVNException {
        if (!this.isInitialized()) {
            String sendAll = this.getRootElementAttributeValue("send-all");
            this.setSendAll(sendAll != null && Boolean.valueOf(sendAll) != false);
            DAVElementProperty rootElement = this.getRootElement();
            for (DAVElementProperty property : rootElement.getChildren()) {
                String value;
                DAVElement element = property.getName();
                if (element == TARGET_REVISION) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(true);
                    try {
                        this.setRevision(Long.parseLong(value));
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                    }
                    continue;
                }
                if (element == SRC_PATH) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(false);
                    DAVPathUtil.testCanonical(value);
                    if (SVNPathUtil.isURL((String)value)) {
                        this.setSrcURL(SVNURL.parseURIEncoded((String)value));
                        continue;
                    }
                    this.setSrcPath(value);
                    continue;
                }
                if (element == DST_PATH) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(false);
                    DAVPathUtil.testCanonical(value);
                    this.setDstURL(SVNURL.parseURIEncoded((String)value));
                    continue;
                }
                if (element == UPDATE_TARGET) {
                    value = property.getFirstValue(false);
                    DAVPathUtil.testCanonical(value);
                    this.setTarget(value);
                    continue;
                }
                if (element == DEPTH) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(true);
                    this.setDepth(SVNDepth.fromString((String)value));
                    this.setDepthRequested(true);
                    continue;
                }
                if (element == SEND_COPYFROM_ARGS) {
                    this.assertNullCData(element, property);
                    this.setSendCopyFromArgs("no".equals(property.getFirstValue(true)));
                    continue;
                }
                if (element == RECURSIVE && !this.isDepthRequested()) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(true);
                    this.setDepth(SVNDepth.fromRecurse((!"no".equals(value) ? 1 : 0) != 0));
                    this.setRecursiveRequested(true);
                    continue;
                }
                if (element == IGNORE_ANCESTRY) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(true);
                    this.setIgnoreAncestry(!"no".equals(value));
                    continue;
                }
                if (element == TEXT_DELTAS) {
                    this.assertNullCData(element, property);
                    value = property.getFirstValue(true);
                    this.setTextDeltas(!"no".equals(value));
                    continue;
                }
                if (element != RESOURCE_WALK) continue;
                this.assertNullCData(element, property);
                value = property.getFirstValue(true);
                this.setResourceWalk(!"no".equals(value));
            }
            if (!this.isDepthRequested() && !this.isRecursiveRequested() && this.getDepth() == SVNDepth.UNKNOWN) {
                this.setDepth(SVNDepth.INFINITY);
            }
            if (this.getSrcURL() == null && this.getSrcPath() == null) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"The request did not contain the '<src-path>' element.\nThis may indicate that your client is too old."), (SVNLogType)SVNLogType.NETWORK);
            }
            if (!this.isSendAll()) {
                this.setTextDeltas(false);
            }
            this.setInitialized(true);
        }
    }
}

