/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceState;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;

public class DAVUnlockHandler
extends ServletDAVHandler {
    protected DAVUnlockHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    @Override
    public void execute() throws SVNException {
        DAVResource resource;
        String lockToken = this.getRequestHeader("Lock-Token");
        if (lockToken == null) {
            this.sendError(400, "Unlock failed: No Lock-Token specified in header");
            return;
        }
        if (lockToken.indexOf(60) == -1) {
            this.sendError(400, "Unlock failed: Malformed Lock-Token header");
            return;
        }
        if ((lockToken = lockToken.substring(1)).charAt(lockToken.length() - 1) != '>') {
            this.sendError(400, "Unlock failed: Malformed Lock-Token header");
            return;
        }
        lockToken = lockToken.substring(0, lockToken.length() - 1);
        DAVResourceState resourceState = this.getResourceState(resource = this.getRequestedDAVResource(false, false));
        this.validateRequest(resource, DAVDepth.DEPTH_ZERO, resourceState == DAVResourceState.LOCK_NULL ? 32 : 16, null, lockToken, null);
        this.unlock(resource, lockToken);
        this.setResponseStatus(204);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return null;
    }
}

