/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockScope;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.IDAVResourceWalkHandler;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class DAVResourceWalker {
    public static final int DAV_WALKTYPE_AUTH = 1;
    public static final int DAV_WALKTYPE_NORMAL = 2;
    public static final int DAV_WALKTYPE_LOCKNULL = 4;
    private LinkedList myIfHeaders;
    private DAVResource myResource;
    private DAVLockInfoProvider myLockInfoProvider;
    private DAVLockScope myLockScope;
    private int myFlags;
    private int myWalkType;
    private FSRoot myRoot;

    public DAVResponse walk(DAVLockInfoProvider lockInfoProvider, DAVResource resource, LinkedList ifHeaders, int flags, DAVLockScope lockScope, int walkType, IDAVResourceWalkHandler handler, DAVDepth depth) throws DAVException {
        this.myIfHeaders = ifHeaders;
        this.myLockInfoProvider = lockInfoProvider;
        this.myResource = resource.dup();
        this.myFlags = flags;
        this.myWalkType = walkType;
        this.myRoot = resource.getRoot();
        this.myLockScope = lockScope;
        return this.doWalk(handler, null, depth);
    }

    private DAVResponse doWalk(IDAVResourceWalkHandler handler, DAVResponse response, DAVDepth depth) throws DAVException {
        boolean isDir = this.myResource.isCollection();
        response = handler.handleResource(response, this.myResource, this.myLockInfoProvider, this.myIfHeaders, this.myFlags, this.myLockScope, isDir ? IDAVResourceWalkHandler.CallType.COLLECTION : IDAVResourceWalkHandler.CallType.MEMBER);
        if (depth == DAVDepth.DEPTH_ZERO || !isDir) {
            return response;
        }
        if (this.myResource.isWorking()) {
            return response;
        }
        if (this.myResource.getType() != DAVResourceType.REGULAR) {
            throw new DAVException("Walking the resource hierarchy can only be done on 'regular' resources [at this time].", 405, 0);
        }
        this.myResource.setExists(true);
        this.myResource.setCollection(false);
        FSRevisionNode node = null;
        Map children = null;
        try {
            node = this.myRoot.getRevisionNode(this.myResource.getResourceURI().getPath());
            children = node.getDirEntries(this.myRoot.getOwner());
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "could not fetch collection members", null);
        }
        for (String childName : children.keySet()) {
            FSEntry childEntry = (FSEntry)children.get(childName);
            if ((this.myWalkType & 1) != 0) {
                // empty if block
            }
            String uriPath = this.myResource.getResourceURI().getURI();
            String reposPath = this.myResource.getResourceURI().getPath();
            this.myResource.getResourceURI().setURI(SVNPathUtil.append((String)uriPath, (String)childName));
            this.myResource.getResourceURI().setPath(SVNPathUtil.append((String)reposPath, (String)childName));
            if (childEntry.getType() == SVNNodeKind.FILE) {
                response = handler.handleResource(response, this.myResource, this.myLockInfoProvider, this.myIfHeaders, this.myFlags, this.myLockScope, IDAVResourceWalkHandler.CallType.MEMBER);
            } else {
                this.myResource.setCollection(true);
                try {
                    response = this.doWalk(handler, response, DAVDepth.decreaseDepth(depth));
                }
                catch (SVNException svne) {
                    throw DAVException.convertError(svne.getErrorMessage(), 500, "could not decrease depth", null);
                }
                this.myResource.setCollection(false);
            }
            this.myResource.getResourceURI().setURI(uriPath);
            this.myResource.getResourceURI().setPath(reposPath);
        }
        return response;
    }
}

