/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVReplayRequest
extends DAVRequest {
    private static final DAVElement EDITOR_REPORT = DAVElement.getElement((String)"svn:", (String)"editor-report");
    private static final DAVElement LOW_WATER_MARK = DAVElement.getElement((String)"svn:", (String)"low-water-mark");
    private static final DAVElement SEND_DELTAS = DAVElement.getElement((String)"svn:", (String)"send-deltas");
    boolean myIsSendDeltas = true;
    long myLowRevision = -1L;
    long myRevision = -1L;

    public boolean isSendDeltas() {
        return this.myIsSendDeltas;
    }

    private void setSendDeltas(boolean isSendDelta) {
        this.myIsSendDeltas = isSendDelta;
    }

    public long getLowRevision() {
        return this.myLowRevision;
    }

    private void setLowRevision(long lowRevision) {
        this.myLowRevision = lowRevision;
    }

    public long getRevision() {
        return this.myRevision;
    }

    private void setRevision(long revision) {
        this.myRevision = revision;
    }

    @Override
    protected void init() throws SVNException {
        DAVElementProperty rootElement = this.getRootElement();
        rootElement.setElementName(EDITOR_REPORT);
        List children = rootElement.getChildren();
        for (DAVElementProperty property : children) {
            DAVElement element = property.getName();
            if (element == DAVElement.REVISION) {
                this.assertNullCData(element, property);
                try {
                    this.setRevision(Long.parseLong(property.getFirstValue(true)));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (element == LOW_WATER_MARK) {
                this.assertNullCData(element, property);
                try {
                    this.setLowRevision(Long.parseLong(property.getFirstValue(true)));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (element != SEND_DELTAS) continue;
            this.assertNullCData(element, property);
            int sendDeltas = Integer.parseInt(property.getFirstValue(true));
            this.setSendDeltas(sendDeltas != 0);
        }
        if (!SVNRevision.isValidRevisionNumber((long)this.getRevision())) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Request was missing the revision argument."), (SVNLogType)SVNLogType.NETWORK);
        }
        if (!SVNRevision.isValidRevisionNumber((long)this.getLowRevision())) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Request was missing the low-water-mark argument."), (SVNLogType)SVNLogType.NETWORK);
        }
    }
}

