/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReplayRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;

public class DAVReplayHandler
extends DAVReportHandler
implements ISVNEditor {
    private DAVReplayRequest myDAVRequest;
    private DAVReportHandler myCommonReportHandler;

    public DAVReplayHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getReplayRequest();
    }

    private DAVReplayRequest getReplayRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVReplayRequest();
        }
        return this.myDAVRequest;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace("The request does not contain the 'svn:' namespace, so it is not going to have an svn:revision element. That element is required.");
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        this.writeXMLHeader(null);
        this.getRequestedRepository().replay(this.getReplayRequest().getLowRevision(), this.getReplayRequest().getRevision(), this.getReplayRequest().isSendDeltas(), (ISVNEditor)this);
        this.writeXMLFooter(null);
    }

    private SVNRepository getRequestedRepository() throws SVNException {
        if (this.getDAVResource().getResourceURI().getPath() == null || this.getDAVResource().getResourceURI().getPath().length() == 0) {
            return this.getDAVResource().getRepository();
        }
        SVNURL resourceURL = this.getDAVResource().getRepository().getLocation();
        SVNURL resultURL = resourceURL.appendPath(this.getDAVResource().getResourceURI().getPath(), true);
        return SVNRepositoryFactory.create((SVNURL)resultURL);
    }

    public void targetRevision(long revision) throws SVNException {
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"target-revision", (int)4, (String)"rev", (String)String.valueOf(revision), null);
        this.write(xmlBuffer);
    }

    public void openRoot(long revision) throws SVNException {
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"open-root", (int)4, (String)"rev", (String)String.valueOf(revision), null);
        this.write(xmlBuffer);
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        SVNHashMap attrs = new SVNHashMap();
        attrs.put("name", path);
        attrs.put("rev", String.valueOf(revision));
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"delete-entry", (int)4, (Map)attrs, null);
        this.write(xmlBuffer);
    }

    public void absentDir(String path) throws SVNException {
    }

    public void absentFile(String path) throws SVNException {
    }

    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.addEntry("add-directory", path, copyFromPath, copyFromRevision);
    }

    public void openDir(String path, long revision) throws SVNException {
        this.openEntry("open-directory", path, revision);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        this.changeEntryProperty("change-directory-prop", name, value);
    }

    public void closeDir() throws SVNException {
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"close-directory", (int)4, null, null);
        this.write(xmlBuffer);
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.addEntry("add-file", path, copyFromPath, copyFromRevision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.openEntry("open-file", path, revision);
    }

    public void changeFileProperty(String path, String name, SVNPropertyValue value) throws SVNException {
        this.changeEntryProperty("change-file-prop", name, value);
    }

    public void closeFile(String path, String textChecksum) throws SVNException {
        SVNHashMap attrs = new SVNHashMap();
        if (textChecksum != null) {
            attrs.put("checksum", textChecksum);
        }
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"close-file", (int)4, (Map)attrs, null);
        this.write(xmlBuffer);
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void applyTextDelta(String path, String baseChecksum) throws SVNException {
        SVNHashMap attrs = new SVNHashMap();
        if (baseChecksum != null) {
            attrs.put("checksum", baseChecksum);
        }
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)"apply-textdelta", (int)2, (Map)attrs, null);
        this.write(xmlBuffer);
    }

    public OutputStream textDeltaChunk(String path, SVNDiffWindow diffWindow) throws SVNException {
        this.writeTextDeltaChunk(diffWindow);
        return null;
    }

    public void textDeltaEnd(String path) throws SVNException {
        this.textDeltaChunkEnd();
        this.setWriteTextDeltaHeader(true);
        StringBuffer xmlBuffer = SVNXMLUtil.closeXMLTag((String)"S", (String)"apply-textdelta", null);
        this.write(xmlBuffer);
    }

    public void abortEdit() throws SVNException {
    }

    private void addEntry(String tagName, String path, String copyfromPath, long copyfromRevision) throws SVNException {
        SVNHashMap attrs = new SVNHashMap();
        attrs.put("name", path);
        if (copyfromPath != null) {
            attrs.put("copyfrom-path", copyfromPath);
            attrs.put("copyfrom-rev", String.valueOf(copyfromRevision));
        }
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)4, (Map)attrs, null);
        this.write(xmlBuffer);
    }

    private void openEntry(String tagName, String path, long revision) throws SVNException {
        SVNHashMap attrs = new SVNHashMap();
        attrs.put("name", path);
        attrs.put("rev", String.valueOf(revision));
        StringBuffer xmlBuffer = SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)4, (Map)attrs, null);
        this.write(xmlBuffer);
    }

    private void changeEntryProperty(String tagName, String name, SVNPropertyValue propertyValue) throws SVNException {
        StringBuffer xmlBuffer = new StringBuffer();
        if (propertyValue != null) {
            String value = SVNBase64.byteArrayToBase64((byte[])SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propertyValue));
            SVNXMLUtil.openXMLTag((String)"S", (String)tagName, (int)2, (String)"name", (String)name, (StringBuffer)xmlBuffer);
            xmlBuffer.append(value);
            SVNXMLUtil.closeXMLTag((String)"S", (String)tagName, (StringBuffer)xmlBuffer);
        } else {
            SVNHashMap attrs = new SVNHashMap();
            attrs.put("name", name);
            attrs.put("del", Boolean.TRUE.toString());
            SVNXMLUtil.openCDataTag((String)"S", (String)tagName, (String)"", (Map)attrs, (StringBuffer)xmlBuffer);
        }
        this.write(xmlBuffer);
    }
}

