/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceState;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;

public class DAVPutHandler
extends ServletDAVHandler {
    public DAVPutHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws SVNException {
        DAVResource resource = this.getRequestedDAVResource(false, false);
        if (resource.getType() != DAVResourceType.REGULAR && resource.getType() != DAVResourceType.WORKING) {
            String body = "Cannot create resource " + SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI()) + " with PUT.";
            this.response(body, DAVServlet.getStatusLine(409), 409);
            return;
        }
        if (resource.isCollection()) {
            this.response("Cannot PUT to a collection.", DAVServlet.getStatusLine(409), 409);
            return;
        }
        DAVResourceState resourceState = this.getResourceState(resource);
        this.validateRequest(resource, DAVDepth.DEPTH_ZERO, resourceState == DAVResourceState.NULL ? 32 : 16, null, null, null);
        ServletDAVHandler.DAVAutoVersionInfo avInfo = this.autoCheckOut(resource, false);
        int mode = 0;
        long[] range = this.parseRange();
        if (range != null) {
            mode = 1;
        }
        SVNDeltaReader deltaReader = null;
        DAVException error = null;
        try {
            deltaReader = this.openStream(resource, mode);
        }
        catch (DAVException dave) {
            error = new DAVException("Unable to PUT new contents for {0}.", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, 403, dave, 0);
        }
        if (error == null && range != null) {
            error = new DAVException("Resource body read/write cannot use ranges (at this time)", 501, 0);
        }
        DAVException error2 = null;
        if (error == null) {
            String path = resource.getResourceURI().getPath();
            FSRoot root = resource.getRoot();
            FSFS fsfs = resource.getFSFS();
            FSTransactionInfo txn = resource.getTxnInfo();
            Collection lockTokens = resource.getLockTokens();
            String userName = resource.getUserName();
            FSCommitter committer = this.getCommitter(fsfs, root, txn, lockTokens, userName);
            FSDeltaConsumer deltaConsumer = this.getDeltaConsumer(root, committer, fsfs, userName, lockTokens);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            InputStream inputStream = null;
            try {
                inputStream = this.getRequestInputStream();
                byte[] buffer = new byte[2048];
                int readCount = -1;
                while ((readCount = inputStream.read(buffer)) != -1) {
                    if (readCount == 0) continue;
                    if (deltaReader != null) {
                        deltaReader.nextWindow(buffer, 0, readCount, path, (ISVNDeltaConsumer)deltaConsumer);
                        continue;
                    }
                    deltaGenerator.sendDelta(path, buffer, readCount, (ISVNDeltaConsumer)deltaConsumer);
                }
            }
            catch (IOException ioe) {
                error = new DAVException("An error occurred while reading the request body.", 400, 0);
            }
            catch (SVNException svne) {
                error = DAVException.convertError(svne.getErrorMessage(), 500, "could not write the file contents", null);
            }
            finally {
                SVNFileUtil.closeFile((InputStream)inputStream);
                if (deltaReader != null) {
                    try {
                        deltaReader.reset(path, (ISVNDeltaConsumer)deltaConsumer);
                    }
                    catch (SVNException svne) {
                        error2 = DAVException.convertError(svne.getErrorMessage(), 500, "error finalizing applying windows", null);
                    }
                    if (error2 != null && error == null) {
                        error = error2;
                    }
                    deltaConsumer.textDeltaEnd(path);
                }
            }
        }
        if (error == null) {
            resource.setExists(true);
        }
        try {
            this.autoCheckIn(resource, error != null, false, avInfo);
        }
        catch (DAVException dave) {
            error2 = dave;
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            error2 = new DAVException("The PUT was successful, but there was a problem automatically checking in the resource or its parent collection.", null, error2.getResponseCode(), error2, 0);
        }
        DAVLockInfoProvider lockProvider = null;
        try {
            lockProvider = DAVLockInfoProvider.createLockInfoProvider(this, false);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "The file was PUT successfully, but there was a problem opening the lock database which prevents inheriting locks from the parent resources.", null);
        }
        this.notifyCreated(resource, lockProvider, resourceState, DAVDepth.DEPTH_ZERO);
        this.handleDAVCreated(null, "Resource", resourceState == DAVResourceState.EXISTS);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return null;
    }
}

