/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;

public class DAVPropfindRequest
extends DAVRequest {
    private static final DAVElement PROPFIND = DAVElement.getElement((String)"DAV:", (String)"propfind");
    private static final DAVElement PROPNAME = DAVElement.getElement((String)"DAV:", (String)"propname");
    private static final DAVElement ALLPROP = DAVElement.getElement((String)"DAV:", (String)"allprop");

    @Override
    protected void init() throws SVNException {
        if (this.getRoot().getName() != PROPFIND) {
            this.invalidXML();
        }
    }

    public boolean isAllPropRequest() throws SVNException {
        return this.getRoot().hasChild(ALLPROP);
    }

    public boolean isPropNameRequest() throws SVNException {
        return this.getRoot().hasChild(PROPNAME);
    }

    public boolean isPropRequest() throws SVNException {
        return this.getRoot().hasChild(DAVElement.PROP);
    }

    public Collection getPropertyElements() throws SVNException {
        DAVElementProperty propElement = this.getRoot().getChild(DAVElement.PROP);
        LinkedList<DAVElement> props = new LinkedList<DAVElement>();
        List children = propElement.getChildren();
        if (children != null) {
            for (DAVElementProperty child : children) {
                props.add(child.getName());
            }
        }
        return props;
    }

    private DAVElementProperty getRoot() throws SVNException {
        if (this.getRootElement() == null) {
            this.invalidXML();
        }
        return this.getRootElement();
    }
}

