/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVConfig;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockScope;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceKind;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceState;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropertiesProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropfindRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropsResult;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResourceWalker;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.IDAVResourceWalkHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.LivePropertySpecification;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVPropfindHandler
extends ServletDAVHandler
implements IDAVResourceWalkHandler {
    public static final List NAMESPACES = new LinkedList();
    private static final String DEFAULT_AUTOVERSION_LINE = "DAV:checkout-checkin";
    private DAVPropfindRequest myDAVRequest;
    private boolean myIsAllProp;
    private boolean myIsProp;
    private DAVElementProperty myDocRoot;
    private StringBuffer myPropStat404;
    private StringBuffer myResponseBuffer;
    private DAVLockInfoProvider myLocksProvider;

    public DAVPropfindHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getPropfindRequest();
    }

    @Override
    public void execute() throws SVNException {
        DAVConfig config;
        DAVResource resource = this.getRequestedDAVResource(true, false);
        DAVResourceState resourceState = this.getResourceState(resource);
        if (resourceState == DAVResourceState.NULL) {
            this.sendError(404, null);
            return;
        }
        DAVDepth depth = this.getRequestDepth(DAVDepth.DEPTH_INFINITY);
        if (depth == DAVDepth.DEPTH_INFINITY && resource.isCollection() && !(config = this.getConfig()).isAllowDepthInfinity()) {
            String message = "PROPFIND requests with a Depth of \"infinity\" are not allowed for " + SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI()) + ".";
            this.response(message, DAVServlet.getStatusLine(403), 403);
            return;
        }
        long readCount = this.readInput(false);
        DAVPropfindRequest request = this.getPropfindRequest();
        DAVElementProperty rootElement = request.getRootElement();
        if (readCount > 0L && rootElement.getName() != DAVElement.PROPFIND) {
            this.sendError(400, null);
            return;
        }
        this.myIsAllProp = false;
        this.myIsProp = false;
        if (readCount == 0L || rootElement.hasChild(DAVElement.ALLPROP)) {
            this.myIsAllProp = true;
        } else if (!rootElement.hasChild(DAVElement.PROPNAME)) {
            if (rootElement.hasChild(DAVElement.PROP)) {
                this.myIsProp = true;
            } else {
                this.setResponseStatus(400);
                return;
            }
        }
        this.myLocksProvider = null;
        try {
            this.myLocksProvider = DAVLockInfoProvider.createLockInfoProvider(this, false);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "The lock database could not be opened, preventing access to the various lock properties for the PROPFIND.", null);
        }
        this.myResponseBuffer = new StringBuffer();
        DAVXMLUtil.beginMultiStatus(this.getHttpServletResponse(), 207, this.getNamespaces(), this.myResponseBuffer);
        int walkType = 7;
        DAVResourceWalker walker = new DAVResourceWalker();
        DAVException error = null;
        try {
            walker.walk(this.myLocksProvider, resource, null, 0, null, walkType, this, depth);
        }
        catch (DAVException dave) {
            error = dave;
        }
        if (error != null) {
            throw new DAVException("Provider encountered an error while streaming", error.getResponseCode(), error, 0);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.MULTISTATUS.getName(), (StringBuffer)this.myResponseBuffer);
        String responseBody = this.myResponseBuffer.toString();
        try {
            this.setResponseContentLength(responseBody.getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException e) {
            this.setResponseContentLength(responseBody.getBytes().length);
        }
        this.setResponseStatus(207);
        try {
            this.getResponseWriter().write(responseBody);
        }
        catch (IOException e) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)e), (Throwable)e, (SVNLogType)SVNLogType.NETWORK);
        }
    }

    @Override
    public DAVResponse handleResource(DAVResponse response, DAVResource resource, DAVLockInfoProvider lockInfoProvider, LinkedList ifHeaders, int flags, DAVLockScope lockScope, IDAVResourceWalkHandler.CallType callType) throws DAVException {
        DAVPropertiesProvider propsProvider = null;
        try {
            propsProvider = DAVPropertiesProvider.createPropertiesProvider(resource, this);
        }
        catch (DAVException dave) {
            if (this.myIsProp) {
                this.cacheBadProps();
                DAVPropsResult badProps = new DAVPropsResult();
                badProps.addPropStatsText(this.myPropStat404.toString());
                this.streamResponse(resource, 0, badProps);
            } else {
                this.streamResponse(resource, 200, null);
            }
            return null;
        }
        DAVPropsResult result = null;
        if (this.myIsProp) {
            result = this.getProps(propsProvider, this.getPropfindRequest().getRootElement());
        } else {
            DAVInsertPropAction action = this.myIsAllProp ? DAVInsertPropAction.INSERT_VALUE : DAVInsertPropAction.INSERT_NAME;
            result = this.getAllProps(propsProvider, action);
        }
        this.streamResponse(resource, 0, result);
        return null;
    }

    private DAVPropsResult getAllProps(DAVPropertiesProvider propsProvider, DAVInsertPropAction action) throws DAVException {
        boolean foundContentType = false;
        boolean foundContentLang = false;
        DAVPropsResult result = new DAVPropsResult();
        StringBuffer buffer = new StringBuffer();
        if (action != DAVInsertPropAction.INSERT_SUPPORTED) {
            if (propsProvider.isDeferred()) {
                propsProvider.open(true);
            }
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)1, null, (StringBuffer)buffer);
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)1, null, (StringBuffer)buffer);
            HashMap namespacesToPrefixes = new HashMap();
            propsProvider.defineNamespaces(namespacesToPrefixes);
            Collection propNames = propsProvider.getPropertyNames();
            int ind = 0;
            for (DAVElement propNameElement : propNames) {
                if ("DAV:".equals(propNameElement.getNamespace())) {
                    if (DAVElement.GET_CONTENT_TYPE.getName().equals(propNameElement.getName())) {
                        foundContentType = true;
                    } else if (DAVElement.GET_CONTENT_LANGUAGE.getName().equals(propNameElement.getName())) {
                        foundContentLang = true;
                    }
                }
                if (action == DAVInsertPropAction.INSERT_VALUE) {
                    try {
                        propsProvider.outputValue(propNameElement, buffer);
                    }
                    catch (DAVException dave) {}
                    continue;
                }
                ind = this.outputPropName(propNameElement, namespacesToPrefixes, ind, buffer);
            }
            this.generateXMLNSNamespaces(result, namespacesToPrefixes);
        }
        this.addAllLivePropNamespaces(result);
        this.insertAllLiveProps(propsProvider.getResource(), action, buffer);
        LivePropertySpecification suppLockSpec = (LivePropertySpecification)OUR_CORE_LIVE_PROPS.get(DAVElement.SUPPORTED_LOCK);
        this.insertCoreLiveProperty(propsProvider.getResource(), action, suppLockSpec, buffer);
        LivePropertySpecification lockDiscoverySpec = (LivePropertySpecification)OUR_CORE_LIVE_PROPS.get(DAVElement.LOCK_DISCOVERY);
        this.insertCoreLiveProperty(propsProvider.getResource(), action, lockDiscoverySpec, buffer);
        if (!foundContentType) {
            LivePropertySpecification getContentTypeSpec = (LivePropertySpecification)OUR_CORE_LIVE_PROPS.get(DAVElement.GET_CONTENT_TYPE);
            this.insertCoreLiveProperty(propsProvider.getResource(), action, getContentTypeSpec, buffer);
        }
        if (!foundContentLang) {
            LivePropertySpecification getContentLanguageSpec = (LivePropertySpecification)OUR_CORE_LIVE_PROPS.get(DAVElement.GET_CONTENT_LANGUAGE);
            this.insertCoreLiveProperty(propsProvider.getResource(), action, getContentLanguageSpec, buffer);
        }
        if (action != DAVInsertPropAction.INSERT_SUPPORTED) {
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)buffer);
            SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.STATUS.getName(), (String)"HTTP/1.1 200 OK", null, (boolean)false, (boolean)false, (StringBuffer)buffer);
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)buffer);
        }
        result.addPropStatsText(buffer.toString());
        return result;
    }

    private void insertAllLiveProps(DAVResource resource, DAVInsertPropAction propAction, StringBuffer buffer) throws DAVException {
        if (!resource.exists()) {
            return;
        }
        for (DAVElement propElement : OUR_LIVE_PROPS.keySet()) {
            if (propElement == DAVElement.COMMENT || propElement == DAVElement.DISPLAY_NAME || propElement == DAVElement.SOURCE) continue;
            LivePropertySpecification lps = (LivePropertySpecification)OUR_LIVE_PROPS.get(propElement);
            this.insertLiveProp(resource, lps, propAction, buffer);
        }
    }

    private DAVPropsResult getProps(DAVPropertiesProvider propsProvider, DAVElementProperty docRootElement) throws DAVException {
        StringBuffer buffer = new StringBuffer();
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)1, null, (StringBuffer)buffer);
        StringBuffer badRes = null;
        LinkedList<String> xmlnses = new LinkedList<String>();
        boolean haveGood = false;
        boolean definedNamespaces = false;
        HashMap namespacesToPrefixes = new HashMap();
        int prefixInd = 0;
        DAVElementProperty propElement = docRootElement.getChild(DAVElement.PROP);
        List childrenElements = propElement.getChildren();
        boolean filledNamespaces = false;
        for (DAVElementProperty childElement : childrenElements) {
            LivePropertySpecification livePropSpec = this.findLiveProperty(childElement.getName());
            if (livePropSpec != null) {
                DAVInsertPropAction doneAction = this.insertLiveProp(propsProvider.getResource(), livePropSpec, DAVInsertPropAction.INSERT_VALUE, buffer);
                if (doneAction == DAVInsertPropAction.INSERT_VALUE) {
                    haveGood = true;
                    if (filledNamespaces) continue;
                    int ind = 0;
                    for (String namespace : NAMESPACES) {
                        String xmlns = " xmlns:lp" + ind + "=\"" + namespace + "\"";
                        xmlnses.add(xmlns);
                        ++ind;
                    }
                    filledNamespaces = true;
                    continue;
                }
                if (doneAction == DAVInsertPropAction.NOT_SUPP) continue;
            }
            if (propsProvider.isDeferred()) {
                propsProvider.open(true);
            }
            boolean found = false;
            try {
                found = propsProvider.outputValue(childElement.getName(), buffer);
            }
            catch (DAVException dave) {
                continue;
            }
            if (found) {
                haveGood = true;
                if (definedNamespaces) continue;
                propsProvider.defineNamespaces(namespacesToPrefixes);
                definedNamespaces = true;
                continue;
            }
            if (badRes == null) {
                badRes = new StringBuffer();
                SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)1, null, (StringBuffer)badRes);
                SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)1, null, (StringBuffer)badRes);
            }
            prefixInd = this.outputPropName(childElement.getName(), namespacesToPrefixes, prefixInd, buffer);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append("HTTP/1.1 200 OK");
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)buffer);
        DAVPropsResult result = new DAVPropsResult();
        if (badRes != null) {
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)badRes);
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)2, null, (StringBuffer)badRes);
            badRes.append("HTTP/1.1 404 Not Found");
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)badRes);
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)badRes);
            if (!haveGood) {
                result.addPropStatsText(badRes.toString());
            } else {
                result.addPropStatsText(buffer.toString());
                result.addPropStatsText(badRes.toString());
            }
        } else {
            result.addPropStatsText(buffer.toString());
        }
        this.addNamespaces(result, xmlnses);
        this.generateXMLNSNamespaces(result, namespacesToPrefixes);
        return result;
    }

    private void addNamespaces(DAVPropsResult result, Collection xmlnses) {
        for (String xmlnsString : xmlnses) {
            result.addNamespace(xmlnsString);
        }
    }

    private void addAllLivePropNamespaces(DAVPropsResult result) {
        for (String namespace : NAMESPACES) {
            int ind = NAMESPACES.indexOf(namespace);
            String xmlnsStr = " xmlns:lp" + ind + "=\"" + namespace + "\"";
            result.addNamespace(xmlnsStr);
        }
    }

    private void generateXMLNSNamespaces(DAVPropsResult result, Map namespacesToPrefixes) {
        for (String uri : namespacesToPrefixes.keySet()) {
            String prefix = (String)namespacesToPrefixes.get(uri);
            result.addNamespace(" xmlns:" + prefix + "=\"" + uri + "\"");
        }
    }

    private int outputPropName(DAVElement propName, Map namespacesToPrefixes, int ind, StringBuffer buffer) {
        if ("".equals(propName.getNamespace())) {
            SVNXMLUtil.openXMLTag(null, (String)propName.getName(), (int)4, null, (StringBuffer)buffer);
        } else {
            String prefix;
            String string = prefix = namespacesToPrefixes != null ? (String)namespacesToPrefixes.get(propName.getNamespace()) : null;
            if (prefix == null) {
                prefix = "g" + ind;
                namespacesToPrefixes.put(propName.getNamespace(), prefix);
            }
            SVNXMLUtil.openXMLTag((String)((String)namespacesToPrefixes.get(propName.getNamespace())), (String)propName.getName(), (int)4, null, (StringBuffer)buffer);
        }
        return ++ind;
    }

    private DAVInsertPropAction insertCoreLiveProperty(DAVResource resource, DAVInsertPropAction propAction, LivePropertySpecification livePropSpec, StringBuffer buffer) throws DAVException {
        DAVInsertPropAction inserted = DAVInsertPropAction.NOT_DEF;
        DAVElement livePropElement = livePropSpec.getPropertyName();
        String value = null;
        if (livePropElement == DAVElement.LOCK_DISCOVERY) {
            if (this.myLocksProvider != null) {
                DAVLock lock = null;
                try {
                    lock = this.myLocksProvider.getLock(resource);
                }
                catch (DAVException dave) {
                    throw new DAVException("DAV:lockdiscovery could not be determined due to a problem fetching the locks for this resource.", dave.getResponseCode(), dave, 0);
                }
                value = lock == null ? "" : DAVLockInfoProvider.getActiveLockXML(lock);
            }
        } else if (livePropElement == DAVElement.SUPPORTED_LOCK) {
            if (this.myLocksProvider != null) {
                value = this.myLocksProvider.getSupportedLock(resource);
            }
        } else if (livePropElement == DAVElement.GET_CONTENT_TYPE || livePropElement == DAVElement.GET_CONTENT_LANGUAGE) {
            // empty if block
        }
        if (value != null) {
            if (propAction == DAVInsertPropAction.INSERT_SUPPORTED) {
                SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.SUPPORTED_LIVE_PROPERTY.getName(), (int)1, (String)"D:name", (String)livePropElement.getName(), (StringBuffer)buffer);
            } else if (propAction == DAVInsertPropAction.INSERT_VALUE && !"".equals(value)) {
                SVNXMLUtil.openCDataTag((String)"D", (String)livePropElement.getName(), (String)value, null, (boolean)false, (boolean)false, (StringBuffer)buffer);
            } else {
                SVNXMLUtil.openXMLTag((String)"D", (String)livePropElement.getName(), (int)4, null, (StringBuffer)buffer);
            }
            inserted = propAction;
        }
        return inserted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DAVInsertPropAction insertLiveProp(DAVResource resource, LivePropertySpecification livePropSpec, DAVInsertPropAction propAction, StringBuffer buffer) throws DAVException {
        String value;
        DAVElement livePropElement;
        block88: {
            DAVResourceURI uri;
            block92: {
                block91: {
                    block90: {
                        block89: {
                            if (!livePropSpec.isSVNSupported()) {
                                return this.insertCoreLiveProperty(resource, propAction, livePropSpec, buffer);
                            }
                            livePropElement = livePropSpec.getPropertyName();
                            if (!resource.exists() && livePropElement != DAVElement.VERSION_CONTROLLED_CONFIGURATION && livePropElement != DAVElement.BASELINE_RELATIVE_PATH) {
                                return DAVInsertPropAction.NOT_SUPP;
                            }
                            value = null;
                            uri = resource.getResourceURI();
                            if (livePropElement != DAVElement.GET_LAST_MODIFIED && livePropElement != DAVElement.CREATION_DATE) break block89;
                            if (resource.getType() == DAVResourceType.PRIVATE && resource.getKind() == DAVResourceKind.VCC) {
                                return DAVInsertPropAction.NOT_SUPP;
                            }
                            if (livePropElement == DAVElement.CREATION_DATE) {
                                try {
                                    value = SVNDate.formatDate((Date)this.getLastModifiedTime2(resource));
                                }
                                catch (SVNException svne) {
                                    return DAVInsertPropAction.NOT_DEF;
                                }
                            }
                            if (livePropElement == DAVElement.GET_LAST_MODIFIED) {
                                try {
                                    value = SVNDate.formatRFC1123Date((Date)this.getLastModifiedTime2(resource));
                                }
                                catch (SVNException svne) {
                                    return DAVInsertPropAction.NOT_DEF;
                                }
                            }
                            value = SVNEncodingUtil.xmlEncodeCDATA((String)value, (boolean)true);
                            break block88;
                        }
                        if (livePropElement != DAVElement.CREATOR_DISPLAY_NAME) break block90;
                        if (resource.getType() == DAVResourceType.PRIVATE && resource.getKind() == DAVResourceKind.VCC) {
                            return DAVInsertPropAction.NOT_SUPP;
                        }
                        long committedRev = -1L;
                        if (resource.isBaseLined() && resource.getType() == DAVResourceType.VERSION) {
                            committedRev = resource.getRevision();
                        } else {
                            if (resource.getType() != DAVResourceType.REGULAR && resource.getType() != DAVResourceType.WORKING) {
                                if (resource.getType() != DAVResourceType.VERSION) return DAVInsertPropAction.NOT_SUPP;
                            }
                            try {
                                committedRev = resource.getCreatedRevisionUsingFS(null);
                            }
                            catch (SVNException svne) {
                                value = "###error###";
                            }
                        }
                        String lastAuthor = null;
                        try {
                            lastAuthor = resource.getAuthor(committedRev);
                        }
                        catch (SVNException svne) {
                            value = "###error###";
                        }
                        if (lastAuthor == null) {
                            return DAVInsertPropAction.NOT_DEF;
                        }
                        value = SVNEncodingUtil.xmlEncodeCDATA((String)lastAuthor, (boolean)true);
                        break block88;
                    }
                    if (livePropElement == DAVElement.GET_CONTENT_LANGUAGE) {
                        return DAVInsertPropAction.NOT_SUPP;
                    }
                    if (livePropElement != DAVElement.GET_CONTENT_LENGTH) break block91;
                    if (resource.isCollection()) return DAVInsertPropAction.NOT_SUPP;
                    if (resource.isBaseLined()) {
                        return DAVInsertPropAction.NOT_SUPP;
                    }
                    long fileSize = 0L;
                    try {
                        fileSize = resource.getContentLength(null);
                        value = String.valueOf(fileSize);
                    }
                    catch (SVNException e) {
                        value = "0";
                    }
                    break block88;
                }
                if (livePropElement != DAVElement.GET_CONTENT_TYPE) break block92;
                if (resource.isBaseLined() && resource.getType() == DAVResourceType.VERSION) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                if (resource.getType() == DAVResourceType.PRIVATE && resource.getKind() == DAVResourceKind.VCC) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                if (resource.isCollection()) {
                    value = "text/html; charset=\"utf-8\"";
                    break block88;
                } else {
                    SVNPropertyValue contentType = null;
                    try {
                        contentType = resource.getProperty(null, "svn:mime-type");
                    }
                    catch (SVNException sVNException) {
                        // empty catch block
                    }
                    value = contentType != null ? contentType.getString() : (!resource.isSVNClient() && this.getRequest().getContentType() != null ? this.getRequest().getContentType() : "text/plain");
                    try {
                        SVNPropertiesManager.validateMimeType((String)value);
                    }
                    catch (SVNException svne) {
                        return DAVInsertPropAction.NOT_DEF;
                    }
                }
            }
            if (livePropElement == DAVElement.GET_ETAG) {
                if (resource.getType() == DAVResourceType.PRIVATE && resource.getKind() == DAVResourceKind.VCC) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                value = resource.getETag();
            } else if (livePropElement == DAVElement.AUTO_VERSION) {
                if (!this.getConfig().isAutoVersioning()) return DAVInsertPropAction.NOT_DEF;
                value = DEFAULT_AUTOVERSION_LINE;
            } else if (livePropElement == DAVElement.BASELINE_COLLECTION) {
                if (resource.getType() != DAVResourceType.VERSION) return DAVInsertPropAction.NOT_SUPP;
                if (!resource.isBaseLined()) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                value = DAVPathUtil.buildURI(uri.getContext(), DAVResourceKind.BASELINE_COLL, resource.getRevision(), null, true);
            } else if (livePropElement == DAVElement.CHECKED_IN) {
                String s = null;
                if (resource.getType() == DAVResourceType.PRIVATE && resource.getKind() == DAVResourceKind.VCC) {
                    long revNum = -1L;
                    try {
                        revNum = resource.getLatestRevision();
                        s = DAVPathUtil.buildURI(uri.getContext(), DAVResourceKind.BASELINE, revNum, null, false);
                        StringBuffer buf = SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.HREF.getName(), (String)s, null, (boolean)true, (boolean)true, null);
                        value = buf.toString();
                    }
                    catch (SVNException svne) {
                        value = "###error###";
                    }
                } else {
                    if (resource.getType() != DAVResourceType.REGULAR) {
                        return DAVInsertPropAction.NOT_SUPP;
                    }
                    long revToUse = DAVServletUtil.getSafeCreatedRevision((FSRevisionRoot)resource.getRoot(), uri.getPath());
                    s = DAVPathUtil.buildURI(uri.getContext(), DAVResourceKind.VERSION, revToUse, uri.getPath(), false);
                    StringBuffer buf = SVNXMLUtil.openCDataTag((String)"D", (String)DAVElement.HREF.getName(), (String)s, null, (boolean)true, (boolean)true, null);
                    value = buf.toString();
                }
            } else if (livePropElement == DAVElement.VERSION_CONTROLLED_CONFIGURATION) {
                if (resource.getType() != DAVResourceType.REGULAR) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                value = DAVPathUtil.buildURI(uri.getContext(), DAVResourceKind.VCC, -1L, null, true);
            } else if (livePropElement == DAVElement.VERSION_NAME) {
                if (resource.getType() != DAVResourceType.VERSION && !resource.isVersioned()) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                if (resource.getType() == DAVResourceType.PRIVATE && resource.getKind() == DAVResourceKind.VCC) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                if (resource.isBaseLined()) {
                    value = String.valueOf(resource.getRevision());
                } else {
                    try {
                        long committedRev = resource.getCreatedRevisionUsingFS(null);
                        value = String.valueOf(committedRev);
                        value = SVNEncodingUtil.xmlEncodeCDATA((String)value, (boolean)true);
                    }
                    catch (SVNException svne) {
                        value = "###error###";
                    }
                }
            } else if (livePropElement == DAVElement.BASELINE_RELATIVE_PATH) {
                if (resource.getType() != DAVResourceType.REGULAR) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                value = SVNEncodingUtil.xmlEncodeCDATA((String)DAVPathUtil.dropLeadingSlash(uri.getPath()), (boolean)true);
            } else if (livePropElement == DAVElement.MD5_CHECKSUM) {
                if (resource.isCollection()) return DAVInsertPropAction.NOT_SUPP;
                if (resource.isBaseLined()) return DAVInsertPropAction.NOT_SUPP;
                if (resource.getType() != DAVResourceType.REGULAR && resource.getType() != DAVResourceType.VERSION) {
                    if (resource.getType() != DAVResourceType.WORKING) return DAVInsertPropAction.NOT_SUPP;
                }
                try {
                    value = resource.getMD5Checksum(null);
                    if (value == null) {
                        return DAVInsertPropAction.NOT_SUPP;
                    }
                }
                catch (SVNException svne) {
                    value = "###error###";
                }
            } else if (livePropElement == DAVElement.REPOSITORY_UUID) {
                try {
                    value = resource.getRepositoryUUID(false);
                }
                catch (SVNException svne) {
                    value = "###error###";
                }
            } else if (livePropElement == DAVElement.DEADPROP_COUNT) {
                if (resource.getType() != DAVResourceType.REGULAR) {
                    return DAVInsertPropAction.NOT_SUPP;
                }
                SVNProperties props = null;
                try {
                    props = resource.getSVNProperties(null);
                    int deadPropertiesCount = props.size();
                    value = String.valueOf(deadPropertiesCount);
                }
                catch (SVNException svne) {
                    value = "###error###";
                }
            } else {
                if (livePropElement != DAVElement.RESOURCE_TYPE) {
                    if (livePropElement == DAVElement.COMMENT) return DAVInsertPropAction.NOT_DEF;
                    if (livePropElement == DAVElement.CREATOR_DISPLAY_NAME) return DAVInsertPropAction.NOT_DEF;
                    if (livePropElement == DAVElement.DISPLAY_NAME) return DAVInsertPropAction.NOT_DEF;
                    if (livePropElement != DAVElement.SOURCE) return DAVInsertPropAction.NOT_SUPP;
                    return DAVInsertPropAction.NOT_DEF;
                }
                if (resource.getType() == DAVResourceType.VERSION) {
                    if (resource.isBaseLined()) {
                        StringBuffer buf = SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.BASELINE.getName(), (int)6, null, null);
                        value = buf.toString();
                    }
                } else if (resource.getType() == DAVResourceType.REGULAR || resource.getType() == DAVResourceType.WORKING) {
                    if (resource.isCollection()) {
                        StringBuffer buf = SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.COLLECTION.getName(), (int)6, null, null);
                        value = buf.toString();
                    } else {
                        value = "";
                    }
                } else if (resource.getType() == DAVResourceType.HISTORY) {
                    StringBuffer buf = SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.VERSION_HISTORY.getName(), (int)6, null, null);
                    value = buf.toString();
                } else if (resource.getType() == DAVResourceType.WORKSPACE) {
                    StringBuffer buf = SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.COLLECTION.getName(), (int)6, null, null);
                    value = buf.toString();
                } else {
                    if (resource.getType() != DAVResourceType.ACTIVITY) return DAVInsertPropAction.NOT_DEF;
                    StringBuffer buf = SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.ACTIVITY.getName(), (int)6, null, null);
                    value = buf.toString();
                }
            }
        }
        int ind = NAMESPACES.indexOf(livePropElement.getNamespace());
        String prefix = "lp" + ind;
        if (propAction == DAVInsertPropAction.INSERT_NAME || propAction == DAVInsertPropAction.INSERT_VALUE && (value == null || value.length() == 0)) {
            SVNXMLUtil.openXMLTag((String)prefix, (String)livePropElement.getName(), (int)4, null, (StringBuffer)buffer);
            return propAction;
        }
        if (propAction == DAVInsertPropAction.INSERT_VALUE) {
            SVNXMLUtil.openCDataTag((String)prefix, (String)livePropElement.getName(), (String)value, null, (boolean)false, (boolean)false, (StringBuffer)buffer);
            return propAction;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("D:name", livePropElement.getName());
        attrs.put("D:namespace", livePropElement.getNamespace());
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.SUPPORTED_LIVE_PROPERTY.getName(), (int)4, attrs, (StringBuffer)buffer);
        return propAction;
    }

    private Date getLastModifiedTime2(DAVResource resource) throws SVNException {
        long revision = -1L;
        if (resource.isBaseLined() && resource.getType() == DAVResourceType.VERSION) {
            revision = resource.getRevision();
        } else if (resource.getType() == DAVResourceType.REGULAR || resource.getType() == DAVResourceType.WORKING || resource.getType() == DAVResourceType.VERSION) {
            revision = resource.getCreatedRevisionUsingFS(null);
        } else {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_PROPS_NOT_FOUND, (String)"Failed to determine property"), (SVNLogType)SVNLogType.NETWORK);
        }
        return resource.getRevisionDate(revision);
    }

    private void streamResponse(DAVResource resource, int status, DAVPropsResult propStats) {
        DAVResponse response = new DAVResponse(null, resource.getResourceURI().getRequestURI(), null, propStats, status);
        DAVXMLUtil.sendOneResponse(response, this.myResponseBuffer);
    }

    private void cacheBadProps() {
        if (this.myPropStat404 != null) {
            return;
        }
        this.myPropStat404 = new StringBuffer();
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)2, null, (StringBuffer)this.myPropStat404);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)2, null, (StringBuffer)this.myPropStat404);
        DAVElementProperty elem = this.myDocRoot.getChild(DAVElement.PROP);
        List childrenElements = elem.getChildren();
        for (DAVElementProperty childElement : childrenElements) {
            DAVXMLUtil.addEmptyElement(this.getNamespaces(), childElement.getName(), this.myPropStat404);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)this.myPropStat404);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)1, null, (StringBuffer)this.myPropStat404);
        this.myPropStat404.append("HTTP/1.1 404 Not Found");
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)this.myPropStat404);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)this.myPropStat404);
    }

    private DAVPropfindRequest getPropfindRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVPropfindRequest();
        }
        return this.myDAVRequest;
    }

    static {
        NAMESPACES.add("DAV:");
        NAMESPACES.add("http://subversion.tigris.org/xmlns/dav/");
    }

    private static class DAVInsertPropAction {
        public static final DAVInsertPropAction NOT_DEF = new DAVInsertPropAction();
        public static final DAVInsertPropAction NOT_SUPP = new DAVInsertPropAction();
        public static final DAVInsertPropAction INSERT_VALUE = new DAVInsertPropAction();
        public static final DAVInsertPropAction INSERT_NAME = new DAVInsertPropAction();
        public static final DAVInsertPropAction INSERT_SUPPORTED = new DAVInsertPropAction();

        private DAVInsertPropAction() {
        }
    }
}

