/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropPatchRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropertiesProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropsResult;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.LivePropertySpecification;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVPropPatchHandler
extends ServletDAVHandler {
    private DAVPropPatchRequest myDAVRequest;

    protected DAVPropPatchHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    public void execute() throws SVNException {
        DAVResource resource = this.getRequestedDAVResource(false, false);
        if (!resource.exists()) {
            this.sendError(400, null);
            return;
        }
        long readLength = this.readInput(false);
        if (readLength <= 0L) {
            this.getPropPatchRequest().invalidXMLRoot();
        }
        this.validateRequest(resource, DAVDepth.DEPTH_ZERO, 16, null, null, null);
        ServletDAVHandler.DAVAutoVersionInfo avInfo = this.autoCheckOut(resource, false);
        DAVPropertiesProvider propsProvider = null;
        try {
            propsProvider = DAVPropertiesProvider.createPropertiesProvider(resource, this);
        }
        catch (DAVException dave) {
            this.autoCheckIn(resource, true, false, avInfo);
            throw new DAVException("Could not open the property database for {0}.", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)this.getURI())}, 500, 0);
        }
        boolean isFailure = false;
        LinkedList<PropertyChangeContext> properties = new LinkedList<PropertyChangeContext>();
        DAVPropPatchRequest requestXMLObject = this.getPropPatchRequest();
        DAVElementProperty rootElement = requestXMLObject.getRoot();
        List childrenElements = rootElement.getChildren();
        for (DAVElementProperty childElement : childrenElements) {
            boolean isRemove;
            DAVElement childElementName = childElement.getName();
            if (!"DAV:".equals(childElementName.getNamespace()) || childElementName != DAVPropPatchRequest.REMOVE && childElementName != DAVPropPatchRequest.SET) continue;
            DAVElementProperty propChildrenElement = childElement.getChild(DAVElement.PROP);
            if (propChildrenElement == null) {
                this.autoCheckIn(resource, true, false, avInfo);
                SVNDebugLog.getDefaultLog().logError(SVNLogType.NETWORK, "A \"prop\" element is missing inside the propertyupdate command.");
                this.setResponseStatus(400);
                return;
            }
            boolean bl = isRemove = childElementName == DAVPropPatchRequest.REMOVE;
            List propChildren = propChildrenElement.getChildren();
            if (propChildren == null) continue;
            for (DAVElementProperty property : propChildren) {
                DAVElement propertyName = property.getName();
                PropertyChangeContext propContext = new PropertyChangeContext();
                propContext.myIsSet = !isRemove;
                propContext.myProperty = property;
                properties.add(propContext);
                this.validateProp(propertyName, propsProvider, propContext);
                if (propContext.myError == null || propContext.myError.getResponseCode() < 300) continue;
                isFailure = true;
            }
        }
        String propStatText = null;
        DAVPropertyExecuteHandler executeHandler = new DAVPropertyExecuteHandler(propsProvider);
        if (!isFailure && this.processPropertyContextList(executeHandler, properties, true, false)) {
            isFailure = true;
        }
        if (isFailure) {
            DAVPropertyRollBackHandler rollBackHandler = new DAVPropertyRollBackHandler(propsProvider);
            this.processPropertyContextList(rollBackHandler, properties, false, true);
            propStatText = this.getFailureMessage(properties);
        } else {
            propStatText = this.getSuccessMessage(properties);
        }
        this.autoCheckIn(resource, isFailure, false, avInfo);
        DAVPropsResult propResult = new DAVPropsResult();
        propResult.addPropStatsText(propStatText);
        DAVResponse response = new DAVResponse(null, resource.getResourceURI().getRequestURI(), null, propResult, 0);
        try {
            DAVXMLUtil.sendMultiStatus(response, this.getHttpServletResponse(), 207, this.getNamespaces());
        }
        catch (IOException ioe) {
            throw new DAVException(ioe.getMessage(), 500, SVNErrorCode.IO_ERROR.getCode());
        }
    }

    private String getFailureMessage(List propContextList) {
        DAVException err424Set = null;
        DAVException err424Delete = null;
        StringBuffer buffer = new StringBuffer();
        for (PropertyChangeContext propContext : propContextList) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)1, null, (StringBuffer)buffer);
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)2, null, (StringBuffer)buffer);
            DAVXMLUtil.addEmptyElement(this.getNamespaces(), propContext.myProperty.getName(), buffer);
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)buffer);
            if (propContext.myError == null) {
                if (propContext.myIsSet) {
                    if (err424Set == null) {
                        err424Set = new DAVException("Attempted DAV:set operation could not be completed due to other errors.", 424, 0);
                    }
                    propContext.myError = err424Set;
                } else {
                    if (err424Delete == null) {
                        err424Delete = new DAVException("Attempted DAV:remove operation could not be completed due to other errors.", 424, 0);
                    }
                    propContext.myError = err424Delete;
                }
            }
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)2, null, (StringBuffer)buffer);
            buffer.append("HTTP/1.1 ");
            buffer.append(propContext.myError.getResponseCode());
            buffer.append(" (status)");
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)buffer);
            if (propContext.myError.getMessage() != null) {
                SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.RESPONSE_DESCRIPTION.getName(), (int)1, null, (StringBuffer)buffer);
                buffer.append(propContext);
                SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.RESPONSE_DESCRIPTION.getName(), (StringBuffer)buffer);
            }
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)buffer);
        }
        return buffer.toString();
    }

    private String getSuccessMessage(List propContextList) {
        StringBuffer buffer = new StringBuffer();
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.PROP.getName(), (int)1, null, (StringBuffer)buffer);
        for (PropertyChangeContext propContext : propContextList) {
            DAVXMLUtil.addEmptyElement(this.getNamespaces(), propContext.myProperty.getName(), buffer);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append("HTTP/1.1 200 OK");
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.STATUS.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROPSTAT.getName(), (StringBuffer)buffer);
        return buffer.toString();
    }

    private boolean processPropertyContextList(IDAVPropertyContextHandler handler, List propertyContextList, boolean stopOnError, boolean reverse) {
        ListIterator propContextIterator = propertyContextList.listIterator(reverse ? propertyContextList.size() : 0);
        while (reverse ? propContextIterator.hasPrevious() : propContextIterator.hasNext()) {
            PropertyChangeContext propContext = (PropertyChangeContext)(reverse ? propContextIterator.previous() : propContextIterator.next());
            handler.handleContext(propContext);
            if (!stopOnError || propContext.myError == null || propContext.myError.getResponseCode() < 300) continue;
            return true;
        }
        return false;
    }

    private void validateProp(DAVElement property, DAVPropertiesProvider propsProvider, PropertyChangeContext propContext) {
        LivePropertySpecification livePropSpec = this.findLiveProperty(property);
        propContext.myLivePropertySpec = livePropSpec;
        if (!this.isPropertyWritable(property, livePropSpec)) {
            propContext.myError = new DAVException("Property is read-only.", 409, 201);
            return;
        }
        if (livePropSpec != null && livePropSpec.isSVNSupported()) {
            return;
        }
        if (propsProvider.isDeferred()) {
            try {
                propsProvider.open(false);
            }
            catch (DAVException dave) {
                propContext.myError = dave;
                return;
            }
        }
        if (!propsProvider.isOperative()) {
            propContext.myError = new DAVException("Attempted to set/remove a property without a valid, open, read/write property database.", 500, 202);
            return;
        }
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getPropPatchRequest();
    }

    private boolean isPropertyWritable(DAVElement property, LivePropertySpecification livePropSpec) {
        if (livePropSpec != null) {
            return livePropSpec.isWritable();
        }
        return property != DAVElement.LOCK_DISCOVERY && property != DAVElement.SUPPORTED_LOCK;
    }

    private DAVPropPatchRequest getPropPatchRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVPropPatchRequest();
        }
        return this.myDAVRequest;
    }

    private class DAVPropertyRollBackHandler
    implements IDAVPropertyContextHandler {
        private DAVPropertiesProvider myPropsProvider;

        public DAVPropertyRollBackHandler(DAVPropertiesProvider propsProvider) {
            this.myPropsProvider = propsProvider;
        }

        @Override
        public void handleContext(PropertyChangeContext propContext) {
            if (propContext.myRollBackProperty == null) {
                return;
            }
            if (propContext.myLivePropertySpec == null) {
                try {
                    this.myPropsProvider.applyRollBack(propContext.myRollBackProperty.myPropertyName, propContext.myRollBackProperty.myRollBackPropertyValue);
                }
                catch (DAVException dave) {
                    if (propContext.myError == null) {
                        propContext.myError = dave;
                    }
                    DAVException err = dave;
                    while (err.getPreviousException() != null) {
                        err = err.getPreviousException();
                    }
                    err.setPreviousException(propContext.myError);
                    propContext.myError = dave;
                }
            }
        }
    }

    private class DAVPropertyExecuteHandler
    implements IDAVPropertyContextHandler {
        private DAVPropertiesProvider myPropsProvider;

        public DAVPropertyExecuteHandler(DAVPropertiesProvider propsProvider) {
            this.myPropsProvider = propsProvider;
        }

        @Override
        public void handleContext(PropertyChangeContext propContext) {
            if (propContext.myLivePropertySpec == null) {
                try {
                    SVNPropertyValue rollBackPropValue = this.myPropsProvider.getPropertyValue(propContext.myProperty.getName());
                    propContext.myRollBackProperty = new RollBackProperty(propContext.myProperty.getName(), rollBackPropValue);
                }
                catch (DAVException dave) {
                    this.handleError(dave, propContext);
                    return;
                }
                if (propContext.myIsSet) {
                    try {
                        this.myPropsProvider.storeProperty(propContext.myProperty);
                    }
                    catch (DAVException dave) {
                        this.handleError(dave, propContext);
                        return;
                    }
                }
                try {
                    this.myPropsProvider.removeProperty(propContext.myProperty.getName());
                }
                catch (DAVException dAVException) {
                    // empty catch block
                }
            }
        }

        private void handleError(DAVException dave, PropertyChangeContext propContext) {
            DAVException exc = new DAVException("Could not execute PROPPATCH.", 500, dave, 206);
            propContext.myError = exc;
        }
    }

    private static interface IDAVPropertyContextHandler {
        public void handleContext(PropertyChangeContext var1);
    }

    private static class RollBackProperty {
        private DAVElement myPropertyName;
        private SVNPropertyValue myRollBackPropertyValue;

        public RollBackProperty(DAVElement propertyName, SVNPropertyValue rollBackPropertyValue) {
            this.myPropertyName = propertyName;
            this.myRollBackPropertyValue = rollBackPropertyValue;
        }
    }

    private static class PropertyChangeContext {
        private boolean myIsSet;
        private DAVElementProperty myProperty;
        private LivePropertySpecification myLivePropertySpec;
        private DAVException myError;
        private RollBackProperty myRollBackProperty;

        private PropertyChangeContext() {
        }
    }
}

