/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Collection;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVMergeInfoRequest
extends DAVRequest {
    private static final DAVElement INHERIT = DAVElement.getElement((String)"svn:", (String)"inherit");
    long myRevision = -1L;
    SVNMergeInfoInheritance myInherit = SVNMergeInfoInheritance.EXPLICIT;
    String[] myTargetPaths = null;

    public long getRevision() {
        return this.myRevision;
    }

    private void setRevision(long revision) {
        this.myRevision = revision;
    }

    public SVNMergeInfoInheritance getInherit() {
        return this.myInherit;
    }

    private void setInherit(SVNMergeInfoInheritance inherit) {
        this.myInherit = inherit;
    }

    public String[] getTargetPaths() {
        return this.myTargetPaths;
    }

    private void setTargetPaths(String[] targetPaths) {
        this.myTargetPaths = targetPaths;
    }

    @Override
    protected void init() throws SVNException {
        List children = this.getRootElement().getChildren();
        for (DAVElementProperty property : children) {
            DAVElement element = property.getName();
            if (element == DAVElement.REVISION) {
                try {
                    this.setRevision(Long.parseLong(property.getFirstValue(true)));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (element == INHERIT) {
                this.setInherit(this.parseInheritance(property.getFirstValue(true)));
                if (this.getInherit() != null) continue;
                this.invalidXML();
                continue;
            }
            if (element != DAVElement.PATH) continue;
            Collection paths = property.getValues();
            String[] targetPaths = new String[paths.size()];
            targetPaths = paths.toArray(targetPaths);
            this.setTargetPaths(targetPaths);
        }
    }

    private SVNMergeInfoInheritance parseInheritance(String inheritance) {
        if (SVNMergeInfoInheritance.EXPLICIT.toString().equals(inheritance)) {
            return SVNMergeInfoInheritance.EXPLICIT;
        }
        if (SVNMergeInfoInheritance.INHERITED.toString().equals(inheritance)) {
            return SVNMergeInfoInheritance.INHERITED;
        }
        if (SVNMergeInfoInheritance.NEAREST_ANCESTOR.toString().equals(inheritance)) {
            return SVNMergeInfoInheritance.NEAREST_ANCESTOR;
        }
        return null;
    }
}

