/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfo;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMergeInfoRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;

public class DAVMergeInfoHandler
extends DAVReportHandler {
    private static final String MERGEINFO_REPORT = "mergeinfo-report";
    private DAVMergeInfoRequest myDAVRequest;
    private DAVReportHandler myCommonReportHandler;

    public DAVMergeInfoHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response, DAVReportHandler commonReportHandler) {
        super(repositoryManager, request, response);
        this.myCommonReportHandler = commonReportHandler;
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getMergeInfoRequest();
    }

    private DAVMergeInfoRequest getMergeInfoRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVMergeInfoRequest();
        }
        return this.myDAVRequest;
    }

    @Override
    public void execute() throws SVNException {
        this.myCommonReportHandler.checkSVNNamespace(null);
        this.setDAVResource(this.getRequestedDAVResource(false, false));
        String responseBody = this.generateResponseBody();
        try {
            this.setResponseContentLength(responseBody.getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.write(responseBody);
    }

    private String generateResponseBody() throws SVNException {
        StringBuffer xmlBuffer = new StringBuffer();
        this.addXMLHeader(xmlBuffer, MERGEINFO_REPORT);
        HashMap<String, String> pathMapping = new HashMap<String, String>();
        for (int i = 0; i < this.getMergeInfoRequest().getTargetPaths().length; ++i) {
            String newPath;
            String currentPath = this.getMergeInfoRequest().getTargetPaths()[i];
            DAVPathUtil.testCanonical(currentPath);
            if (currentPath.length() != 0 && currentPath.charAt(0) == '/') continue;
            this.getMergeInfoRequest().getTargetPaths()[i] = newPath = SVNPathUtil.append((String)this.getDAVResource().getResourceURI().getPath(), (String)currentPath);
            pathMapping.put(newPath, currentPath);
        }
        Map mergeInfoMap = this.getDAVResource().getRepository().getMergeInfo(this.getMergeInfoRequest().getTargetPaths(), this.getMergeInfoRequest().getRevision(), this.getMergeInfoRequest().getInherit(), false);
        if (mergeInfoMap != null && !mergeInfoMap.isEmpty()) {
            for (Map.Entry entry : mergeInfoMap.entrySet()) {
                String path = (String)entry.getKey();
                if (pathMapping.containsKey(path)) {
                    path = (String)pathMapping.get(path);
                }
                SVNMergeInfo mergeInfo = (SVNMergeInfo)entry.getValue();
                this.addMergeInfo(path, mergeInfo, xmlBuffer);
            }
        }
        this.addXMLFooter(xmlBuffer, MERGEINFO_REPORT);
        return xmlBuffer.toString();
    }

    private void addMergeInfo(String path, SVNMergeInfo mergeInfo, StringBuffer xmlBuffer) {
        SVNXMLUtil.openXMLTag((String)"S", (String)"mergeinfo-item", (int)1, null, (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"S", (String)"mergeinfo-path", (String)path, (StringBuffer)xmlBuffer);
        SVNXMLUtil.openCDataTag((String)"S", (String)"mergeinfo-info", (String)this.addSourcePathes(mergeInfo), (StringBuffer)xmlBuffer);
        SVNXMLUtil.closeXMLTag((String)"S", (String)"mergeinfo-item", (StringBuffer)xmlBuffer);
    }

    private String addSourcePathes(SVNMergeInfo mergeInfo) {
        StringBuffer result = new StringBuffer();
        Iterator iterator = mergeInfo.getMergeSourcesToMergeLists().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String sourcePath = (String)entry.getKey();
            SVNMergeRangeList rangeList = (SVNMergeRangeList)entry.getValue();
            result.append(sourcePath);
            result.append(":");
            result.append(rangeList.toString());
            if (!iterator.hasNext()) continue;
            result.append('\n');
        }
        return result.toString();
    }
}

