/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceState;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;

public class DAVMakeCollectionHandler
extends ServletDAVHandler {
    protected DAVMakeCollectionHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    public void execute() throws SVNException {
        int status = this.processMkColBody();
        if (status != 200) {
            this.sendError(status, null);
            return;
        }
        DAVResource resource = this.getRequestedDAVResource(false, false);
        if (resource.exists()) {
            this.sendError(405, null);
            return;
        }
        DAVResourceState resourceState = this.getResourceState(resource);
        this.validateRequest(resource, DAVDepth.DEPTH_ZERO, resourceState == DAVResourceState.NULL ? 32 : 16, null, null, null);
        DAVException err1 = null;
        DAVException err2 = null;
        ServletDAVHandler.DAVAutoVersionInfo avInfo = this.autoCheckOut(resource, true);
        resource.setCollection(true);
        try {
            this.createdCollection(resource);
        }
        catch (DAVException dave) {
            err1 = dave;
        }
        try {
            this.autoCheckIn(resource, err1 != null, false, avInfo);
        }
        catch (DAVException dave) {
            err2 = dave;
        }
        if (err1 != null) {
            throw err1;
        }
        if (err2 != null) {
            err1 = new DAVException("The MKCOL was successful, but there was a problem opening the lock database which prevents inheriting locks from the parent resources.", err2.getResponseCode(), err2, 0);
        }
        DAVLockInfoProvider lockProvider = null;
        try {
            lockProvider = DAVLockInfoProvider.createLockInfoProvider(this, false);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "The MKCOL was successful, but there was a problem opening the lock database which prevents inheriting locks from the parent resources.", null);
        }
        this.notifyCreated(resource, lockProvider, resourceState, DAVDepth.DEPTH_ZERO);
        this.handleDAVCreated(null, "Collection", false);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return null;
    }

    private int processMkColBody() throws SVNException {
        String transferEncoding = this.getRequestHeader("Transfer-Encoding");
        String contentLength = this.getRequestHeader("Content-Length");
        boolean readChunked = false;
        int remaining = 0;
        if (transferEncoding != null) {
            if (!transferEncoding.equalsIgnoreCase("chunked")) {
                return 501;
            }
            readChunked = true;
        } else if (contentLength != null) {
            try {
                remaining = Integer.parseInt(contentLength.trim());
            }
            catch (NumberFormatException nfe) {
                return 400;
            }
        }
        if (readChunked || remaining > 0) {
            return 415;
        }
        this.readInput(true);
        return 200;
    }
}

