/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.LinkedList;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockScope;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVServlet;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.IDAVResourceWalkHandler;

public class DAVLockWalker
implements IDAVResourceWalkHandler {
    private DAVResource myResource;
    private DAVLock myLock;

    public DAVLockWalker(DAVResource resource, DAVLock lock) {
        this.myResource = resource;
        this.myLock = lock;
    }

    @Override
    public DAVResponse handleResource(DAVResponse response, DAVResource resource, DAVLockInfoProvider lockInfoProvider, LinkedList ifHeaders, int flags, DAVLockScope lockScope, IDAVResourceWalkHandler.CallType callType) throws DAVException {
        if (this.myResource.equals(resource)) {
            return null;
        }
        try {
            lockInfoProvider.appendLock(resource, this.myLock);
        }
        catch (DAVException dave) {
            if (DAVServlet.isHTTPServerError(dave.getResponseCode())) {
                throw dave;
            }
            DAVResponse resp = new DAVResponse(null, resource.getResourceURI().getRequestURI(), response, null, dave.getResponseCode());
            return resp;
        }
        return null;
    }
}

