/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSLock;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.server.dav.DAVConfig;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockRecType;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockScope;
import org.tmatesoft.svn.core.internal.server.dav.DAVLockType;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceHelper;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceURI;
import org.tmatesoft.svn.core.internal.server.dav.DAVServletUtil;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVInheritWalker;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockWalker;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResourceWalker;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVResponse;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DAVLockInfoProvider {
    public static final String LOCK_BREAK_OPTION = "lock-break";
    public static final String LOCK_STEAL_OPTION = "lock-steal";
    public static final String RELEASE_LOCKS_OPTION = "release-locks";
    public static final String KEEP_LOCKS_OPTION = "keep-locks";
    public static final String NO_MERGE_RESPONSE = "no-merge-response";
    private boolean myIsReadOnly;
    private boolean myIsStealLock;
    private boolean myIsBreakLock;
    private boolean myIsKeepLocks;
    private long myWorkingRevision;
    private ServletDAVHandler myOwner;

    public static DAVLockInfoProvider createLockInfoProvider(ServletDAVHandler owner, boolean readOnly) throws SVNException {
        String clientOptions = owner.getRequestHeader("X-SVN-Options");
        DAVLockInfoProvider provider = new DAVLockInfoProvider();
        provider.myOwner = owner;
        provider.myIsReadOnly = readOnly;
        if (clientOptions != null) {
            if (clientOptions.indexOf(LOCK_BREAK_OPTION) != -1) {
                provider.myIsBreakLock = true;
            }
            if (clientOptions.indexOf(LOCK_STEAL_OPTION) != -1) {
                provider.myIsStealLock = true;
            }
            if (clientOptions.indexOf(KEEP_LOCKS_OPTION) != -1) {
                provider.myIsKeepLocks = true;
            }
        }
        String versionName = owner.getRequestHeader("X-SVN-Version-Name");
        provider.myWorkingRevision = -1L;
        if (versionName != null) {
            try {
                provider.myWorkingRevision = Long.parseLong(versionName);
            }
            catch (NumberFormatException nfe) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
            }
        }
        return provider;
    }

    public void addLock(DAVLock lock, DAVResource resource) throws DAVException {
        DAVLockWalker lockHandler;
        DAVResourceWalker walker;
        DAVResponse response;
        DAVDepth depth = lock.getDepth();
        if (!resource.isCollection()) {
            depth = DAVDepth.DEPTH_ZERO;
        }
        this.appendLock(resource, lock);
        if (depth != DAVDepth.DEPTH_ZERO && (response = (walker = new DAVResourceWalker()).walk(this, resource, null, 0, null, 3, lockHandler = new DAVLockWalker(resource, lock), DAVDepth.DEPTH_INFINITY)) != null) {
            throw new DAVException("Error(s) occurred on resources during the addition of a depth lock.", 207, 0, response);
        }
    }

    public DAVLock refreshLock(DAVResource resource, String lockToken, Date newTime) throws DAVException {
        FSFS fsfs = resource.getFSFS();
        String path = resource.getResourceURI().getPath();
        FSLock svnLock = null;
        try {
            svnLock = (FSLock)fsfs.getLockHelper(path, false);
        }
        catch (SVNException e) {
            throw DAVException.convertError(e.getErrorMessage(), 500, "Token doesn't point to a lock.", null);
        }
        if (svnLock == null || !svnLock.getID().equals(lockToken)) {
            throw new DAVException("Lock refresh request doesn't match existing lock.", 401, 405);
        }
        try {
            svnLock = (FSLock)fsfs.lockPath(svnLock.getPath(), svnLock.getID(), resource.getUserName(), svnLock.getComment(), newTime, -1L, true, svnLock.isDAVComment());
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage();
            if (err.getErrorCode() == SVNErrorCode.FS_NO_USER) {
                throw new DAVException("Anonymous lock refreshing is not allowed.", 401, 405);
            }
            throw DAVException.convertError(err, 500, "Failed to refresh existing lock.", null);
        }
        return DAVLockInfoProvider.convertSVNLockToDAVLock(svnLock, false, resource.exists());
    }

    public void inheritLocks(DAVResource resource, boolean useParent) throws DAVException {
        DAVLock lock;
        DAVResource whichResource = resource;
        if (useParent) {
            DAVResource parentResource = DAVResourceHelper.createParentResource(resource);
            if (parentResource == null) {
                throw new DAVException("Could not fetch parent resource. Unable to inherit locks from the parent and apply them to this resource.", 500, 0);
            }
            whichResource = parentResource;
        }
        if ((lock = this.getLock(whichResource)) == null) {
            return;
        }
        DAVInheritWalker inheritHandler = new DAVInheritWalker(resource, lock, !useParent);
        DAVResourceWalker walker = new DAVResourceWalker();
        walker.walk(this, whichResource, null, 0, null, 6, inheritHandler, DAVDepth.DEPTH_INFINITY);
    }

    public void appendLock(DAVResource resource, DAVLock lock) throws DAVException {
        FSFS fsfs = resource.getFSFS();
        String path = resource.getResourceURI().getPath();
        if (!resource.exists()) {
            SVNProperties revisionProps = new SVNProperties();
            revisionProps.put("svn:author", resource.getUserName());
            DAVConfig config = resource.getRepositoryManager().getDAVConfig();
            if (resource.isSVNClient()) {
                throw new DAVException("Subversion clients may not lock nonexistent paths.", 405, 405);
            }
            if (!config.isAutoVersioning()) {
                throw new DAVException("Attempted to lock non-existent path; turn on autoversioning first.", 405, 405);
            }
            long youngestRev = -1L;
            try {
                youngestRev = resource.getLatestRevision();
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not determine youngest revision", null);
            }
            FSTransactionInfo txnInfo = null;
            try {
                txnInfo = FSTransactionRoot.beginTransactionForCommit((long)youngestRev, (SVNProperties)revisionProps, (FSFS)fsfs);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not begin a transaction", null);
            }
            FSTransactionRoot root = null;
            try {
                root = fsfs.createTransactionRoot(txnInfo);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not begin a transaction", null);
            }
            FSCommitter committer = new FSCommitter(fsfs, root, txnInfo, resource.getLockTokens(), resource.getUserName());
            try {
                committer.makeFile(path);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not create empty file.", null);
            }
            try {
                DAVServletUtil.attachAutoRevisionProperties(txnInfo, path, fsfs);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Could not create empty file.", null);
            }
            StringBuffer conflictPath = new StringBuffer();
            try {
                committer.commitTxn(true, true, null, conflictPath);
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 409, "Conflict when committing ''{0}''.", new Object[]{conflictPath.toString()});
            }
        }
        FSLock svnLock = DAVLockInfoProvider.convertDAVLockToSVNLock(lock, path, resource.isSVNClient(), ServletDAVHandler.getSAXParserFactory());
        try {
            fsfs.lockPath(path, svnLock.getID(), svnLock.getOwner(), svnLock.getComment(), svnLock.getExpirationDate(), this.myWorkingRevision, this.myIsStealLock, svnLock.isDAVComment());
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_USER) {
                throw new DAVException("Anonymous lock creation is not allowed.", 401, 405);
            }
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to create new lock.", null);
        }
        this.myOwner.setResponseHeader("X-SVN-Creation-Date", SVNDate.formatDate((Date)svnLock.getCreationDate()));
        this.myOwner.setResponseHeader("X-SVN-Lock-Owner", svnLock.getOwner());
    }

    public boolean hasLocks(DAVResource resource) throws DAVException {
        if (resource.getResourceURI().getPath() == null) {
            return false;
        }
        if ("LOCK".equals(this.myOwner.getRequestMethod())) {
            return false;
        }
        SVNLock lock = null;
        try {
            lock = resource.getLock();
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to check path for a lock.", null);
        }
        return lock != null;
    }

    public DAVLock getLock(DAVResource resource) throws DAVException {
        if (resource.getResourceURI().getPath() == null) {
            return null;
        }
        if ("LOCK".equals(this.myOwner.getRequestMethod())) {
            return null;
        }
        DAVLock davLock = null;
        FSLock lock = null;
        try {
            lock = (FSLock)resource.getLock();
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to check path for a lock.", null);
        }
        if (lock != null) {
            davLock = DAVLockInfoProvider.convertSVNLockToDAVLock(lock, this.myIsBreakLock, resource.exists());
            this.myOwner.setResponseHeader("X-SVN-Creation-Date", SVNDate.formatDate((Date)lock.getCreationDate()));
            this.myOwner.setResponseHeader("X-SVN-Lock-Owner", lock.getOwner());
        }
        return davLock;
    }

    public DAVLock findLock(DAVResource resource, String lockToken) throws DAVException {
        DAVLock davLock = null;
        FSLock lock = null;
        try {
            lock = (FSLock)resource.getLock();
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to look up lock by path.", null);
        }
        if (lock != null) {
            if (!lockToken.equals(lock.getID())) {
                throw new DAVException("Incoming token doesn't match existing lock.", 400, 405);
            }
            davLock = DAVLockInfoProvider.convertSVNLockToDAVLock(lock, false, resource.exists());
            this.myOwner.setResponseHeader("X-SVN-Creation-Date", SVNDate.formatDate((Date)lock.getCreationDate()));
            this.myOwner.setResponseHeader("X-SVN-Lock-Owner", lock.getOwner());
        }
        return davLock;
    }

    public void removeLock(DAVResource resource, String lockToken) throws DAVException {
        DAVResourceURI resourceURI = resource.getResourceURI();
        if (resourceURI.getPath() == null) {
            return;
        }
        if (this.isKeepLocks()) {
            return;
        }
        String token = null;
        SVNLock lock = null;
        if (lockToken == null) {
            try {
                lock = resource.getLock();
            }
            catch (SVNException svne) {
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to check path for a lock.", null);
            }
            if (lock != null) {
                token = lock.getID();
            }
        } else {
            token = lockToken;
        }
        if (token != null) {
            try {
                resource.unlock(token, this.isBreakLock());
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NO_USER) {
                    throw new DAVException("Anonymous lock removal is not allowed.", 401, 405);
                }
                throw DAVException.convertError(svne.getErrorMessage(), 500, "Failed to remove a lock.", null);
            }
        }
    }

    public String getSupportedLock(DAVResource resource) {
        if (resource.isCollection()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('\n');
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_ENTRY.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_SCOPE.getName(), (int)2, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.EXCLUSIVE.getName(), (int)6, null, (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_SCOPE.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_TYPE.getName(), (int)2, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.WRITE.getName(), (int)6, null, (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_TYPE.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_ENTRY.getName(), (StringBuffer)buffer);
        return buffer.toString();
    }

    public boolean isReadOnly() {
        return this.myIsReadOnly;
    }

    public boolean isStealLock() {
        return this.myIsStealLock;
    }

    public boolean isBreakLock() {
        return this.myIsBreakLock;
    }

    public boolean isKeepLocks() {
        return this.myIsKeepLocks;
    }

    public long getWorkingRevision() {
        return this.myWorkingRevision;
    }

    public static String getActiveLockXML(DAVLock lock) {
        StringBuffer buffer = new StringBuffer();
        if (lock == null) {
            return "";
        }
        if (lock.getRecType() == DAVLockRecType.INDIRECT_PARTIAL) {
            // empty if block
        }
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.ACTIVE_LOCK.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_TYPE.getName(), (int)2, null, (StringBuffer)buffer);
        if (lock.getType() == DAVLockType.WRITE) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.WRITE.getName(), (int)6, null, (StringBuffer)buffer);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_TYPE.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_SCOPE.getName(), (int)2, null, (StringBuffer)buffer);
        if (lock.getScope() == DAVLockScope.EXCLUSIVE) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.EXCLUSIVE.getName(), (int)6, null, (StringBuffer)buffer);
        } else if (lock.getScope() == DAVLockScope.SHARED) {
            SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.SHARED.getName(), (int)6, null, (StringBuffer)buffer);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_SCOPE.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.DEPTH.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append(lock.getDepth() == DAVDepth.DEPTH_INFINITY ? DAVDepth.DEPTH_INFINITY.toString() : DAVDepth.DEPTH_ZERO.toString());
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.DEPTH.getName(), (StringBuffer)buffer);
        if (lock.getOwner() != null) {
            buffer.append(lock.getOwner());
        }
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_TIMEOUT.getName(), (int)2, null, (StringBuffer)buffer);
        if (lock.getTimeOutDate() == null) {
            buffer.append("Infinite");
        } else {
            Date timeOutDate = lock.getTimeOutDate();
            long now = System.currentTimeMillis();
            long diff = timeOutDate.getTime() - now;
            buffer.append("Second-");
            buffer.append(diff);
        }
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_TIMEOUT.getName(), (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_TOKEN.getName(), (int)1, null, (StringBuffer)buffer);
        SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.HREF.getName(), (int)2, null, (StringBuffer)buffer);
        buffer.append(lock.getLockToken());
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.HREF.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_TOKEN.getName(), (StringBuffer)buffer);
        SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.ACTIVE_LOCK.getName(), (StringBuffer)buffer);
        return buffer.toString();
    }

    public static FSLock convertDAVLockToSVNLock(DAVLock davLock, String path, boolean isSVNClient, SAXParserFactory saxParserFactory) throws DAVException {
        if (davLock.getType() != DAVLockType.WRITE) {
            throw new DAVException("Only 'write' locks are supported.", 400, 405);
        }
        if (davLock.getScope() != DAVLockScope.EXCLUSIVE) {
            throw new DAVException("Only exclusive locks are supported.", 400, 405);
        }
        boolean isDAVComment = false;
        String comment = null;
        if (davLock.getOwner() != null) {
            if (isSVNClient) {
                try {
                    SAXParser xmlParser = saxParserFactory.newSAXParser();
                    XMLReader reader = xmlParser.getXMLReader();
                    FetchXMLHandler handler = new FetchXMLHandler(DAVElement.LOCK_OWNER);
                    reader.setContentHandler((ContentHandler)((Object)handler));
                    reader.setDTDHandler((DTDHandler)((Object)handler));
                    reader.setErrorHandler((ErrorHandler)((Object)handler));
                    reader.setEntityResolver((EntityResolver)((Object)handler));
                    String owner = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + davLock.getOwner();
                    reader.parse(new InputSource(new ByteArrayInputStream(owner.getBytes())));
                    comment = handler.getData();
                }
                catch (ParserConfigurationException e) {
                    throw new DAVException(e.getMessage(), 500, 405);
                }
                catch (SAXException e) {
                    throw new DAVException(e.getMessage(), 500, 405);
                }
                catch (IOException e) {
                    throw new DAVException(e.getMessage(), 500, 405);
                }
            } else {
                isDAVComment = true;
                comment = davLock.getOwner();
            }
        }
        return new FSLock(path, davLock.getLockToken(), davLock.getAuthUser(), comment, new Date(System.currentTimeMillis()), davLock.getTimeOutDate(), isDAVComment);
    }

    public static DAVLock convertSVNLockToDAVLock(FSLock lock, boolean hideAuthUser, boolean exists) {
        String authUser = null;
        StringBuffer owner = null;
        if (lock.getComment() != null) {
            owner = new StringBuffer();
            if (!lock.isDAVComment()) {
                ArrayList<String> namespaces = new ArrayList<String>(1);
                namespaces.add("DAV:");
                owner = DAVXMLUtil.openNamespaceDeclarationTag("D", DAVElement.LOCK_OWNER.getName(), namespaces, null, owner, false, false);
                owner.append(SVNEncodingUtil.xmlEncodeCDATA((String)lock.getComment(), (boolean)true));
                owner = SVNXMLUtil.addXMLFooter((String)"D", (String)DAVElement.LOCK_OWNER.getName(), (StringBuffer)owner);
            } else {
                owner.append(lock.getComment());
            }
        }
        if (!hideAuthUser) {
            authUser = lock.getOwner();
        }
        return new DAVLock(authUser, DAVDepth.DEPTH_ZERO, exists, lock.getID(), owner != null ? owner.toString() : null, DAVLockRecType.DIRECT, DAVLockScope.EXCLUSIVE, DAVLockType.WRITE, lock.getExpirationDate());
    }

    private static class FetchXMLHandler
    extends BasicDAVHandler {
        private String myData;
        private DAVElement myElement;

        public FetchXMLHandler(DAVElement element) {
            this.myElement = element;
            this.init();
        }

        public String getData() {
            return this.myData;
        }

        protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
            if (element == this.myElement) {
                this.myData = cdata.toString();
            }
        }

        protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        }
    }

    public static class GetLocksCallType {
        public static final GetLocksCallType RESOLVED = new GetLocksCallType();
        public static final GetLocksCallType PARTIAL = new GetLocksCallType();
        public static final GetLocksCallType COMPLETE = new GetLocksCallType();

        private GetLocksCallType() {
        }
    }
}

