/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVDepth;
import org.tmatesoft.svn.core.internal.server.dav.DAVException;
import org.tmatesoft.svn.core.internal.server.dav.DAVLock;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.DAVResourceState;
import org.tmatesoft.svn.core.internal.server.dav.DAVXMLUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockInfoProvider;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;

public class DAVLockHandler
extends ServletDAVHandler {
    private DAVLockRequest myLockRequest;

    protected DAVLockHandler(DAVRepositoryManager repositoryManager, HttpServletRequest request, HttpServletResponse response) {
        super(repositoryManager, request, response);
    }

    @Override
    public void execute() throws SVNException {
        long readLength = this.readInput(false);
        DAVDepth depth = null;
        try {
            depth = this.getRequestDepth(DAVDepth.DEPTH_INFINITY);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 400, null, null);
        }
        if (depth != DAVDepth.DEPTH_ZERO && depth != DAVDepth.DEPTH_INFINITY) {
            this.sendError(400, "Depth must be 0 or \"infinity\" for LOCK.");
            return;
        }
        DAVLockInfoProvider lockProvider = null;
        DAVResource resource = this.getRequestedDAVResource(false, false);
        try {
            lockProvider = DAVLockInfoProvider.createLockInfoProvider(this, false);
        }
        catch (SVNException svne) {
            throw DAVException.convertError(svne.getErrorMessage(), 500, null, null);
        }
        boolean isNewLockRequest = false;
        DAVLock lock = null;
        if (readLength > 0L) {
            lock = this.getLockRequest().parseLockInfo(this, resource, this.getNamespaces());
            isNewLockRequest = true;
        }
        DAVResourceState resourceState = this.getResourceState(resource);
        try {
            int flags = resourceState == DAVResourceState.NULL ? 32 : 16;
            this.validateRequest(resource, depth, flags |= 0x40, isNewLockRequest ? lock.getScope() : null, null, lockProvider);
        }
        catch (DAVException dave) {
            DAVException next = new DAVException("Could not LOCK {0} due to a failed precondition (e.g. other locks).", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)resource.getResourceURI().getRequestURI(), (boolean)true)}, dave.getResponseCode(), dave, 0);
            throw next;
        }
        if (!isNewLockRequest) {
            List lockTokens = null;
            try {
                lockTokens = this.getLockTokensList();
            }
            catch (DAVException dave) {
                DAVException next = new DAVException("The lock refresh for {0} failed because no lock tokens were specified in an \"If:\" header.", new Object[]{SVNEncodingUtil.xmlEncodeCDATA((String)resource.getResourceURI().getRequestURI(), (boolean)true)}, dave.getResponseCode(), dave, 0);
                throw next;
            }
            String lockToken = (String)lockTokens.get(0);
            lock = lockProvider.refreshLock(resource, lockToken, this.getTimeout());
        } else {
            if (lock.getTimeOutDate() != null) {
                // empty if block
            }
            lockProvider.addLock(lock, resource);
            this.setResponseHeader("Lock-Token", "<" + lock.getLockToken() + ">");
        }
        HttpServletResponse servletResponse = this.getHttpServletResponse();
        servletResponse.setContentType("text/xml; charset=\"utf-8\"");
        servletResponse.setStatus(200);
        try {
            StringBuffer xmlBuffer = SVNXMLUtil.addXMLHeader(null);
            DAVXMLUtil.openNamespaceDeclarationTag("D", DAVElement.PROP.getName(), null, null, xmlBuffer, true, false);
            if (lock == null) {
                SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_DISCOVERY.getName(), (int)4, null, (StringBuffer)xmlBuffer);
            } else {
                SVNXMLUtil.openXMLTag((String)"D", (String)DAVElement.LOCK_DISCOVERY.getName(), (int)2, null, (StringBuffer)xmlBuffer);
                xmlBuffer.append(DAVLockInfoProvider.getActiveLockXML(lock));
                xmlBuffer.append('\n');
                SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.LOCK_DISCOVERY.getName(), (StringBuffer)xmlBuffer);
            }
            SVNXMLUtil.closeXMLTag((String)"D", (String)DAVElement.PROP.getName(), (StringBuffer)xmlBuffer);
            this.getResponseWriter().write(xmlBuffer.toString());
        }
        catch (IOException e) {
            throw new DAVException(e.getMessage(), 500, 0);
        }
    }

    @Override
    protected DAVRequest getDAVRequest() {
        return this.getLockRequest();
    }

    private DAVLockRequest getLockRequest() {
        if (this.myLockRequest == null) {
            this.myLockRequest = new DAVLockRequest();
        }
        return this.myLockRequest;
    }
}

