/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.DAVResource;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDeleteRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNDate;

public class DAVHeadHandler
extends ServletDAVHandler {
    private DAVDeleteRequest myDAVRequest;

    protected DAVHeadHandler(DAVRepositoryManager connector, HttpServletRequest request, HttpServletResponse response) {
        super(connector, request, response);
    }

    @Override
    public void execute() throws SVNException {
        this.readInput(false);
        DAVResource resource = this.getRequestedDAVResource(false, false);
        if (!resource.exists()) {
            this.sendError(404, null);
            return;
        }
        try {
            this.setResponseContentType(resource.getContentType());
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        this.setResponseHeader("Accept-Ranges", "bytes");
        try {
            Date lastModifiedTime = resource.getLastModified();
            if (lastModifiedTime != null) {
                this.setResponseHeader("Last-Modified", SVNDate.formatRFC1123Date((Date)lastModifiedTime));
            }
        }
        catch (SVNException lastModifiedTime) {
            // empty catch block
        }
        String eTag = resource.getETag();
        if (eTag != null) {
            this.setResponseHeader("ETag", eTag);
        }
        this.setResponseStatus(204);
    }

    @Override
    protected DAVRequest getDAVRequest() {
        if (this.myDAVRequest == null) {
            this.myDAVRequest = new DAVDeleteRequest();
        }
        return this.myDAVRequest;
    }
}

