/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.server.dav.DAVRepositoryManager;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVCheckOutHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVCopyMoveHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVDeleteHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVGetHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVHeadHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVLockHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMakeActivityHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMakeCollectionHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVMergeHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVOptionsHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropPatchHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPropfindHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVPutHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVReportHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVUnlockHandler;
import org.tmatesoft.svn.core.internal.server.dav.handlers.ServletDAVHandler;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVHandlerFactory {
    public static final String METHOD_PROPFIND = "PROPFIND";
    public static final String METHOD_OPTIONS = "OPTIONS";
    public static final String METHOD_REPORT = "REPORT";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_DELETE = "DELETE";
    public static final String METHOD_TRACE = "TRACE";
    public static final String METHOD_PROPPATCH = "PROPPATCH";
    public static final String METHOD_COPY = "COPY";
    public static final String METHOD_MOVE = "MOVE";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_LOCK = "LOCK";
    public static final String METHOD_UNLOCK = "UNLOCK";
    public static final String METHOD_MKCOL = "MKCOL";
    public static final String METHOD_VERSION_CONTROL = "VERSION-CONTROL";
    public static final String METHOD_MKWORKSPACE = "MKWORKSPACE";
    public static final String METHOD_MKACTIVITY = "MKACTIVITY";
    public static final String METHOD_CHECKIN = "CHECKIN";
    public static final String METHOD_CHECKOUT = "CHECKOUT";
    public static final String METHOD_MERGE = "MERGE";

    public static ServletDAVHandler createHandler(DAVRepositoryManager manager, HttpServletRequest request, HttpServletResponse response) throws SVNException {
        String methodName = request.getMethod();
        if (METHOD_PROPFIND.equals(methodName)) {
            return new DAVPropfindHandler(manager, request, response);
        }
        if (METHOD_OPTIONS.equals(methodName)) {
            return new DAVOptionsHandler(manager, request, response);
        }
        if (METHOD_GET.equals(methodName)) {
            return new DAVGetHandler(manager, request, response);
        }
        if (METHOD_REPORT.equals(methodName)) {
            return new DAVReportHandler(manager, request, response);
        }
        if (METHOD_MKACTIVITY.equals(methodName)) {
            return new DAVMakeActivityHandler(manager, request, response);
        }
        if (METHOD_CHECKOUT.equals(methodName)) {
            return new DAVCheckOutHandler(manager, request, response);
        }
        if (METHOD_PUT.equals(methodName)) {
            return new DAVPutHandler(manager, request, response);
        }
        if (METHOD_DELETE.equals(methodName)) {
            return new DAVDeleteHandler(manager, request, response);
        }
        if (METHOD_COPY.equals(methodName)) {
            return new DAVCopyMoveHandler(manager, request, response, false);
        }
        if (METHOD_MOVE.equals(methodName)) {
            return new DAVCopyMoveHandler(manager, request, response, true);
        }
        if (METHOD_MKCOL.equals(methodName)) {
            return new DAVMakeCollectionHandler(manager, request, response);
        }
        if (METHOD_PROPPATCH.equals(methodName)) {
            return new DAVPropPatchHandler(manager, request, response);
        }
        if (METHOD_MERGE.equals(methodName)) {
            return new DAVMergeHandler(manager, request, response);
        }
        if (METHOD_LOCK.equals(methodName)) {
            return new DAVLockHandler(manager, request, response);
        }
        if (METHOD_UNLOCK.equals(methodName)) {
            return new DAVUnlockHandler(manager, request, response);
        }
        if (METHOD_HEAD.equals(methodName)) {
            return new DAVHeadHandler(manager, request, response);
        }
        SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Unknown request method ''{0}''", (Object)request.getMethod()), (SVNLogType)SVNLogType.NETWORK);
        return null;
    }
}

