/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.server.dav.handlers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.server.dav.DAVPathUtil;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVElementProperty;
import org.tmatesoft.svn.core.internal.server.dav.handlers.DAVRequest;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVGetLocationsRequest
extends DAVRequest {
    private static final DAVElement GET_LOCATIONS_REPORT = DAVElement.getElement((String)"svn:", (String)"get-locations-report");
    private static final DAVElement PEG_REVISION = DAVElement.getElement((String)"svn:", (String)"peg-revision");
    private static final DAVElement LOCATION_REVISION = DAVElement.getElement((String)"svn:", (String)"location-revision");
    private String myPath = null;
    private long myPegRevision = -1L;
    private Collection myRevisions;
    private long[] myRevisionsArray;

    public String getPath() {
        return this.myPath;
    }

    private void setPath(String path) {
        this.myPath = path;
    }

    public long getPegRevision() {
        return this.myPegRevision;
    }

    private void setPegRevision(long pegRevision) {
        this.myPegRevision = pegRevision;
    }

    public long[] getRevisions() {
        if (this.myRevisionsArray != null) {
            return this.myRevisionsArray;
        }
        if (this.myRevisions != null) {
            this.myRevisionsArray = new long[this.myRevisions.size()];
            int i = 0;
            for (Long revisionObject : this.myRevisions) {
                this.myRevisionsArray[i] = revisionObject;
                ++i;
            }
            this.myRevisions = null;
            return this.myRevisionsArray;
        }
        return null;
    }

    private void addRevision(long revision) {
        if (this.myRevisions == null) {
            this.myRevisions = new LinkedList();
        }
        this.myRevisions.add(new Long(revision));
    }

    @Override
    protected void init() throws SVNException {
        this.getRootElement().setElementName(GET_LOCATIONS_REPORT);
        List children = this.getRootElement().getChildren();
        for (DAVElementProperty property : children) {
            DAVElement element = property.getName();
            if (element == DAVElement.PATH) {
                String path = property.getFirstValue(false);
                DAVPathUtil.testCanonical(path);
                this.setPath(path);
                continue;
            }
            if (element == PEG_REVISION) {
                String pegRevisionString = property.getFirstValue(true);
                try {
                    this.setPegRevision(Long.parseLong(pegRevisionString));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
                continue;
            }
            if (element != LOCATION_REVISION) continue;
            Iterator revisionsIterator = property.getValues().iterator();
            while (revisionsIterator.hasNext()) {
                try {
                    this.addRevision(Long.parseLong((String)revisionsIterator.next()));
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (Throwable)nfe), (SVNLogType)SVNLogType.NETWORK);
                }
            }
        }
        if (this.getPath() == null && !SVNRevision.isValidRevisionNumber((long)this.getPegRevision())) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.RA_DAV_REQUEST_FAILED, (String)"Not all parameters passed."), (SVNLogType)SVNLogType.NETWORK);
        }
    }
}

